/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PullConstantsAboveGroupBy;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleTester;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.annotations.Test;

public class TestPullConstantsAboveGroupBy
extends BaseRuleTest {
    public TestPullConstantsAboveGroupBy() {
        super(new Plugin[0]);
    }

    @Test
    public void testNoConstGroupingKeysDoesNotFire() {
        this.tester().assertThat((Rule)new PullConstantsAboveGroupBy()).on(p -> p.aggregation(ab -> ab.source((PlanNode)p.project(Assignments.builder().put(p.variable("COL"), p.rowExpression("COL")).put(p.variable("CONST_COL"), p.rowExpression("1")).build(), (PlanNode)p.values(p.variable("COL")))).addAggregation(p.variable("AVG", (Type)DoubleType.DOUBLE), p.rowExpression("avg(COL)")).singleGroupingSet(p.variable("COL")))).doesNotFire();
    }

    @Test
    public void testMultipleGroupingSetsDoesNotFire() {
        this.tester().assertThat((Rule)new PullConstantsAboveGroupBy()).on(p -> p.aggregation(ab -> ab.source((PlanNode)p.project(Assignments.builder().put(p.variable("COL"), p.rowExpression("COL")).put(p.variable("CONST_COL"), p.rowExpression("1")).build(), (PlanNode)p.values(p.variable("COL")))).addAggregation(p.variable("AVG", (Type)DoubleType.DOUBLE), p.rowExpression("avg(COL)")).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)p.variable("COL")), (int)2, (Set)ImmutableSet.of((Object)0))))).doesNotFire();
    }

    @Test
    public void testRuleDisabledDoesNotFire() {
        RuleTester tester = new RuleTester((List<Plugin>)ImmutableList.of(), (Map<String, String>)ImmutableMap.of((Object)"optimize_constant_grouping_keys", (Object)"false", (Object)"rewrite_expression_with_constant_expression", (Object)"false"));
        tester.assertThat((Rule)new PullConstantsAboveGroupBy()).on(p -> p.aggregation(ab -> ab.source((PlanNode)p.project(Assignments.builder().put(p.variable("COL"), p.rowExpression("COL")).put(p.variable("CONST_COL"), p.rowExpression("1")).build(), (PlanNode)p.values(p.variable("COL")))).addAggregation(p.variable("AVG", (Type)DoubleType.DOUBLE), p.rowExpression("avg(COL)")).singleGroupingSet(p.variable("CONST_COL"), p.variable("COL")))).doesNotFire();
    }

    @Test
    public void testOnlyConstantKeysDoesNotFire() {
        this.tester().assertThat((Rule)new PullConstantsAboveGroupBy()).on(p -> p.aggregation(ab -> ab.source((PlanNode)p.project(Assignments.builder().put(p.variable("COL"), p.rowExpression("COL")).put(p.variable("CONST_COL"), p.rowExpression("1")).build(), (PlanNode)p.values(p.variable("COL")))).addAggregation(p.variable("AVG", (Type)DoubleType.DOUBLE), p.rowExpression("avg(COL)")).singleGroupingSet(p.variable("CONST_COL")))).doesNotFire();
    }

    @Test
    public void testSingleConstColumn() {
        this.tester().assertThat((Rule)new PullConstantsAboveGroupBy()).on(p -> p.aggregation(ab -> ab.source((PlanNode)p.project(Assignments.builder().put(p.variable("COL"), p.rowExpression("COL")).put(p.variable("CONST_COL"), p.rowExpression("1")).build(), (PlanNode)p.values(p.variable("COL")))).addAggregation(p.variable("AVG", (Type)DoubleType.DOUBLE), p.rowExpression("avg(COL)")).singleGroupingSet(p.variable("CONST_COL"), p.variable("COL")))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"CONST_COL", (Object)PlanMatchPattern.expression("1")), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("COL"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.builder().put(Optional.of("AVG"), PlanMatchPattern.functionCall("avg", (List<String>)ImmutableList.of((Object)"col"))).build(), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"CONST_COL", (Object)PlanMatchPattern.expression("1")), PlanMatchPattern.values("COL")))));
    }

    @Test
    public void testMultipleConstCols() {
        this.tester().assertThat((Rule)new PullConstantsAboveGroupBy()).on(p -> p.aggregation(ab -> ab.source((PlanNode)p.project(Assignments.builder().put(p.variable("COL"), p.rowExpression("COL")).put(p.variable("CONST_COL1"), p.rowExpression("1")).put(p.variable("CONST_COL2"), p.rowExpression("2")).build(), (PlanNode)p.values(p.variable("COL")))).addAggregation(p.variable("AVG", (Type)DoubleType.DOUBLE), p.rowExpression("avg(COL)")).singleGroupingSet(p.variable("CONST_COL1"), p.variable("COL"), p.variable("CONST_COL2")))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"CONST_COL1", (Object)PlanMatchPattern.expression("1"), (Object)"CONST_COL2", (Object)PlanMatchPattern.expression("2")), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("COL"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.builder().put(Optional.of("AVG"), PlanMatchPattern.functionCall("avg", (List<String>)ImmutableList.of((Object)"col"))).build(), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"CONST_COL1", (Object)PlanMatchPattern.expression("1"), (Object)"CONST_COL2", (Object)PlanMatchPattern.expression("2")), PlanMatchPattern.values("COL")))));
    }
}

