/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.block.MethodHandleUtil;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.rule.PullUpExpressionInLambdaRules;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.testing.TestingEnvironment;
import com.google.common.collect.ImmutableMap;
import java.lang.invoke.MethodHandle;
import java.util.Map;
import org.testng.annotations.Test;

public class TestPullUpExpressionInLambdaRules
extends BaseRuleTest {
    private static final MethodHandle KEY_NATIVE_EQUALS = TestingEnvironment.getOperatorMethodHandle((OperatorType)OperatorType.EQUAL, (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT});
    private static final MethodHandle KEY_BLOCK_EQUALS = MethodHandleUtil.compose((MethodHandle)KEY_NATIVE_EQUALS, (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)BigintType.BIGINT), (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)BigintType.BIGINT));
    private static final MethodHandle KEY_NATIVE_HASH_CODE = TestingEnvironment.getOperatorMethodHandle((OperatorType)OperatorType.HASH_CODE, (Type[])new Type[]{BigintType.BIGINT});
    private static final MethodHandle KEY_BLOCK_HASH_CODE = MethodHandleUtil.compose((MethodHandle)KEY_NATIVE_HASH_CODE, (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)BigintType.BIGINT));

    public TestPullUpExpressionInLambdaRules() {
        super(new Plugin[0]);
    }

    @Test
    public void testProjection() {
        this.tester().assertThat(new PullUpExpressionInLambdaRules(this.getFunctionManager()).projectNodeRule()).setSystemProperty("pull_expression_from_lambda_enabled", "true").on(p -> {
            p.variable("idmap", (Type)new MapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, KEY_BLOCK_EQUALS, KEY_BLOCK_HASH_CODE));
            return p.project(Assignments.builder().put(p.variable("expr"), p.rowExpression("map_filter(idmap, (k, v) -> array_position(array_sort(map_keys(idmap)), k) <= 200)")).build(), (PlanNode)p.values(p.variable("idmap", (Type)new MapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, KEY_BLOCK_EQUALS, KEY_BLOCK_HASH_CODE))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("map_filter(idmap, (k, v) -> (array_position(array_sort, k)) <= (INTEGER'200'))")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"array_sort", (Object)PlanMatchPattern.expression("array_sort(map_keys(idmap))")), PlanMatchPattern.values("idmap"))));
    }

    @Test
    public void testFilter() {
        this.tester().assertThat(new PullUpExpressionInLambdaRules(this.getFunctionManager()).filterNodeRule()).setSystemProperty("pull_expression_from_lambda_enabled", "true").on(p -> {
            p.variable("idmap", (Type)new MapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, KEY_BLOCK_EQUALS, KEY_BLOCK_HASH_CODE));
            return p.filter(p.rowExpression("cardinality(map_filter(idmap, (k, v) -> array_position(array_sort(map_keys(idmap)), k) <= 200)) > 0"), (PlanNode)p.values(p.variable("idmap", (Type)new MapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, KEY_BLOCK_EQUALS, KEY_BLOCK_HASH_CODE))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"idmap", (Object)PlanMatchPattern.expression("idmap")), PlanMatchPattern.filter("(cardinality(map_filter(idmap, (k, v) -> (array_position(array_sort, k)) <= (INTEGER'200')))) > (INTEGER'0')", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"array_sort", (Object)PlanMatchPattern.expression("array_sort(map_keys(idmap))")), PlanMatchPattern.values("idmap")))));
    }

    @Test
    public void testNonDeterministicProjection() {
        this.tester().assertThat(new PullUpExpressionInLambdaRules(this.getFunctionManager()).projectNodeRule()).setSystemProperty("pull_expression_from_lambda_enabled", "true").on(p -> {
            p.variable("idmap", (Type)new MapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, KEY_BLOCK_EQUALS, KEY_BLOCK_HASH_CODE));
            return p.project(Assignments.builder().put(p.variable("expr"), p.rowExpression("map_filter(idmap, (k, v) -> array_position(array[random()], k) <= 200)")).build(), (PlanNode)p.values(p.variable("idmap", (Type)new MapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, KEY_BLOCK_EQUALS, KEY_BLOCK_HASH_CODE))));
        }).doesNotFire();
    }

    @Test
    public void testNonDeterministicFilter() {
        this.tester().assertThat(new PullUpExpressionInLambdaRules(this.getFunctionManager()).filterNodeRule()).setSystemProperty("pull_expression_from_lambda_enabled", "true").on(p -> {
            p.variable("idmap", (Type)new MapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, KEY_BLOCK_EQUALS, KEY_BLOCK_HASH_CODE));
            return p.filter(p.rowExpression("cardinality(map_filter(idmap, (k, v) -> array_position(array_sort(array[random(), random()]), k) <= 200)) > 0"), (PlanNode)p.values(p.variable("idmap", (Type)new MapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, KEY_BLOCK_EQUALS, KEY_BLOCK_HASH_CODE))));
        }).doesNotFire();
    }

    @Test
    public void testNoValidProjection() {
        this.tester().assertThat(new PullUpExpressionInLambdaRules(this.getFunctionManager()).projectNodeRule()).setSystemProperty("pull_expression_from_lambda_enabled", "true").on(p -> {
            p.variable("idmap", (Type)new MapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, KEY_BLOCK_EQUALS, KEY_BLOCK_HASH_CODE));
            return p.project(Assignments.builder().put(p.variable("expr"), p.rowExpression("map_filter(idmap, (k, v) -> array_position(array_sort(array[v]), k) <= 200)")).build(), (PlanNode)p.values(p.variable("idmap", (Type)new MapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, KEY_BLOCK_EQUALS, KEY_BLOCK_HASH_CODE))));
        }).doesNotFire();
    }

    @Test
    public void testNoValidFilter() {
        this.tester().assertThat(new PullUpExpressionInLambdaRules(this.getFunctionManager()).filterNodeRule()).setSystemProperty("pull_expression_from_lambda_enabled", "true").on(p -> {
            p.variable("idmap", (Type)new MapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, KEY_BLOCK_EQUALS, KEY_BLOCK_HASH_CODE));
            return p.filter(p.rowExpression("cardinality(map_filter(idmap, (k, v) -> array_position(array_sort(array[v, k]), k) <= 200)) > 0"), (PlanNode)p.values(p.variable("idmap", (Type)new MapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, KEY_BLOCK_EQUALS, KEY_BLOCK_HASH_CODE))));
        }).doesNotFire();
    }

    @Test
    public void testNestedLambdaInProjection() {
        this.tester().assertThat(new PullUpExpressionInLambdaRules(this.getFunctionManager()).projectNodeRule()).setSystemProperty("pull_expression_from_lambda_enabled", "true").on(p -> {
            p.variable("expr", (Type)new ArrayType((Type)new ArrayType((Type)BigintType.BIGINT)));
            p.variable("arr1", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("arr2", (Type)new ArrayType((Type)BigintType.BIGINT));
            return p.project(Assignments.builder().put(p.variable("expr", (Type)new ArrayType((Type)new ArrayType((Type)BigintType.BIGINT))), p.rowExpression("transform(arr1, x->transform(arr2, y->slice(arr2, 1, 10)))")).build(), (PlanNode)p.values(p.variable("arr1", (Type)new ArrayType((Type)BigintType.BIGINT)), p.variable("arr2", (Type)new ArrayType((Type)BigintType.BIGINT))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("transform(arr1, (x) -> transform(arr2, (y) -> slice))")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"slice", (Object)PlanMatchPattern.expression("slice(arr2, 1, 10)")), PlanMatchPattern.values("arr1", "arr2"))));
    }

    @Test
    public void testInvalidNestedLambdaInProjection() {
        this.tester().assertThat(new PullUpExpressionInLambdaRules(this.getFunctionManager()).projectNodeRule()).setSystemProperty("pull_expression_from_lambda_enabled", "true").on(p -> {
            p.variable("expr", (Type)new ArrayType((Type)new ArrayType((Type)BigintType.BIGINT)));
            p.variable("arr1", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("arr2", (Type)new ArrayType((Type)BigintType.BIGINT));
            return p.project(Assignments.builder().put(p.variable("expr", (Type)new ArrayType((Type)new ArrayType((Type)BigintType.BIGINT))), p.rowExpression("transform(arr1, x->transform(arr2, y->slice(arr2, 1, x)))")).build(), (PlanNode)p.values(p.variable("arr1", (Type)new ArrayType((Type)BigintType.BIGINT)), p.variable("arr2", (Type)new ArrayType((Type)BigintType.BIGINT))));
        }).doesNotFire();
    }

    @Test
    public void testSkipTryFunction() {
        this.tester().assertThat(new PullUpExpressionInLambdaRules(this.getFunctionManager()).projectNodeRule()).setSystemProperty("pull_expression_from_lambda_enabled", "true").on(p -> {
            p.variable("x");
            return p.project(Assignments.builder().put(p.variable("expr", (Type)VarcharType.VARCHAR), p.rowExpression("JSON_FORMAT(CAST(TRY(MAP(ARRAY[NULL], ARRAY[x])) AS JSON))")).build(), (PlanNode)p.values(p.variable("x")));
        }).doesNotFire();
    }

    @Test
    public void testSwitchWhenExpression() {
        this.tester().assertThat(new PullUpExpressionInLambdaRules(this.getFunctionManager()).projectNodeRule()).setSystemProperty("pull_expression_from_lambda_enabled", "true").on(p -> {
            p.variable("arr", (Type)new ArrayType((Type)VarcharType.VARCHAR));
            p.variable("arr2", (Type)new ArrayType((Type)VarcharType.VARCHAR));
            return p.project(Assignments.builder().put(p.variable("expr", (Type)VarcharType.VARCHAR), p.rowExpression("transform(arr, x -> concat(case when arr2 is null then '*' when contains(arr2, x) then '+' else ' ' end, x))")).build(), (PlanNode)p.values(p.variable("arr", (Type)new ArrayType((Type)VarcharType.VARCHAR)), p.variable("arr2", (Type)new ArrayType((Type)VarcharType.VARCHAR))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("transform(arr, x -> concat(case when expr_0 then '*' when contains(arr2, x) then '+' else ' ' end, x))")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_0", (Object)PlanMatchPattern.expression("arr2 is null")), PlanMatchPattern.values("arr", "arr2"))));
    }

    @Test
    public void testInvalidSwitchWhenExpression() {
        this.tester().assertThat(new PullUpExpressionInLambdaRules(this.getFunctionManager()).projectNodeRule()).setSystemProperty("pull_expression_from_lambda_enabled", "true").on(p -> {
            p.variable("arr", (Type)new ArrayType((Type)VarcharType.VARCHAR));
            p.variable("arr2", (Type)new ArrayType((Type)VarcharType.VARCHAR));
            return p.project(Assignments.builder().put(p.variable("expr", (Type)VarcharType.VARCHAR), p.rowExpression("transform(arr, x -> concat(case when contains(arr2, x) then '*' when arr2 is null then '+' else ' ' end, x))")).build(), (PlanNode)p.values(p.variable("arr", (Type)new ArrayType((Type)VarcharType.VARCHAR)), p.variable("arr2", (Type)new ArrayType((Type)VarcharType.VARCHAR))));
        }).doesNotFire();
    }

    @Test
    public void testCaseWhenExpression() {
        this.tester().assertThat(new PullUpExpressionInLambdaRules(this.getFunctionManager()).projectNodeRule()).setSystemProperty("pull_expression_from_lambda_enabled", "true").on(p -> {
            p.variable("arr", (Type)new ArrayType((Type)VarcharType.VARCHAR));
            p.variable("arr2", (Type)new ArrayType((Type)VarcharType.VARCHAR));
            p.variable("col1");
            return p.project(Assignments.builder().put(p.variable("expr", (Type)VarcharType.VARCHAR), p.rowExpression("transform(arr, x -> concat(case (col1 > 2) when arr2 is null then '*' when contains(arr2, x) then '+' else ' ' end, x))")).build(), (PlanNode)p.values(p.variable("arr", (Type)new ArrayType((Type)VarcharType.VARCHAR)), p.variable("arr2", (Type)new ArrayType((Type)VarcharType.VARCHAR)), p.variable("col1")));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("transform(arr, x -> concat(case expr_1 when expr_0 then '*' when contains(arr2, x) then '+' else ' ' end, x))")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_0", (Object)PlanMatchPattern.expression("arr2 is null"), (Object)"expr_1", (Object)PlanMatchPattern.expression("col1>2")), PlanMatchPattern.values("arr", "arr2", "col1"))));
    }

    @Test
    public void testConditionalExpression() {
        this.tester().assertThat(new PullUpExpressionInLambdaRules(this.getFunctionManager()).projectNodeRule()).setSystemProperty("pull_expression_from_lambda_enabled", "true").on(p -> {
            p.variable("col1", (Type)new ArrayType((Type)BooleanType.BOOLEAN));
            p.variable("col2", (Type)new ArrayType((Type)BigintType.BIGINT));
            return p.project(Assignments.builder().put(p.variable("expr", (Type)VarcharType.VARCHAR), p.rowExpression("transform(col1, x -> if(x, col2[2], 0))")).build(), (PlanNode)p.values(p.variable("col1", (Type)new ArrayType((Type)BooleanType.BOOLEAN)), p.variable("col2", (Type)new ArrayType((Type)BigintType.BIGINT))));
        }).doesNotFire();
    }

    @Test
    public void testIfExpressionOnCondition() {
        this.tester().assertThat(new PullUpExpressionInLambdaRules(this.getFunctionManager()).projectNodeRule()).setSystemProperty("pull_expression_from_lambda_enabled", "true").on(p -> {
            p.variable("col1", (Type)new ArrayType((Type)BooleanType.BOOLEAN));
            p.variable("col2", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("col3");
            return p.project(Assignments.builder().put(p.variable("expr", (Type)VarcharType.VARCHAR), p.rowExpression("transform(col1, x -> if(col3 > 2, col2[2], 0))")).build(), (PlanNode)p.values(p.variable("col1", (Type)new ArrayType((Type)BooleanType.BOOLEAN)), p.variable("col2", (Type)new ArrayType((Type)BigintType.BIGINT)), p.variable("col3")));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("transform(col1, x -> if(greater_than, col2[2], 0))")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"greater_than", (Object)PlanMatchPattern.expression("col3>2")), PlanMatchPattern.values("col1", "col2", "col3"))));
    }

    @Test
    public void testIfExpressionOnValue() {
        this.tester().assertThat(new PullUpExpressionInLambdaRules(this.getFunctionManager()).projectNodeRule()).setSystemProperty("pull_expression_from_lambda_enabled", "true").on(p -> {
            p.variable("col1", (Type)new ArrayType((Type)BooleanType.BOOLEAN));
            p.variable("col2", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("col3");
            return p.project(Assignments.builder().put(p.variable("expr", (Type)VarcharType.VARCHAR), p.rowExpression("transform(col1, x -> if(x, col3 - 2, 0))")).build(), (PlanNode)p.values(p.variable("col1", (Type)new ArrayType((Type)BooleanType.BOOLEAN)), p.variable("col2", (Type)new ArrayType((Type)BigintType.BIGINT)), p.variable("col3")));
        }).doesNotFire();
    }

    @Test
    public void testSubscriptExpression() {
        this.tester().assertThat(new PullUpExpressionInLambdaRules(this.getFunctionManager()).projectNodeRule()).setSystemProperty("pull_expression_from_lambda_enabled", "true").on(p -> {
            p.variable("col1", (Type)new ArrayType((Type)BooleanType.BOOLEAN));
            p.variable("col2", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("col3");
            return p.project(Assignments.builder().put(p.variable("expr", (Type)VarcharType.VARCHAR), p.rowExpression("transform(col1, x -> col2[2])")).build(), (PlanNode)p.values(p.variable("col1", (Type)new ArrayType((Type)BooleanType.BOOLEAN)), p.variable("col2", (Type)new ArrayType((Type)BigintType.BIGINT)), p.variable("col3")));
        }).doesNotFire();
    }

    @Test
    public void testLikeExpression() {
        this.tester().assertThat(new PullUpExpressionInLambdaRules(this.getFunctionManager()).projectNodeRule()).setSystemProperty("pull_expression_from_lambda_enabled", "true").on(p -> {
            p.variable("expr", (Type)new ArrayType((Type)BooleanType.BOOLEAN));
            p.variable("col", (Type)VarcharType.VARCHAR);
            p.variable("arr1", (Type)new ArrayType((Type)VarcharType.VARCHAR));
            return p.project(Assignments.builder().put(p.variable("expr", (Type)new ArrayType((Type)BooleanType.BOOLEAN)), p.rowExpression("transform(arr1, x-> x like concat(col, 'a'))")).build(), (PlanNode)p.values(p.variable("arr1", (Type)new ArrayType((Type)VarcharType.VARCHAR)), p.variable("col", (Type)VarcharType.VARCHAR)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("transform(arr1, x -> x like concat_1)")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"concat_1", (Object)PlanMatchPattern.expression("concat(col, 'a')")), PlanMatchPattern.values("arr1", "col"))));
    }

    @Test
    public void testRegexpLikeExpression() {
        this.tester().assertThat(new PullUpExpressionInLambdaRules(this.getFunctionManager()).projectNodeRule()).setSystemProperty("pull_expression_from_lambda_enabled", "true").on(p -> {
            p.variable("expr", (Type)new ArrayType((Type)BooleanType.BOOLEAN));
            p.variable("col", (Type)VarcharType.VARCHAR);
            p.variable("arr1", (Type)new ArrayType((Type)VarcharType.VARCHAR));
            return p.project(Assignments.builder().put(p.variable("expr", (Type)new ArrayType((Type)BooleanType.BOOLEAN)), p.rowExpression("transform(arr1, x-> regexp_like(x, concat(col, 'a')))")).build(), (PlanNode)p.values(p.variable("arr1", (Type)new ArrayType((Type)VarcharType.VARCHAR)), p.variable("col", (Type)VarcharType.VARCHAR)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("transform(arr1, x -> regexp_like(x, concat_1))")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"concat_1", (Object)PlanMatchPattern.expression("concat(col, 'a')")), PlanMatchPattern.values("arr1", "col"))));
    }
}

