/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.Ordering;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.assertions.RvalueMatcher;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PushProjectionThroughExchange;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.tree.SortItem;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.testng.annotations.Test;

public class TestPushProjectionThroughExchange
extends BaseRuleTest {
    public TestPushProjectionThroughExchange() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFireNoExchange() {
        this.tester().assertThat((Rule)new PushProjectionThroughExchange()).on(p -> p.project(PlanBuilder.assignment(p.variable("x"), (RowExpression)Expressions.constant((Object)3L, (Type)BigintType.BIGINT)), (PlanNode)p.values(p.variable("a")))).doesNotFire();
    }

    @Test
    public void testDoesNotFireNarrowingProjection() {
        this.tester().assertThat((Rule)new PushProjectionThroughExchange()).on(p -> {
            VariableReferenceExpression a = p.variable("a");
            VariableReferenceExpression b = p.variable("b");
            VariableReferenceExpression c = p.variable("c");
            return p.project(Assignments.builder().put(a, (RowExpression)a).put(b, (RowExpression)b).build(), (PlanNode)p.exchange(e -> e.addSource((PlanNode)p.values(a, b, c)).addInputsSet(a, b, c).singleDistributionPartitioningScheme(a, b, c)));
        }).doesNotFire();
    }

    @Test
    public void testSimpleMultipleInputs() {
        this.tester().assertThat((Rule)new PushProjectionThroughExchange()).on(p -> {
            VariableReferenceExpression a = p.variable("a");
            VariableReferenceExpression b = p.variable("b");
            VariableReferenceExpression c = p.variable("c");
            VariableReferenceExpression c2 = p.variable("c2");
            VariableReferenceExpression x = p.variable("x");
            return p.project(PlanBuilder.assignment(x, (RowExpression)Expressions.constant((Object)3L, (Type)BigintType.BIGINT), c2, (RowExpression)c), (PlanNode)p.exchange(e -> e.addSource((PlanNode)p.values(a)).addSource((PlanNode)p.values(b)).addInputsSet(a).addInputsSet(b).singleDistributionPartitioningScheme(c)));
        }).matches(PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"))).withAlias("x1", (RvalueMatcher)PlanMatchPattern.expression("3")), PlanMatchPattern.project(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"b"))).withAlias("x2", (RvalueMatcher)PlanMatchPattern.expression("3"))).withAlias("x1").withAlias("x2"));
    }

    @Test
    public void testPartitioningColumnAndHashWithoutIdentityMappingInProjection() {
        this.tester().assertThat((Rule)new PushProjectionThroughExchange()).on(p -> {
            VariableReferenceExpression a = p.variable("a");
            VariableReferenceExpression b = p.variable("b");
            VariableReferenceExpression h = p.variable("h");
            VariableReferenceExpression aTimes5 = p.variable("a_times_5");
            VariableReferenceExpression bTimes5 = p.variable("b_times_5");
            VariableReferenceExpression hTimes5 = p.variable("h_times_5");
            return p.project(Assignments.builder().put(aTimes5, (RowExpression)p.binaryOperation(OperatorType.MULTIPLY, (RowExpression)a, (RowExpression)Expressions.constant((Object)5L, (Type)BigintType.BIGINT))).put(bTimes5, (RowExpression)p.binaryOperation(OperatorType.MULTIPLY, (RowExpression)b, (RowExpression)Expressions.constant((Object)5L, (Type)BigintType.BIGINT))).put(hTimes5, (RowExpression)p.binaryOperation(OperatorType.MULTIPLY, (RowExpression)h, (RowExpression)Expressions.constant((Object)5L, (Type)BigintType.BIGINT))).build(), (PlanNode)p.exchange(e -> e.addSource((PlanNode)p.values(a, b, h)).addInputsSet(a, b, h).fixedHashDistributionPartitioningScheme((List<VariableReferenceExpression>)ImmutableList.of((Object)a, (Object)b, (Object)h), (List<VariableReferenceExpression>)ImmutableList.of((Object)b), h)));
        }).matches(PlanMatchPattern.project(PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"h"))).withNumberOfOutputColumns(5).withAlias("b", (RvalueMatcher)PlanMatchPattern.expression("b")).withAlias("h", (RvalueMatcher)PlanMatchPattern.expression("h")).withAlias("a_times_5", (RvalueMatcher)PlanMatchPattern.expression("a * 5")).withAlias("b_times_5", (RvalueMatcher)PlanMatchPattern.expression("b * 5")).withAlias("h_times_5", (RvalueMatcher)PlanMatchPattern.expression("h * 5")))).withNumberOfOutputColumns(3).withExactOutputs("a_times_5", "b_times_5", "h_times_5"));
    }

    @Test
    public void testOrderingColumnsArePreserved() {
        this.tester().assertThat((Rule)new PushProjectionThroughExchange()).on(p -> {
            VariableReferenceExpression a = p.variable("a");
            VariableReferenceExpression b = p.variable("b");
            VariableReferenceExpression h = p.variable("h");
            VariableReferenceExpression aTimes5 = p.variable("a_times_5");
            VariableReferenceExpression bTimes5 = p.variable("b_times_5");
            VariableReferenceExpression hTimes5 = p.variable("h_times_5");
            VariableReferenceExpression sortVariable = p.variable("sortVariable");
            OrderingScheme orderingScheme = new OrderingScheme((List)ImmutableList.of((Object)new Ordering(sortVariable, SortOrder.ASC_NULLS_FIRST)));
            return p.project(Assignments.builder().put(aTimes5, (RowExpression)p.binaryOperation(OperatorType.MULTIPLY, (RowExpression)a, (RowExpression)Expressions.constant((Object)5L, (Type)BigintType.BIGINT))).put(bTimes5, (RowExpression)p.binaryOperation(OperatorType.MULTIPLY, (RowExpression)b, (RowExpression)Expressions.constant((Object)5L, (Type)BigintType.BIGINT))).put(hTimes5, (RowExpression)p.binaryOperation(OperatorType.MULTIPLY, (RowExpression)h, (RowExpression)Expressions.constant((Object)5L, (Type)BigintType.BIGINT))).build(), (PlanNode)p.exchange(e -> e.addSource((PlanNode)p.values(a, b, h, sortVariable)).addInputsSet(a, b, h, sortVariable).singleDistributionPartitioningScheme((List<VariableReferenceExpression>)ImmutableList.of((Object)a, (Object)b, (Object)h, (Object)sortVariable)).setEnsureSourceOrdering(true).orderingScheme(orderingScheme)));
        }).matches(PlanMatchPattern.project(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.GATHER, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("sortSymbol", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.project(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"h", (Object)"sortSymbol"))).withNumberOfOutputColumns(4).withAlias("a_times_5", (RvalueMatcher)PlanMatchPattern.expression("a * 5")).withAlias("b_times_5", (RvalueMatcher)PlanMatchPattern.expression("b * 5")).withAlias("h_times_5", (RvalueMatcher)PlanMatchPattern.expression("h * 5")).withAlias("sortSymbol", (RvalueMatcher)PlanMatchPattern.expression("sortSymbol")))).withNumberOfOutputColumns(3).withExactOutputs("a_times_5", "b_times_5", "h_times_5"));
    }
}

