/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.plan.DistinctLimitNode;
import com.facebook.presto.spi.plan.LogicalPropertiesProvider;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.TestTableConstraintsConnectorFactory;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.properties.LogicalPropertiesProviderImpl;
import com.facebook.presto.sql.planner.iterative.rule.MergeLimitWithDistinct;
import com.facebook.presto.sql.planner.iterative.rule.RemoveRedundantDistinctLimit;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleTester;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestRedundantDistinctLimitRemoval
extends BaseRuleTest {
    private LogicalPropertiesProviderImpl logicalPropertiesProvider;

    public TestRedundantDistinctLimitRemoval() {
        super(new Plugin[0]);
    }

    @Override
    @BeforeClass
    public final void setUp() {
        this.tester = new RuleTester(Collections.emptyList(), (Map<String, String>)ImmutableMap.of((Object)"exploit_constraints", (Object)Boolean.toString(true)), Optional.of(1), (ConnectorFactory)new TestTableConstraintsConnectorFactory(1));
        this.logicalPropertiesProvider = new LogicalPropertiesProviderImpl(new FunctionResolution(this.tester.getMetadata().getFunctionAndTypeManager().getFunctionAndTypeResolver()));
    }

    @Test
    public void singleTableTests() {
        this.tester().assertThat((Rule)new RemoveRedundantDistinctLimit(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> p.distinctLimit(10L, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("c")), (PlanNode)p.values(1, p.variable("c")))).matches(PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]));
        this.tester().assertThat((Rule)new RemoveRedundantDistinctLimit(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> p.distinctLimit(0L, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("c")), (PlanNode)p.values(1, p.variable("c")))).matches(PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new MergeLimitWithDistinct(), (Object)new RemoveRedundantDistinctLimit()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT distinct(c) FROM (SELECT count(*) as c FROM orders) LIMIT 10").validates(plan -> this.assertNodeRemovedFromPlan((Plan)plan, DistinctLimitNode.class));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new MergeLimitWithDistinct(), (Object)new RemoveRedundantDistinctLimit()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT distinct(c) FROM (SELECT count(*) as c FROM orders GROUP BY orderkey) LIMIT 10").matches(PlanMatchPattern.output(PlanMatchPattern.node(DistinctLimitNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")))));
    }

    @Test
    public void complexQueryTests() {
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new MergeLimitWithDistinct(), (Object)new RemoveRedundantDistinctLimit()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("select distinct totalprice from orders o inner join customer c on o.custkey = c.custkey where o.orderkey=10 limit 2").validates(plan -> this.assertNodeRemovedFromPlan((Plan)plan, DistinctLimitNode.class));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new MergeLimitWithDistinct(), (Object)new RemoveRedundantDistinctLimit()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("select distinct totalprice from orders o inner join customer c on o.custkey = c.custkey where o.orderkey>10 limit 2").validates(plan -> this.assertNodePresentInPlan((Plan)plan, DistinctLimitNode.class));
    }

    @Test
    public void doesNotFire() {
        this.tester().assertThat((Rule)new RemoveRedundantDistinctLimit(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> p.distinctLimit(10L, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("c")), (PlanNode)p.values(10, p.variable("c")))).doesNotFire();
    }

    @Test
    public void testFeatureDisabled() {
        RuleTester newTester = new RuleTester(Collections.emptyList(), (Map<String, String>)ImmutableMap.of((Object)"exploit_constraints", (Object)Boolean.toString(false)));
        newTester.assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new MergeLimitWithDistinct(), (Object)new RemoveRedundantDistinctLimit()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("select distinct totalprice from orders o inner join customer c on o.custkey = c.custkey where o.orderkey=10 limit 2").validates(plan -> this.assertNodePresentInPlan((Plan)plan, DistinctLimitNode.class));
    }
}

