/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.LogicalPropertiesProvider;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.TestTableConstraintsConnectorFactory;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.properties.LogicalPropertiesProviderImpl;
import com.facebook.presto.sql.planner.iterative.rule.RemoveRedundantLimit;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleTester;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestRedundantLimitRemoval
extends BaseRuleTest {
    private LogicalPropertiesProviderImpl logicalPropertiesProvider;

    public TestRedundantLimitRemoval() {
        super(new Plugin[0]);
    }

    @Override
    @BeforeClass
    public final void setUp() {
        this.tester = new RuleTester(Collections.emptyList(), (Map<String, String>)ImmutableMap.of((Object)"exploit_constraints", (Object)Boolean.toString(true)), Optional.of(1), (ConnectorFactory)new TestTableConstraintsConnectorFactory(1));
        this.logicalPropertiesProvider = new LogicalPropertiesProviderImpl(new FunctionResolution(this.tester.getMetadata().getFunctionAndTypeManager().getFunctionAndTypeResolver()));
    }

    @Test
    public void singleTableTests() {
        this.tester().assertThat((Rule)new RemoveRedundantLimit(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> p.limit(10L, (PlanNode)p.aggregation(builder -> builder.source((PlanNode)p.values(p.variable("foo"))).addAggregation(p.variable("c"), p.rowExpression("count(foo)")).globalGrouping()))).matches(PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])));
        this.tester().assertThat((Rule)new RemoveRedundantLimit(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            VariableReferenceExpression c = p.variable("c");
            return p.limit(10L, (PlanNode)p.values(5, c));
        }).matches(PlanMatchPattern.values("c"));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantLimit()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT count(*) FROM orders LIMIT 2").validates(plan -> this.assertNodeRemovedFromPlan((Plan)plan, LimitNode.class));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantLimit()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT * FROM (VALUES 1,2,3,4,5,6) AS t1 LIMIT 10").matches(PlanMatchPattern.output(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"x"))));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantLimit()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("select a from orders inner join (values(2)) t(a) ON orderkey=1 limit 3").validates(plan -> this.assertNodeRemovedFromPlan((Plan)plan, LimitNode.class));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantLimit()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT orderkey, count(*) FROM orders GROUP BY orderkey ORDER BY 1 LIMIT 10").validates(plan -> this.assertNodePresentInPlan((Plan)plan, LimitNode.class));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantLimit()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("select a from orders left join (values(2)) t(a) ON orderkey=1 limit 3").validates(plan -> this.assertNodePresentInPlan((Plan)plan, LimitNode.class));
    }

    @Test
    public void complexQueryTests() {
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantLimit()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("select totalprice from orders o inner join customer c on o.custkey = c.custkey where o.orderkey=10 limit 2").validates(plan -> this.assertNodeRemovedFromPlan((Plan)plan, LimitNode.class));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantLimit()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("select totalprice from orders o inner join customer c on o.custkey = c.custkey where o.orderkey>10 limit 2").validates(plan -> this.assertNodePresentInPlan((Plan)plan, LimitNode.class));
    }

    @Test
    public void doesNotFire() {
        this.tester().assertThat((Rule)new RemoveRedundantLimit(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            VariableReferenceExpression c = p.variable("c");
            return p.limit(10L, (PlanNode)p.values(12, c));
        }).doesNotFire();
    }

    @Test
    public void testFeatureDisabled() {
        RuleTester newTester = new RuleTester(Collections.emptyList(), (Map<String, String>)ImmutableMap.of((Object)"exploit_constraints", (Object)Boolean.toString(false)));
        newTester.assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantLimit()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("select totalprice from orders o inner join customer c on o.custkey = c.custkey where o.orderkey=10 limit 2").validates(plan -> this.assertNodePresentInPlan((Plan)plan, LimitNode.class));
    }
}

