/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.LogicalPropertiesProvider;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.properties.LogicalPropertiesProviderImpl;
import com.facebook.presto.sql.planner.iterative.rule.MergeLimitWithSort;
import com.facebook.presto.sql.planner.iterative.rule.RemoveRedundantSortColumns;
import com.facebook.presto.sql.planner.iterative.rule.RemoveRedundantTopNColumns;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleTester;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.tree.SortItem;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestRedundantSortColumnsRemoval
extends BaseRuleTest {
    private LogicalPropertiesProviderImpl logicalPropertiesProvider;

    public TestRedundantSortColumnsRemoval() {
        super(new Plugin[0]);
    }

    @Override
    @BeforeClass
    public final void setUp() {
        this.tester = new RuleTester(Collections.emptyList(), (Map<String, String>)ImmutableMap.of((Object)"exploit_constraints", (Object)Boolean.toString(true)));
        this.logicalPropertiesProvider = new LogicalPropertiesProviderImpl(new FunctionResolution(this.tester.getMetadata().getFunctionAndTypeManager().getFunctionAndTypeResolver()));
    }

    @Test
    public void testRemoveRedundantColumnsFromTopN() {
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new MergeLimitWithSort(), (Object)new RemoveRedundantTopNColumns()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT orderkey, custkey, sum(totalprice), min(orderdate) FROM orders GROUP BY orderkey, custkey ORDER BY orderkey, custkey, sum(totalprice), min(orderdate) LIMIT 10").matches(TestRedundantSortColumnsRemoval.topNMatchWith((ImmutableList<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("ORDERKEY", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST), (Object)PlanMatchPattern.sort("CUSTKEY", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST))));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new MergeLimitWithSort(), (Object)new RemoveRedundantTopNColumns()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT orderkey, custkey, sum(totalprice), min(orderdate) FROM orders GROUP BY orderkey, custkey ORDER BY custkey, orderkey, sum(totalprice), min(orderdate) LIMIT 10").matches(TestRedundantSortColumnsRemoval.topNMatchWith((ImmutableList<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("CUSTKEY", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST), (Object)PlanMatchPattern.sort("ORDERKEY", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST))));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new MergeLimitWithSort(), (Object)new RemoveRedundantTopNColumns()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT orderkey, custkey, sum(totalprice), min(orderdate) FROM orders GROUP BY orderkey, custkey ORDER BY custkey DESC, orderkey ASC, sum(totalprice), min(orderdate) LIMIT 10").matches(TestRedundantSortColumnsRemoval.topNMatchWith((ImmutableList<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("CUSTKEY", SortItem.Ordering.DESCENDING, SortItem.NullOrdering.LAST), (Object)PlanMatchPattern.sort("ORDERKEY", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST))));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new MergeLimitWithSort(), (Object)new RemoveRedundantTopNColumns()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT orderkey, custkey, sum(totalprice), min(orderdate) FROM orders GROUP BY orderkey, custkey ORDER BY orderkey, sum(totalprice), custkey, min(orderdate) LIMIT 10").doesNotMatch(TestRedundantSortColumnsRemoval.topNMatchWith((ImmutableList<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("ORDERKEY", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST), (Object)PlanMatchPattern.sort("CUSTKEY", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST))));
    }

    @Test
    public void testRemoveRedundantColumnsFromSort() {
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantSortColumns()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT orderkey, custkey, sum(totalprice), min(orderdate) FROM orders GROUP BY orderkey, custkey ORDER BY orderkey, custkey, sum(totalprice), min(orderdate)").matches(TestRedundantSortColumnsRemoval.sortWith((ImmutableList<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("ORDERKEY", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST), (Object)PlanMatchPattern.sort("CUSTKEY", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST))));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantSortColumns()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT orderkey, custkey, sum(totalprice), min(orderdate) FROM orders GROUP BY orderkey, custkey ORDER BY custkey, orderkey, sum(totalprice), min(orderdate)").matches(TestRedundantSortColumnsRemoval.sortWith((ImmutableList<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("CUSTKEY", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST), (Object)PlanMatchPattern.sort("ORDERKEY", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST))));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantSortColumns()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT orderkey, custkey, sum(totalprice), min(orderdate) FROM orders GROUP BY orderkey, custkey ORDER BY custkey DESC, orderkey ASC, sum(totalprice), min(orderdate)").matches(TestRedundantSortColumnsRemoval.sortWith((ImmutableList<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("CUSTKEY", SortItem.Ordering.DESCENDING, SortItem.NullOrdering.LAST), (Object)PlanMatchPattern.sort("ORDERKEY", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST))));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantSortColumns()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT orderkey, custkey, sum(totalprice), min(orderdate) FROM orders GROUP BY orderkey, custkey ORDER BY orderkey, sum(totalprice), custkey, min(orderdate)").doesNotMatch(TestRedundantSortColumnsRemoval.sortWith((ImmutableList<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("ORDERKEY", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST), (Object)PlanMatchPattern.sort("CUSTKEY", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST))));
    }

    private static PlanMatchPattern topNMatchWith(ImmutableList<PlanMatchPattern.Ordering> orderBy) {
        return PlanMatchPattern.output(PlanMatchPattern.topN(10L, orderBy, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY", (Object)"orderkey", (Object)"CUSTKEY", (Object)"custkey")))));
    }

    private static PlanMatchPattern sortWith(ImmutableList<PlanMatchPattern.Ordering> orderBy) {
        return PlanMatchPattern.output(PlanMatchPattern.sort(orderBy, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY", (Object)"orderkey", (Object)"CUSTKEY", (Object)"custkey")))));
    }
}

