/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.LogicalPropertiesProvider;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.TestTableConstraintsConnectorFactory;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.properties.LogicalPropertiesProviderImpl;
import com.facebook.presto.sql.planner.iterative.rule.MergeLimitWithSort;
import com.facebook.presto.sql.planner.iterative.rule.RemoveRedundantTopN;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleTester;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestRedundantTopNRemoval
extends BaseRuleTest {
    private LogicalPropertiesProviderImpl logicalPropertiesProvider;

    public TestRedundantTopNRemoval() {
        super(new Plugin[0]);
    }

    @Override
    @BeforeClass
    public final void setUp() {
        this.tester = new RuleTester(Collections.emptyList(), (Map<String, String>)ImmutableMap.of((Object)"exploit_constraints", (Object)Boolean.toString(true)), Optional.of(1), (ConnectorFactory)new TestTableConstraintsConnectorFactory(1));
        this.logicalPropertiesProvider = new LogicalPropertiesProviderImpl(new FunctionResolution(this.tester.getMetadata().getFunctionAndTypeManager().getFunctionAndTypeResolver()));
    }

    @Test
    public void singleTableTests() {
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new MergeLimitWithSort(), (Object)new RemoveRedundantTopN()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT totalprice FROM orders WHERE orderkey = 10 ORDER BY totalprice LIMIT 10").validates(plan -> this.assertNodeRemovedFromPlan((Plan)plan, TopNNode.class));
        this.tester().assertThat((Rule)new RemoveRedundantTopN(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> p.topN(10L, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("c")), (PlanNode)p.aggregation(builder -> builder.source((PlanNode)p.values(p.variable("foo"))).addAggregation(p.variable("c"), p.rowExpression("count(foo)")).globalGrouping()))).matches(PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new MergeLimitWithSort(), (Object)new RemoveRedundantTopN()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT count(*) FROM orders ORDER BY 1 LIMIT 10").validates(plan -> this.assertNodeRemovedFromPlan((Plan)plan, TopNNode.class));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new MergeLimitWithSort()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT totalprice FROM orders WHERE orderkey = 10 ORDER BY totalprice LIMIT 10").validates(plan -> this.assertNodePresentInPlan((Plan)plan, TopNNode.class));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new MergeLimitWithSort(), (Object)new RemoveRedundantTopN()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT orderkey, count(*) FROM orders GROUP BY orderkey ORDER BY 1 LIMIT 10").matches(PlanMatchPattern.output(PlanMatchPattern.node(TopNNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")))));
    }

    @Test
    public void complexQueryTests() {
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new MergeLimitWithSort(), (Object)new RemoveRedundantTopN()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("select totalprice from orders o inner join customer c on o.custkey = c.custkey where o.orderkey=10 order by totalprice limit 10").validates(plan -> this.assertNodeRemovedFromPlan((Plan)plan, TopNNode.class));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new MergeLimitWithSort(), (Object)new RemoveRedundantTopN()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("select a from orders join (values(2)) t(a) ON orderkey=1 order by orderkey limit 3").validates(plan -> this.assertNodeRemovedFromPlan((Plan)plan, TopNNode.class));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new MergeLimitWithSort()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("select totalprice from orders o inner join customer c on o.custkey = c.custkey where o.orderkey=10 order by totalprice limit 10").validates(plan -> this.assertNodePresentInPlan((Plan)plan, TopNNode.class));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new MergeLimitWithSort(), (Object)new RemoveRedundantTopN()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("select a from orders left join (values(2)) t(a) ON orderkey=1 order by orderkey limit 3").validates(plan -> this.assertNodePresentInPlan((Plan)plan, TopNNode.class));
    }

    @Test
    public void doesNotFire() {
        this.tester().assertThat((Rule)new RemoveRedundantTopN(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> p.topN(10L, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("c")), (PlanNode)p.aggregation(builder -> builder.source((PlanNode)p.values(20, p.variable("foo"))).addAggregation(p.variable("c"), p.rowExpression("count(foo)")).singleGroupingSet(p.variable("foo"))))).doesNotFire();
    }

    @Test
    public void testFeatureDisabled() {
        RuleTester newTester = new RuleTester(Collections.emptyList(), (Map<String, String>)ImmutableMap.of((Object)"exploit_constraints", (Object)Boolean.toString(false)));
        newTester.assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new MergeLimitWithSort(), (Object)new RemoveRedundantTopN()), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on("SELECT totalprice FROM orders WHERE orderkey = 10 ORDER BY totalprice LIMIT 10").validates(plan -> this.assertNodePresentInPlan((Plan)plan, TopNNode.class));
    }
}

