/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.RemoveIdentityProjectionsBelowProjection;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.testng.annotations.Test;

public class TestRemoveIdentityProjectionsBelowProjection
extends BaseRuleTest {
    public TestRemoveIdentityProjectionsBelowProjection() {
        super(new Plugin[0]);
    }

    @Test
    public void testTopProjectUseAllOfIdentityProject() {
        this.tester().assertThat((Rule)new RemoveIdentityProjectionsBelowProjection()).on(p -> {
            VariableReferenceExpression a = p.variable("a");
            VariableReferenceExpression b = p.variable("b");
            VariableReferenceExpression c = p.variable("c");
            return p.project(PlanBuilder.assignment(a, p.rowExpression("b+1")), (PlanNode)p.project(AssignmentUtils.identityAssignments((VariableReferenceExpression[])new VariableReferenceExpression[]{b}), (PlanNode)p.values(c, b)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("b+1")), PlanMatchPattern.values("c", "b")));
    }

    @Test
    public void testTopProjectUseSubSetOfIdentityProject() {
        this.tester().assertThat((Rule)new RemoveIdentityProjectionsBelowProjection()).on(p -> {
            VariableReferenceExpression a = p.variable("a");
            VariableReferenceExpression b = p.variable("b");
            VariableReferenceExpression c = p.variable("c");
            VariableReferenceExpression d = p.variable("d");
            return p.project(PlanBuilder.assignment(a, p.rowExpression("b+1")), (PlanNode)p.project(AssignmentUtils.identityAssignments((VariableReferenceExpression[])new VariableReferenceExpression[]{b, c}), (PlanNode)p.values(c, b, d)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("b+1")), PlanMatchPattern.values("c", "b", "d")));
    }
}

