/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.RemoveRedundantCastToVarcharInJoinClause;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestRemoveRedundantCastToVarcharInJoinClause
extends BaseRuleTest {
    public TestRemoveRedundantCastToVarcharInJoinClause() {
        super(new Plugin[0]);
    }

    @Test
    public void testCastBigIntToVarchar() {
        this.tester().assertThat((Rule)new RemoveRedundantCastToVarcharInJoinClause(this.getFunctionManager())).setSystemProperty("remove_redundant_cast_to_varchar_in_join", "true").on(p -> {
            VariableReferenceExpression leftBigint = p.variable("left_bigint");
            VariableReferenceExpression rightBigint = p.variable("right_bigint");
            VariableReferenceExpression leftCast = p.variable("left_cast", (Type)VarcharType.VARCHAR);
            VariableReferenceExpression rightCast = p.variable("right_cast", (Type)VarcharType.VARCHAR);
            return p.join(JoinType.INNER, (PlanNode)p.project(PlanBuilder.assignment(leftCast, p.rowExpression("cast(left_bigint as varchar)")), (PlanNode)p.values(leftBigint)), (PlanNode)p.project(PlanBuilder.assignment(rightCast, p.rowExpression("cast(right_bigint as varchar)")), (PlanNode)p.values(rightBigint)), new EquiJoinClause(leftCast, rightCast));
        }).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("new_left", "new_right")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"new_left", (Object)PlanMatchPattern.expression("left_bigint")), PlanMatchPattern.values("left_bigint")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"new_right", (Object)PlanMatchPattern.expression("right_bigint")), PlanMatchPattern.values("right_bigint"))));
    }

    @Test
    public void testCastIntToBigint() {
        this.tester().assertThat((Rule)new RemoveRedundantCastToVarcharInJoinClause(this.getFunctionManager())).setSystemProperty("remove_redundant_cast_to_varchar_in_join", "true").on(p -> {
            VariableReferenceExpression leftBigint = p.variable("left_bigint", (Type)IntegerType.INTEGER);
            VariableReferenceExpression rightBigint = p.variable("right_bigint", (Type)SmallintType.SMALLINT);
            VariableReferenceExpression leftCast = p.variable("left_cast", (Type)BigintType.BIGINT);
            VariableReferenceExpression rightCast = p.variable("right_cast", (Type)BigintType.BIGINT);
            return p.join(JoinType.INNER, (PlanNode)p.project(PlanBuilder.assignment(leftCast, p.rowExpression("cast(left_bigint as varchar)")), (PlanNode)p.values(leftBigint)), (PlanNode)p.project(PlanBuilder.assignment(rightCast, p.rowExpression("cast(right_bigint as varchar)")), (PlanNode)p.values(rightBigint)), new EquiJoinClause(leftCast, rightCast));
        }).doesNotFire();
    }

    @Test
    public void testNoCast() {
        this.tester().assertThat((Rule)new RemoveRedundantCastToVarcharInJoinClause(this.getFunctionManager())).setSystemProperty("remove_redundant_cast_to_varchar_in_join", "true").on(p -> {
            VariableReferenceExpression rightBigint = p.variable("right_bigint");
            VariableReferenceExpression leftCast = p.variable("left_cast", (Type)VarcharType.VARCHAR);
            VariableReferenceExpression rightCast = p.variable("right_cast", (Type)VarcharType.VARCHAR);
            return p.join(JoinType.INNER, (PlanNode)p.values(leftCast), (PlanNode)p.project(PlanBuilder.assignment(rightCast, p.rowExpression("cast(right_bigint as varchar)")), (PlanNode)p.values(rightBigint)), new EquiJoinClause(leftCast, rightCast));
        }).doesNotFire();
    }

    @Test
    public void testCastDoubleToVarchar() {
        this.tester().assertThat((Rule)new RemoveRedundantCastToVarcharInJoinClause(this.getFunctionManager())).setSystemProperty("remove_redundant_cast_to_varchar_in_join", "true").on(p -> {
            VariableReferenceExpression leftBigint = p.variable("left_bigint", (Type)DoubleType.DOUBLE);
            VariableReferenceExpression rightBigint = p.variable("right_bigint", (Type)DoubleType.DOUBLE);
            VariableReferenceExpression leftCast = p.variable("left_cast", (Type)VarcharType.VARCHAR);
            VariableReferenceExpression rightCast = p.variable("right_cast", (Type)VarcharType.VARCHAR);
            return p.join(JoinType.INNER, (PlanNode)p.project(PlanBuilder.assignment(leftCast, p.rowExpression("cast(left_bigint as varchar)")), (PlanNode)p.values(leftBigint)), (PlanNode)p.project(PlanBuilder.assignment(rightCast, p.rowExpression("cast(right_bigint as varchar)")), (PlanNode)p.values(rightBigint)), new EquiJoinClause(leftCast, rightCast));
        }).doesNotFire();
    }
}

