/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.RewriteConstantArrayContainsToInExpression;
import com.facebook.presto.sql.planner.iterative.rule.SimplifyRowExpressions;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.testng.annotations.Test;

public class TestRewriteConstantArrayContainsToInExpression
extends BaseRuleTest {
    public TestRewriteConstantArrayContainsToInExpression() {
        super(new Plugin[0]);
    }

    @Test
    public void testNoNull() {
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.builder().addAll((Iterable)new SimplifyRowExpressions(this.getMetadata()).rules()).addAll((Iterable)new RewriteConstantArrayContainsToInExpression(this.getFunctionManager()).rules()).build()).setSystemProperty("rewrite_constant_array_contains_to_in_expression", "true").on(p -> {
            VariableReferenceExpression a = p.variable("a", (Type)BooleanType.BOOLEAN);
            VariableReferenceExpression b = p.variable("b");
            return p.project(PlanBuilder.assignment(a, p.rowExpression("contains(array[1, 2, 3], b)")), (PlanNode)p.values(b));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("b IN (1, 2, 3)")), PlanMatchPattern.values("b")));
    }

    @Test
    public void testDoesNotFireForNestedArray() {
        this.tester().assertThat(new RewriteConstantArrayContainsToInExpression(this.getFunctionManager()).projectRowExpressionRewriteRule()).setSystemProperty("rewrite_constant_array_contains_to_in_expression", "true").on(p -> {
            VariableReferenceExpression a = p.variable("a", (Type)BooleanType.BOOLEAN);
            VariableReferenceExpression b = p.variable("b", (Type)new ArrayType((Type)BigintType.BIGINT));
            return p.project(PlanBuilder.assignment(a, p.rowExpression("contains(array[array[1, 2], array[3]], b)")), (PlanNode)p.values(b));
        }).doesNotFire();
    }

    @Test
    public void testDoesNotFireForNull() {
        this.tester().assertThat(new RewriteConstantArrayContainsToInExpression(this.getFunctionManager()).projectRowExpressionRewriteRule()).setSystemProperty("rewrite_constant_array_contains_to_in_expression", "true").on(p -> {
            VariableReferenceExpression a = p.variable("a", (Type)BooleanType.BOOLEAN);
            VariableReferenceExpression b = p.variable("b", (Type)BigintType.BIGINT);
            return p.project(PlanBuilder.assignment(a, p.rowExpression("contains(cast(null as array<bigint>), b)")), (PlanNode)p.values(b));
        }).doesNotFire();
    }

    @Test
    public void testDoesNotFireForEmpty() {
        this.tester().assertThat(new RewriteConstantArrayContainsToInExpression(this.getFunctionManager()).projectRowExpressionRewriteRule()).setSystemProperty("rewrite_constant_array_contains_to_in_expression", "true").on(p -> {
            VariableReferenceExpression a = p.variable("a", (Type)BooleanType.BOOLEAN);
            VariableReferenceExpression b = p.variable("b", (Type)new ArrayType((Type)BigintType.BIGINT));
            return p.project(PlanBuilder.assignment(a, p.rowExpression("contains(array[], b)")), (PlanNode)p.values(b));
        }).doesNotFire();
    }

    @Test
    public void testNotFire() {
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.builder().addAll((Iterable)new SimplifyRowExpressions(this.getMetadata()).rules()).addAll((Iterable)new RewriteConstantArrayContainsToInExpression(this.getFunctionManager()).rules()).build()).setSystemProperty("rewrite_constant_array_contains_to_in_expression", "true").on(p -> {
            VariableReferenceExpression a = p.variable("a", (Type)BooleanType.BOOLEAN);
            VariableReferenceExpression b = p.variable("b");
            VariableReferenceExpression c = p.variable("c");
            return p.project(PlanBuilder.assignment(a, p.rowExpression("contains(array[1, 2, c], b)")), (PlanNode)p.values(b, c));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("contains(array[1, 2, c], b)")), PlanMatchPattern.values("b", "c")));
    }

    @Test
    public void testWithNull() {
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.builder().addAll((Iterable)new SimplifyRowExpressions(this.getMetadata()).rules()).addAll((Iterable)new RewriteConstantArrayContainsToInExpression(this.getFunctionManager()).rules()).build()).setSystemProperty("rewrite_constant_array_contains_to_in_expression", "true").on(p -> {
            VariableReferenceExpression a = p.variable("a", (Type)BooleanType.BOOLEAN);
            VariableReferenceExpression b = p.variable("b");
            return p.project(PlanBuilder.assignment(a, p.rowExpression("contains(array[1, 2, 3, null], b)")), (PlanNode)p.values(b));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("b IN (1, 2, 3, null)")), PlanMatchPattern.values("b")));
    }

    @Test
    public void testLambda() {
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.builder().addAll((Iterable)new SimplifyRowExpressions(this.getMetadata()).rules()).addAll((Iterable)new RewriteConstantArrayContainsToInExpression(this.getFunctionManager()).rules()).build()).setSystemProperty("rewrite_constant_array_contains_to_in_expression", "true").on(p -> {
            VariableReferenceExpression a = p.variable("a", (Type)BooleanType.BOOLEAN);
            VariableReferenceExpression b = p.variable("b", (Type)new ArrayType((Type)BigintType.BIGINT));
            return p.project(PlanBuilder.assignment(a, p.rowExpression("any_match(b, x -> contains(array[1, 2, 3, null], x))")), (PlanNode)p.values(b));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("any_match(b, x -> x IN (1, 2, 3, null))")), PlanMatchPattern.values("b")));
    }
}

