/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.SimplifySortWithConstantInput;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.tree.SortItem;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestSimplifySortWithConstantInput
extends BaseRuleTest {
    public TestSimplifySortWithConstantInput() {
        super(new Plugin[0]);
    }

    @Test
    public void testAllSortKeyConstant() {
        this.tester().assertThat((Rule)new SimplifySortWithConstantInput()).on(p -> {
            VariableReferenceExpression key1 = p.variable("key1");
            VariableReferenceExpression key2 = p.variable("key2");
            VariableReferenceExpression key3 = p.variable("key3");
            return p.sort((List<VariableReferenceExpression>)ImmutableList.of((Object)key1, (Object)key2), (PlanNode)p.project(PlanBuilder.assignment(key1, p.rowExpression("1"), key2, p.rowExpression("2")), (PlanNode)p.values(key3)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"key1", (Object)PlanMatchPattern.expression("1"), (Object)"key2", (Object)PlanMatchPattern.expression("2")), PlanMatchPattern.values("key3")));
    }

    @Test
    public void testSomeSortKeyConstant() {
        this.tester().assertThat((Rule)new SimplifySortWithConstantInput()).on(p -> {
            VariableReferenceExpression key1 = p.variable("key1");
            VariableReferenceExpression key2 = p.variable("key2");
            VariableReferenceExpression key3 = p.variable("key3");
            return p.sort((List<VariableReferenceExpression>)ImmutableList.of((Object)key1, (Object)key2), (PlanNode)p.project(PlanBuilder.assignment(key1, p.rowExpression("1"), key2, p.rowExpression("key3")), (PlanNode)p.values(key3)));
        }).matches(PlanMatchPattern.sort((List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("key2", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"key1", (Object)PlanMatchPattern.expression("1"), (Object)"key2", (Object)PlanMatchPattern.expression("key3")), PlanMatchPattern.values("key3"))));
    }

    @Test
    public void testNoSortKeyConstant() {
        this.tester().assertThat((Rule)new SimplifySortWithConstantInput()).on(p -> {
            VariableReferenceExpression key1 = p.variable("key1");
            VariableReferenceExpression key2 = p.variable("key2");
            VariableReferenceExpression key3 = p.variable("key3");
            return p.sort((List<VariableReferenceExpression>)ImmutableList.of((Object)key1, (Object)key2), (PlanNode)p.project(PlanBuilder.assignment(key1, p.rowExpression("key3"), key2, p.rowExpression("key3")), (PlanNode)p.values(key3)));
        }).doesNotFire();
    }
}

