/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.LogicalPropertiesProvider;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.properties.LogicalPropertiesProviderImpl;
import com.facebook.presto.sql.planner.iterative.rule.TransformDistinctInnerJoinToRightEarlyOutJoin;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleTester;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestTransformDistinctInnerJoinToRightEarlyOutJoin
extends BaseRuleTest {
    public TestTransformDistinctInnerJoinToRightEarlyOutJoin() {
        super(new Plugin[0]);
    }

    @Override
    @BeforeClass
    public final void setUp() {
        this.tester = new RuleTester(Collections.emptyList(), (Map<String, String>)ImmutableMap.of((Object)"in_predicates_as_inner_joins_enabled", (Object)Boolean.toString(true), (Object)"exploit_constraints", (Object)Boolean.toString(true), (Object)"join_reordering_strategy", (Object)FeaturesConfig.JoinReorderingStrategy.AUTOMATIC.name()));
    }

    @Test
    public void testAggregationPushedDown() {
        this.tester().assertThat((Rule)new TransformDistinctInnerJoinToRightEarlyOutJoin(), (LogicalPropertiesProvider)new LogicalPropertiesProviderImpl(new FunctionResolution(this.getFunctionManager().getFunctionAndTypeResolver()))).on(p -> {
            VariableReferenceExpression a = p.variable("a", (Type)BigintType.BIGINT);
            VariableReferenceExpression b = p.variable("b", (Type)BigintType.BIGINT);
            VariableReferenceExpression unique = p.variable("unique", (Type)BigintType.BIGINT);
            return p.aggregation(agg -> agg.step(AggregationNode.Step.SINGLE).singleGroupingSet(b).source((PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesB"), 100, b), (PlanNode)p.assignUniqueId(unique, (PlanNode)p.values(new PlanNodeId("valuesA"), 1000, a)), new EquiJoinClause(b, a))));
        }).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(1000.0).setConfident(true).addVariableStatistics(Expressions.variable((String)"a", (Type)BigintType.BIGINT), new VariableStatsEstimate(0.0, 1000.0, 0.0, 8.0, 100.0)).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).setConfident(true).addVariableStatistics(Expressions.variable((String)"b", (Type)BigintType.BIGINT), new VariableStatsEstimate(0.0, 1000.0, 0.0, 8.0, 10.0)).build()).matches(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), AggregationNode.Step.SINGLE, PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("b", "a")), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), AggregationNode.Step.SINGLE, PlanMatchPattern.values("b")), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("a")))));
    }

    @Test
    public void testFeatureDisabled() {
        Function<PlanBuilder, PlanNode> planProvider = p -> {
            VariableReferenceExpression a = p.variable("a", (Type)BigintType.BIGINT);
            VariableReferenceExpression b = p.variable("b", (Type)BigintType.BIGINT);
            VariableReferenceExpression unique = p.variable("unique", (Type)BigintType.BIGINT);
            return p.project(PlanBuilder.assignment(a, (RowExpression)a), (PlanNode)p.aggregation(agg -> agg.step(AggregationNode.Step.SINGLE).singleGroupingSet(unique, a).source((PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesB"), b), (PlanNode)p.assignUniqueId(unique, (PlanNode)p.values(new PlanNodeId("valuesA"), a)), new EquiJoinClause(b, a)))));
        };
        this.tester().assertThat((Rule)new TransformDistinctInnerJoinToRightEarlyOutJoin()).setSystemProperty("in_predicates_as_inner_joins_enabled", "false").on(planProvider).doesNotFire();
        this.tester().assertThat((Rule)new TransformDistinctInnerJoinToRightEarlyOutJoin()).setSystemProperty("exploit_constraints", "false").on(planProvider).doesNotFire();
        this.tester().assertThat((Rule)new TransformDistinctInnerJoinToRightEarlyOutJoin()).setSystemProperty("join_reordering_strategy", "NONE").on(planProvider).doesNotFire();
    }
}

