/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.ExistsExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.TransformExistsApplyToLateralNode;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestTransformExistsApplyToLateralJoin
extends BaseRuleTest {
    public TestTransformExistsApplyToLateralJoin() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFire() {
        this.tester().assertThat((Rule)new TransformExistsApplyToLateralNode(this.tester().getMetadata().getFunctionAndTypeManager())).on(p -> p.values(p.variable("a"))).doesNotFire();
        this.tester().assertThat((Rule)new TransformExistsApplyToLateralNode(this.tester().getMetadata().getFunctionAndTypeManager())).on(p -> p.lateral((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("a")), (PlanNode)p.values(p.variable("a")), (PlanNode)p.values(p.variable("a")))).doesNotFire();
    }

    @Test
    public void testRewrite() {
        this.tester().assertThat((Rule)new TransformExistsApplyToLateralNode(this.tester().getMetadata().getFunctionAndTypeManager())).on(p -> p.apply(PlanBuilder.assignment(p.variable("b", (Type)BooleanType.BOOLEAN), (RowExpression)new ExistsExpression(Optional.empty(), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT)), (List<VariableReferenceExpression>)ImmutableList.of(), (PlanNode)p.values(), (PlanNode)p.values())).matches(PlanMatchPattern.lateral((List<String>)ImmutableList.of(), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of()), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("(\"count_expr\" > CAST(0 AS bigint))")), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"count_expr", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.values(new String[0])))));
    }

    @Test
    public void testRewritesToLimit() {
        this.tester().assertThat((Rule)new TransformExistsApplyToLateralNode(this.tester().getMetadata().getFunctionAndTypeManager())).on(p -> p.apply(PlanBuilder.assignment(p.variable("b", (Type)BooleanType.BOOLEAN), (RowExpression)new ExistsExpression(Optional.empty(), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT)), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("corr")), (PlanNode)p.values(p.variable("corr")), (PlanNode)p.project(Assignments.of(), (PlanNode)p.filter(Expressions.comparisonExpression((StandardFunctionResolution)new FunctionResolution(this.getFunctionManager().getFunctionAndTypeResolver()), (OperatorType)OperatorType.EQUAL, (RowExpression)p.variable("corr"), (RowExpression)p.variable("column")), (PlanNode)p.values(p.variable("column")))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("COALESCE(subquerytrue, false)")), PlanMatchPattern.lateral((List<String>)ImmutableList.of((Object)"corr"), PlanMatchPattern.values("corr"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"subquerytrue", (Object)PlanMatchPattern.expression("true")), PlanMatchPattern.limit(1L, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.values("column"))))))));
    }
}

