/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.LogicalPropertiesProvider;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.ExistsExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.properties.LogicalPropertiesProviderImpl;
import com.facebook.presto.sql.planner.iterative.rule.TransformUncorrelatedInPredicateSubqueryToDistinctInnerJoin;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleTester;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.tpch.TpchConnectorFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestTransformUncorrelatedInPredicateSubqueryToDistinctInnerJoin
extends BaseRuleTest {
    public TestTransformUncorrelatedInPredicateSubqueryToDistinctInnerJoin() {
        super(new Plugin[0]);
    }

    @Override
    @BeforeClass
    public final void setUp() {
        this.tester = new RuleTester(Collections.emptyList(), (Map<String, String>)ImmutableMap.of((Object)"in_predicates_as_inner_joins_enabled", (Object)Boolean.toString(true), (Object)"exploit_constraints", (Object)Boolean.toString(true), (Object)"join_reordering_strategy", (Object)FeaturesConfig.JoinReorderingStrategy.AUTOMATIC.name()), Optional.of(1), (ConnectorFactory)new TpchConnectorFactory(1));
    }

    @Test
    public void testDoesNotFireOnCorrelation() {
        this.tester().assertThat((Rule)new TransformUncorrelatedInPredicateSubqueryToDistinctInnerJoin()).on(p -> p.apply(PlanBuilder.assignment(p.variable("x"), (RowExpression)Expressions.inSubquery((VariableReferenceExpression)p.variable("y"), (VariableReferenceExpression)p.variable("z"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("y")), (PlanNode)p.values(p.variable("y")), (PlanNode)p.values())).doesNotFire();
    }

    @Test
    public void testDoesNotFireOnNonInPredicateSubquery() {
        this.tester().assertThat((Rule)new TransformUncorrelatedInPredicateSubqueryToDistinctInnerJoin()).on(p -> p.apply(PlanBuilder.assignment(p.variable("x"), (RowExpression)new ExistsExpression(Optional.empty(), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT)), Collections.emptyList(), (PlanNode)p.values(), (PlanNode)p.values())).doesNotFire();
    }

    @Test
    public void testFiresForInPredicate() {
        this.tester().assertThat((Rule)new TransformUncorrelatedInPredicateSubqueryToDistinctInnerJoin()).on(p -> p.apply(PlanBuilder.assignment(p.variable("x"), (RowExpression)Expressions.inSubquery((VariableReferenceExpression)p.variable("y"), (VariableReferenceExpression)p.variable("z"))), Collections.emptyList(), (PlanNode)p.values(p.variable("y")), (PlanNode)p.values(p.variable("z")))).matches(PlanMatchPattern.project(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), AggregationNode.Step.SINGLE, PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("y", "z")), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("y")), PlanMatchPattern.values("z")))));
    }

    @Test
    public void testDoesNotFiresForInPredicateThatMayParticipateInAntiJoin() {
        this.tester().assertThat((Rule)new TransformUncorrelatedInPredicateSubqueryToDistinctInnerJoin()).on(p -> p.apply(PlanBuilder.assignment(p.variable("x"), (RowExpression)Expressions.inSubquery((VariableReferenceExpression)p.variable("y"), (VariableReferenceExpression)p.variable("z"))), Collections.emptyList(), (PlanNode)p.values(p.variable("y")), (PlanNode)p.values(p.variable("z")), true)).doesNotFire();
    }

    @Test
    public void testSimpleSemijoins() {
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new TransformUncorrelatedInPredicateSubqueryToDistinctInnerJoin()), (LogicalPropertiesProvider)new LogicalPropertiesProviderImpl(new FunctionResolution(this.getFunctionManager().getFunctionAndTypeResolver()))).on("SELECT * FROM nation WHERE regionkey IN (SELECT regionkey FROM region)").matches(PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("regionkey", "regionkey_1")), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"regionkey", (Object)"regionkey", (Object)"nationkey", (Object)"nationkey", (Object)"name", (Object)"name", (Object)"comment", (Object)"comment"))), PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"regionkey_1", (Object)"regionkey")))))));
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new TransformUncorrelatedInPredicateSubqueryToDistinctInnerJoin()), (LogicalPropertiesProvider)new LogicalPropertiesProviderImpl(new FunctionResolution(this.getFunctionManager().getFunctionAndTypeResolver()))).on("SELECT * FROM nation WHERE regionkey IN (SELECT regionkey FROM region) AND name IN (SELECT name FROM region)").matches(PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("name", "name_12")), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("regionkey", "regionkey_1")), PlanMatchPattern.assignUniqueId("unique_37", PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"regionkey", (Object)"regionkey", (Object)"nationkey", (Object)"nationkey", (Object)"name", (Object)"name", (Object)"comment", (Object)"comment"))), PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"regionkey_1", (Object)"regionkey")))))), PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"name_12", (Object)"name")))))));
    }

    @Test
    public void testFeatureDisabled() {
        this.tester().assertThat((Rule)new TransformUncorrelatedInPredicateSubqueryToDistinctInnerJoin()).setSystemProperty("in_predicates_as_inner_joins_enabled", "false").on(p -> p.apply(PlanBuilder.assignment(p.variable("x"), (RowExpression)Expressions.inSubquery((VariableReferenceExpression)p.variable("y"), (VariableReferenceExpression)p.variable("z"))), Collections.emptyList(), (PlanNode)p.values(p.variable("y")), (PlanNode)p.values(p.variable("z")))).doesNotFire();
        this.tester().assertThat((Rule)new TransformUncorrelatedInPredicateSubqueryToDistinctInnerJoin()).setSystemProperty("exploit_constraints", "false").on(p -> p.apply(PlanBuilder.assignment(p.variable("x"), (RowExpression)Expressions.inSubquery((VariableReferenceExpression)p.variable("y"), (VariableReferenceExpression)p.variable("z"))), Collections.emptyList(), (PlanNode)p.values(p.variable("y")), (PlanNode)p.values(p.variable("z")))).doesNotFire();
        this.tester().assertThat((Rule)new TransformUncorrelatedInPredicateSubqueryToDistinctInnerJoin()).setSystemProperty("join_reordering_strategy", "NONE").on(p -> p.apply(PlanBuilder.assignment(p.variable("x"), (RowExpression)Expressions.inSubquery((VariableReferenceExpression)p.variable("y"), (VariableReferenceExpression)p.variable("z"))), Collections.emptyList(), (PlanNode)p.values(p.variable("y")), (PlanNode)p.values(p.variable("z")))).doesNotFire();
    }
}

