/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestEliminateCrossJoins
extends BasePlanTest {
    private static final PlanMatchPattern ORDERS_TABLESCAN = PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey"));
    private static final PlanMatchPattern ORDERS_WITH_SHIPPRIORITY_TABLESCAN = PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey", (Object)"O_SHIPPRIORITY", (Object)"shippriority"));
    private static final PlanMatchPattern SUPPLIER_TABLESCAN = PlanMatchPattern.tableScan("supplier", (Map<String, String>)ImmutableMap.of((Object)"S_SUPPKEY", (Object)"suppkey"));
    private static final PlanMatchPattern PART_TABLESCAN = PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"P_PARTKEY", (Object)"partkey"));
    private static final PlanMatchPattern PART_WITH_NAME_TABLESCAN = PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"P_PARTKEY", (Object)"partkey", (Object)"P_NAME", (Object)"name"));
    private static final PlanMatchPattern LINEITEM_TABLESCAN = PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_PARTKEY", (Object)"partkey", (Object)"L_ORDERKEY", (Object)"orderkey"));
    private static final PlanMatchPattern LINEITEM_WITH_RETURNFLAG_TABLESCAN = PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_PARTKEY", (Object)"partkey", (Object)"L_ORDERKEY", (Object)"orderkey", (Object)"L_RETURNFLAG", (Object)"returnflag"));
    private static final PlanMatchPattern LINEITEM_WITH_COMMENT_TABLESCAN = PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_PARTKEY", (Object)"partkey", (Object)"L_ORDERKEY", (Object)"orderkey", (Object)"L_COMMENT", (Object)"comment"));

    public TestEliminateCrossJoins() {
        super((Map<String, String>)ImmutableMap.of((Object)"join_reordering_strategy", (Object)"ELIMINATE_CROSS_JOINS"));
    }

    @Test
    public void testEliminateSimpleCrossJoin() {
        this.assertPlan("SELECT * FROM part p, orders o, lineitem l WHERE p.partkey = l.partkey AND l.orderkey = o.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("L_ORDERKEY", "O_ORDERKEY")), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("P_PARTKEY", "L_PARTKEY")), PlanMatchPattern.anyTree(PART_TABLESCAN), PlanMatchPattern.anyTree(LINEITEM_TABLESCAN))), PlanMatchPattern.anyTree(ORDERS_TABLESCAN))));
    }

    @Test
    public void testGiveUpOnCrossJoin() {
        this.assertPlan("SELECT o.orderkey FROM part p, orders o, lineitem l WHERE l.orderkey = o.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("O_ORDERKEY", "L_ORDERKEY")), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.tableScan("part"), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey"))))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_ORDERKEY", (Object)"orderkey"))))));
    }

    @Test
    public void testEliminateCrossJoinWithNonEqualityCondition() {
        this.assertPlan("SELECT o.orderkey FROM part p, orders o, lineitem l WHERE p.partkey = l.partkey AND l.orderkey = o.orderkey AND p.partkey <> o.orderkey AND p.name < l.comment", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("L_ORDERKEY", "O_ORDERKEY")), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("P_PARTKEY", "L_PARTKEY")), Optional.of("P_NAME < cast(L_COMMENT AS varchar(55))"), PlanMatchPattern.anyTree(PART_WITH_NAME_TABLESCAN), PlanMatchPattern.anyTree(PlanMatchPattern.filter("L_PARTKEY <> L_ORDERKEY", LINEITEM_WITH_COMMENT_TABLESCAN)))), PlanMatchPattern.anyTree(ORDERS_TABLESCAN))));
    }

    @Test
    public void testEliminateCrossJoinPreserveFilters() {
        this.assertPlan("SELECT o.orderkey FROM part p, orders o, lineitem l WHERE p.partkey = l.partkey AND l.orderkey = o.orderkey AND l.returnflag = 'R' AND shippriority >= 10", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("L_ORDERKEY", "O_ORDERKEY")), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("P_PARTKEY", "L_PARTKEY")), PlanMatchPattern.anyTree(PART_TABLESCAN), PlanMatchPattern.anyTree(PlanMatchPattern.filter("L_RETURNFLAG = 'R'", LINEITEM_WITH_RETURNFLAG_TABLESCAN)))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("O_SHIPPRIORITY >= 10", ORDERS_WITH_SHIPPRIORITY_TABLESCAN)))));
    }
}

