/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestHashGenerationOptimizer
extends BasePlanTest {
    @Test
    public void testSkipHashGenerationForJoinWithTableScanInput() {
        Session enable = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("join_reordering_strategy", FeaturesConfig.JoinReorderingStrategy.ELIMINATE_CROSS_JOINS.name()).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.BROADCAST.name()).setSystemProperty("skip_hash_generation_for_join_with_table_scan_input", "true").build();
        this.assertPlanWithSession("select * from lineitem l join orders o on l.partkey=o.custkey", enable, false, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("partkey", "custkey")), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"partkey", (Object)"partkey")), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPLICATE, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey"))))))));
        Session disable = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("join_reordering_strategy", FeaturesConfig.JoinReorderingStrategy.ELIMINATE_CROSS_JOINS.name()).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.BROADCAST.name()).setSystemProperty("skip_hash_generation_for_join_with_table_scan_input", "false").build();
        this.assertPlanWithSession("select * from lineitem l join orders o on l.partkey=o.custkey", disable, false, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("partkey", "custkey")), PlanMatchPattern.project(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"partkey", (Object)"partkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPLICATE, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey"))))))));
    }
}

