/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.SortItem;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.annotations.Test;

public class TestMergePartialAggregationsWithFilter
extends BasePlanTest {
    private Session enableOptimization() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("merge_aggregations_with_and_without_filter", "true").setSystemProperty("partial_aggregation_strategy", "AUTOMATIC").build();
    }

    private Session disableOptimization() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("merge_aggregations_with_and_without_filter", "false").setSystemProperty("partial_aggregation_strategy", "AUTOMATIC").build();
    }

    @Test
    public void testOptimizationApplied() {
        this.assertPlan("SELECT partkey, sum(quantity), sum(quantity) filter (where orderkey > 0) from lineitem group by partkey", this.enableOptimization(), PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("partkey"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("finalSum"), PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"partialSum")), Optional.of("maskFinalSum"), PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"maskPartialSum"))), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.FINAL, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"maskPartialSum", (Object)PlanMatchPattern.expression("IF(expr, partialSum, null)")), PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("partkey", "expr"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("partialSum"), PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"quantity"))), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.PARTIAL, PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("orderkey > 0")), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"partkey", (Object)"partkey", (Object)"quantity", (Object)"quantity"))))))))), false);
    }

    @Test
    public void testOptimizationDisabled() {
        this.assertPlan("SELECT partkey, sum(quantity), sum(quantity) filter (where orderkey > 0) from lineitem group by partkey", this.disableOptimization(), PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("partkey"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("finalSum"), PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"partialSum")), Optional.of("maskFinalSum"), PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"maskPartialSum"))), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("partkey"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("partialSum"), PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"quantity")), Optional.of("maskPartialSum"), PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"quantity"))), (Map<Symbol, Symbol>)ImmutableMap.of((Object)new Symbol("maskPartialSum"), (Object)new Symbol("expr")), Optional.empty(), AggregationNode.Step.PARTIAL, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("orderkey > 0")), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"partkey", (Object)"partkey", (Object)"quantity", (Object)"quantity"))))))), false);
    }

    @Test
    public void testMultipleAggregations() {
        this.assertPlan("SELECT partkey, sum(quantity), sum(quantity) filter (where orderkey > 0), avg(quantity), avg(quantity) filter (where orderkey > 0) from lineitem group by partkey", this.enableOptimization(), PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("partkey"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("finalSum"), PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"partialSum")), Optional.of("maskFinalSum"), PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"maskPartialSum")), Optional.of("finalAvg"), PlanMatchPattern.functionCall("avg", (List<String>)ImmutableList.of((Object)"partialAvg")), Optional.of("maskFinalAvg"), PlanMatchPattern.functionCall("avg", (List<String>)ImmutableList.of((Object)"maskPartialAvg"))), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.FINAL, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"maskPartialSum", (Object)PlanMatchPattern.expression("IF(expr, partialSum, null)"), (Object)"maskPartialAvg", (Object)PlanMatchPattern.expression("IF(expr, partialAvg, null)")), PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("partkey", "expr"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("partialSum"), PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"quantity")), Optional.of("partialAvg"), PlanMatchPattern.functionCall("avg", (List<String>)ImmutableList.of((Object)"quantity"))), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.PARTIAL, PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("orderkey > 0")), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"partkey", (Object)"partkey", (Object)"quantity", (Object)"quantity"))))))))), false);
    }

    @Test
    public void testAggregationsMultipleLevel() {
        this.assertPlan("select partkey, avg(sum), avg(sum) filter (where suppkey > 0), avg(filtersum) from (select partkey, suppkey, sum(quantity) sum, sum(quantity) filter (where orderkey > 0) filtersum from lineitem group by partkey, suppkey) t group by partkey", this.enableOptimization(), PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("partkey"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("finalAvg"), PlanMatchPattern.functionCall("avg", (List<String>)ImmutableList.of((Object)"partialAvg")), Optional.of("maskFinalAvg"), PlanMatchPattern.functionCall("avg", (List<String>)ImmutableList.of((Object)"maskPartialAvg")), Optional.of("finalFilterAvg"), PlanMatchPattern.functionCall("avg", (List<String>)ImmutableList.of((Object)"partialFilterAvg"))), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.FINAL, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"maskPartialAvg", (Object)PlanMatchPattern.expression("IF(expr_2, partialAvg, null)")), PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("partkey", "expr_2"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("partialAvg"), PlanMatchPattern.functionCall("avg", (List<String>)ImmutableList.of((Object)"finalSum")), Optional.of("partialFilterAvg"), PlanMatchPattern.functionCall("avg", (List<String>)ImmutableList.of((Object)"maskFinalSum"))), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.PARTIAL, PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_2", (Object)PlanMatchPattern.expression("suppkey > 0")), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("partkey", "suppkey"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("finalSum"), PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"partialSum")), Optional.of("maskFinalSum"), PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"maskPartialSum"))), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.FINAL, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"maskPartialSum", (Object)PlanMatchPattern.expression("IF(expr, partialSum, null)")), PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("partkey", "suppkey", "expr"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("partialSum"), PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"quantity"))), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.PARTIAL, PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("orderkey > 0")), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"partkey", (Object)"partkey", (Object)"quantity", (Object)"quantity", (Object)"suppkey", (Object)"suppkey"))))))))))))))), false);
    }

    @Test
    public void testGlobalOptimization() {
        this.assertPlan("SELECT sum(quantity), sum(quantity) filter (where orderkey > 0) from lineitem", this.enableOptimization(), PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("finalSum"), PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"partialSum")), Optional.of("maskFinalSum"), PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"maskPartialSum"))), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("partialSum"), PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"quantity")), Optional.of("maskPartialSum"), PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"quantity"))), (Map<Symbol, Symbol>)ImmutableMap.of((Object)new Symbol("maskPartialSum"), (Object)new Symbol("expr")), Optional.empty(), AggregationNode.Step.PARTIAL, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("orderkey > 0")), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"quantity", (Object)"quantity"))))))), false);
    }

    @Test
    public void testHasOrderBy() {
        this.assertPlan("select partkey, array_agg(suppkey order by suppkey), array_agg(suppkey order by suppkey) filter (where orderkey > 0) from lineitem group by partkey", this.enableOptimization(), PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("partkey"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("array_agg"), PlanMatchPattern.functionCall("array_agg", (List<String>)ImmutableList.of((Object)"suppkey"), (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("suppkey", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST))), Optional.of("array_agg_filter"), PlanMatchPattern.functionCall("array_agg", (List<String>)ImmutableList.of((Object)"suppkey"), (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("suppkey", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST)))), (Map<Symbol, Symbol>)ImmutableMap.of((Object)new Symbol("array_agg_filter"), (Object)new Symbol("expr")), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("orderkey > 0")), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"partkey", (Object)"partkey", (Object)"suppkey", (Object)"suppkey")))))), false);
    }

    @Test
    public void testGroupingSets() {
        this.assertPlan("SELECT partkey, sum(quantity), sum(quantity) filter (where orderkey > 0) from lineitem group by grouping sets((), (partkey))", this.enableOptimization(), PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(new PlanMatchPattern.GroupingSetDescriptor((List<String>)ImmutableList.of((Object)"partkey$gid", (Object)"groupid"), 2, (Set<Integer>)ImmutableSet.of((Object)0)), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("finalSum"), PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"partialSum")), Optional.of("maskFinalSum"), PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"maskPartialSum"))), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.of(new Symbol("groupid")), AggregationNode.Step.FINAL, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"maskPartialSum", (Object)PlanMatchPattern.expression("IF(expr, partialSum, null)")), PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(new PlanMatchPattern.GroupingSetDescriptor((List<String>)ImmutableList.of((Object)"partkey$gid", (Object)"groupid", (Object)"expr"), 2, (Set<Integer>)ImmutableSet.of((Object)0)), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("partialSum"), PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"quantity"))), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.of(new Symbol("groupid")), AggregationNode.Step.PARTIAL, PlanMatchPattern.anyTree(PlanMatchPattern.groupingSet((List<List<String>>)ImmutableList.of((Object)ImmutableList.of(), (Object)ImmutableList.of((Object)"partkey")), (Map<String, String>)ImmutableMap.of((Object)"quantity", (Object)"quantity", (Object)"expr", (Object)"expr"), "groupid", (Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"partkey$gid", (Object)PlanMatchPattern.expression("partkey")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("orderkey > 0")), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"partkey", (Object)"partkey", (Object)"quantity", (Object)"quantity")))))))))), false);
    }

    @Test
    public void testCalledOnNull() {
        this.assertPlan("SELECT partkey, count(*), count(*) filter (where orderkey > 0) from lineitem group by partkey", this.enableOptimization(), PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("partkey"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("finalCnt"), PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of((Object)"partialCnt")), Optional.of("maskFinalCnt"), PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of((Object)"maskPartialCnt"))), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("partkey"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("partialCnt"), PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of()), Optional.of("maskPartialCnt"), PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), (Map<Symbol, Symbol>)ImmutableMap.of((Object)new Symbol("maskPartialCnt"), (Object)new Symbol("expr")), Optional.empty(), AggregationNode.Step.PARTIAL, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("orderkey > 0")), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"partkey", (Object)"partkey"))))))), false);
    }
}

