/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.testng.annotations.Test;

public class TestShardJoins
extends BasePlanTest {
    private Session getSessionAlwaysEnabled() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("sharded_joins_strategy", "ALWAYS").setSystemProperty("join_reordering_strategy", "NONE").setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.PARTITIONED.name()).build();
    }

    private Session getBroadcastJoinSessionAlwaysEnabled() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("sharded_joins_strategy", "ALWAYS").setSystemProperty("join_reordering_strategy", "NONE").setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.BROADCAST.name()).build();
    }

    @Test
    public void testJoin() {
        this.assertPlan("SELECT * FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey", this.getSessionAlwaysEnabled(), PlanMatchPattern.anyTree(PlanMatchPattern.join(PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"leftOrderKey", (Object)PlanMatchPattern.expression("leftOrderKey"), (Object)"leftShard", (Object)PlanMatchPattern.expression("random(100)")), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"leftOrderKey", (Object)"orderkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.unnest(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"rightOrderKey", (Object)PlanMatchPattern.expression("rightOrderKey")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"rightOrderKey", (Object)"orderkey"))))))), false);
    }

    @Test
    public void testLeftJoin() {
        this.assertPlan("SELECT * FROM lineitem LEFT JOIN orders ON lineitem.orderkey = orders.orderkey", this.getSessionAlwaysEnabled(), PlanMatchPattern.anyTree(PlanMatchPattern.join(PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"leftOrderKey", (Object)PlanMatchPattern.expression("leftOrderKey"), (Object)"leftShard", (Object)PlanMatchPattern.expression("random(100)")), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"leftOrderKey", (Object)"orderkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.unnest(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"rightOrderKey", (Object)PlanMatchPattern.expression("rightOrderKey")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"rightOrderKey", (Object)"orderkey"))))))), false);
    }

    @Test
    public void testDoesNotFireForFullOuterJoin() {
        this.assertPlan("SELECT * FROM lineitem FULL OUTER JOIN orders ON lineitem.orderkey = orders.orderkey", this.getSessionAlwaysEnabled(), PlanMatchPattern.anyTree(PlanMatchPattern.join(PlanMatchPattern.project(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"leftOrderKey", (Object)"orderkey"))), PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"rightOrderKey", (Object)"orderkey")))))), false);
    }

    @Test
    public void testDoesNotFireForRightOuterJoin() {
        this.assertPlan("SELECT * FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey", this.getSessionAlwaysEnabled(), PlanMatchPattern.anyTree(PlanMatchPattern.join(PlanMatchPattern.project(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"leftOrderKey", (Object)"orderkey"))), PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"rightOrderKey", (Object)"orderkey")))))), false);
    }

    @Test
    public void testDoesNotFireForBroadcastJoin() {
        this.assertPlan("SELECT * FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey", this.getBroadcastJoinSessionAlwaysEnabled(), PlanMatchPattern.anyTree(PlanMatchPattern.join(PlanMatchPattern.project(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"leftOrderKey", (Object)"orderkey"))), PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"rightOrderKey", (Object)"orderkey")))))), false);
    }
}

