/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.sanity.ValidateAggregationsWithDefaultValues;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchTableHandle;
import com.facebook.presto.tpch.TpchTableLayoutHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestValidateAggregationsWithDefaultValues
extends BasePlanTest {
    private static final SqlParser SQL_PARSER = new SqlParser();
    private Metadata metadata;
    private PlanBuilder builder;
    private VariableReferenceExpression variable;
    private TableScanNode tableScanNode;

    @BeforeClass
    public void setup() {
        this.metadata = this.getQueryRunner().getMetadata();
        this.builder = new PlanBuilder(SessionTestUtils.TEST_SESSION, new PlanNodeIdAllocator(), this.metadata);
        ConnectorId connectorId = this.getCurrentConnectorId();
        TpchTableHandle nationTpchTableHandle = new TpchTableHandle("nation", 1.0);
        TableHandle nationTableHandle = new TableHandle(connectorId, (ConnectorTableHandle)nationTpchTableHandle, (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.of(new TpchTableLayoutHandle(nationTpchTableHandle, TupleDomain.all())));
        TpchColumnHandle nationkeyColumnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.variable = this.builder.variable("nationkey");
        this.tableScanNode = this.builder.tableScan(nationTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.variable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.variable, (Object)nationkeyColumnHandle));
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Final aggregation with default value not separated from partial aggregation by remote hash exchange")
    public void testGloballyDistributedFinalAggregationInTheSameStageAsPartialAggregation() {
        AggregationNode root = this.builder.aggregation(af -> af.step(AggregationNode.Step.FINAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)this.variable), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.builder.aggregation(ap -> ap.step(AggregationNode.Step.PARTIAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)this.variable), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.tableScanNode))));
        this.validatePlan((PlanNode)root, false);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Final aggregation with default value not separated from partial aggregation by local hash exchange")
    public void testSingleNodeFinalAggregationInTheSameStageAsPartialAggregation() {
        AggregationNode root = this.builder.aggregation(af -> af.step(AggregationNode.Step.FINAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)this.variable), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.builder.aggregation(ap -> ap.step(AggregationNode.Step.PARTIAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)this.variable), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.tableScanNode))));
        this.validatePlan((PlanNode)root, true);
    }

    @Test
    public void testSingleThreadFinalAggregationInTheSameStageAsPartialAggregation() {
        AggregationNode root = this.builder.aggregation(af -> af.step(AggregationNode.Step.FINAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)this.variable), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.builder.aggregation(ap -> ap.step(AggregationNode.Step.PARTIAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)this.variable), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.builder.values()))));
        this.validatePlan((PlanNode)root, true);
    }

    @Test
    public void testGloballyDistributedFinalAggregationSeparatedFromPartialAggregationByRemoteHashExchange() {
        AggregationNode root = this.builder.aggregation(af -> af.step(AggregationNode.Step.FINAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)this.variable), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.builder.exchange(e -> e.type(ExchangeNode.Type.REPARTITION).scope(ExchangeNode.Scope.REMOTE_STREAMING).fixedHashDistributionPartitioningScheme((List<VariableReferenceExpression>)ImmutableList.of((Object)this.variable), (List<VariableReferenceExpression>)ImmutableList.of((Object)this.variable)).addInputsSet(this.variable).addSource((PlanNode)this.builder.aggregation(ap -> ap.step(AggregationNode.Step.PARTIAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)this.variable), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.tableScanNode))))));
        this.validatePlan((PlanNode)root, false);
    }

    @Test
    public void testSingleNodeFinalAggregationSeparatedFromPartialAggregationByLocalHashExchange() {
        AggregationNode root = this.builder.aggregation(af -> af.step(AggregationNode.Step.FINAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)this.variable), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.builder.exchange(e -> e.type(ExchangeNode.Type.REPARTITION).scope(ExchangeNode.Scope.LOCAL).fixedHashDistributionPartitioningScheme((List<VariableReferenceExpression>)ImmutableList.of((Object)this.variable), (List<VariableReferenceExpression>)ImmutableList.of((Object)this.variable)).addInputsSet(this.variable).addSource((PlanNode)this.builder.aggregation(ap -> ap.step(AggregationNode.Step.PARTIAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)this.variable), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.tableScanNode))))));
        this.validatePlan((PlanNode)root, true);
    }

    @Test
    public void testWithPartialAggregationBelowJoin() {
        AggregationNode root = this.builder.aggregation(af -> af.step(AggregationNode.Step.FINAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)this.variable), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.builder.join(JoinType.INNER, (PlanNode)this.builder.exchange(e -> e.type(ExchangeNode.Type.REPARTITION).scope(ExchangeNode.Scope.LOCAL).fixedHashDistributionPartitioningScheme((List<VariableReferenceExpression>)ImmutableList.of((Object)this.variable), (List<VariableReferenceExpression>)ImmutableList.of((Object)this.variable)).addInputsSet(this.variable).addSource((PlanNode)this.builder.aggregation(ap -> ap.step(AggregationNode.Step.PARTIAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)this.variable), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.tableScanNode)))), (PlanNode)this.builder.values(), new EquiJoinClause[0])));
        this.validatePlan((PlanNode)root, true);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Final aggregation with default value not separated from partial aggregation by local hash exchange")
    public void testWithPartialAggregationBelowJoinWithoutSeparatingExchange() {
        AggregationNode root = this.builder.aggregation(af -> af.step(AggregationNode.Step.FINAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)this.variable), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.builder.join(JoinType.INNER, (PlanNode)this.builder.aggregation(ap -> ap.step(AggregationNode.Step.PARTIAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)this.variable), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.tableScanNode)), (PlanNode)this.builder.values(), new EquiJoinClause[0])));
        this.validatePlan((PlanNode)root, true);
    }

    private void validatePlan(PlanNode root, boolean forceSingleNode) {
        this.getQueryRunner().inTransaction(session -> {
            session.getCatalog().ifPresent(catalog -> this.metadata.getCatalogHandle(session, catalog));
            new ValidateAggregationsWithDefaultValues(forceSingleNode).validate(root, session, this.metadata, SQL_PARSER, this.builder.getTypes(), WarningCollector.NOOP);
            return null;
        });
    }
}

