/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.query;

import com.facebook.presto.sql.query.QueryAssertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestGroupingSets {
    private QueryAssertions assertions;

    @BeforeClass
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testPredicateOverGroupingKeysWithEmptyGroupingSet() {
        this.assertions.assertQuery("WITH t AS (    SELECT a    FROM (        VALUES 1, 2    ) AS u(a)    GROUP BY GROUPING SETS ((), (a)))SELECT * FROM t WHERE a IS NOT NULL", "VALUES 1, 2");
    }

    @Test
    public void testDistinctWithMixedReferences() {
        this.assertions.assertQuery("SELECT a FROM (VALUES 1) t(a) GROUP BY DISTINCT ROLLUP(a, t.a)", "VALUES (1), (NULL)");
        this.assertions.assertQuery("SELECT a FROM (VALUES 1) t(a) GROUP BY DISTINCT GROUPING SETS ((a), (t.a))", "VALUES 1");
        this.assertions.assertQuery("SELECT a FROM (VALUES 1) t(a) GROUP BY DISTINCT a, GROUPING SETS ((), (t.a))", "VALUES 1");
    }
}

