/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.query;

import com.facebook.presto.sql.query.QueryAssertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestSetDigestFunctions {
    private QueryAssertions assertions;

    @BeforeClass
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testCardinality() {
        this.assertions.assertQuery("SELECT cardinality(make_set_digest(value)) FROM (VALUES 1, 2, 2, 3, 3, 3, 4, 4, 4, 4, 5) T(value)", "VALUES CAST(5 AS BIGINT)");
    }

    @Test
    public void testExactIntersectionCardinality() {
        this.assertions.assertQuery("SELECT intersection_cardinality(make_set_digest(v1), make_set_digest(v2)) FROM (VALUES (1, 1), (NULL, 2), (2, 3), (3, 4)) T(v1, v2)", "VALUES CAST(3 AS BIGINT)");
    }

    @Test
    public void testJaccardIndex() {
        this.assertions.assertQuery("SELECT jaccard_index(make_set_digest(v1), make_set_digest(v2)) FROM (VALUES (1, 1), (NULL,2), (2, 3), (NULL, 4)) T(v1, v2)", "VALUES CAST(0.5 AS DOUBLE)");
    }

    @Test
    public void hashCounts() {
        this.assertions.assertQuery("SELECT hash_counts(make_set_digest(value)) FROM (VALUES 1, 1, 1, 2, 2) T(value)", "VALUES map(cast(ARRAY[19144387141682250, -2447670524089286488] AS array(bigint)), cast(ARRAY[3, 2] AS array(smallint)))");
    }
}

