/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.DeterminismEvaluator;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestLogicalRowExpressions {
    private FunctionAndTypeManager functionAndTypeManager;
    private LogicalRowExpressions logicalRowExpressions;
    private static final RowExpression a = TestLogicalRowExpressions.name("a");
    private static final RowExpression b = TestLogicalRowExpressions.name("b");
    private static final RowExpression c = TestLogicalRowExpressions.name("c");
    private static final RowExpression d = TestLogicalRowExpressions.name("d");
    private static final RowExpression e = TestLogicalRowExpressions.name("e");
    private static final RowExpression f = TestLogicalRowExpressions.name("f");
    private static final RowExpression g = TestLogicalRowExpressions.name("g");
    private static final RowExpression h = TestLogicalRowExpressions.name("h");
    private static final VariableReferenceExpression V_0 = TestLogicalRowExpressions.variable("v0");
    private static final VariableReferenceExpression V_1 = TestLogicalRowExpressions.variable("v1");
    private static final VariableReferenceExpression V_2 = TestLogicalRowExpressions.variable("v2");

    @BeforeClass
    public void setup() {
        this.functionAndTypeManager = FunctionAndTypeManager.createTestFunctionAndTypeManager();
        this.logicalRowExpressions = new LogicalRowExpressions((DeterminismEvaluator)new RowExpressionDeterminismEvaluator(this.functionAndTypeManager), (StandardFunctionResolution)new FunctionResolution(this.functionAndTypeManager.getFunctionAndTypeResolver()), (FunctionMetadataManager)this.functionAndTypeManager);
    }

    @Test
    public void testAnd() {
        Assert.assertEquals((Object)LogicalRowExpressions.and((RowExpression[])new RowExpression[]{a, b, c, d, e}), (Object)this.and(this.and(this.and(a, b), this.and(c, d)), e));
        Assert.assertEquals((Object)LogicalRowExpressions.and((RowExpression[])new RowExpression[0]), (Object)Expressions.constant((Object)true, (Type)BooleanType.BOOLEAN));
        Assert.assertEquals((Object)this.logicalRowExpressions.combinePredicates(SpecialFormExpression.Form.AND, new RowExpression[]{a, b, a, c, d, c, e}), (Object)this.and(this.and(this.and(a, b), this.and(c, d)), e));
        Assert.assertEquals((Object)this.logicalRowExpressions.combineConjuncts(new RowExpression[]{a, b, Expressions.constant((Object)false, (Type)BooleanType.BOOLEAN)}), (Object)Expressions.constant((Object)false, (Type)BooleanType.BOOLEAN));
        Assert.assertEquals((Collection)LogicalRowExpressions.extractPredicates((RowExpression)this.and(this.and(this.and(a, b), this.and(c, d)), e)), (Collection)ImmutableList.of((Object)a, (Object)b, (Object)c, (Object)d, (Object)e));
    }

    @Test
    public void testAndWithSubclassOfRowExpression() {
        Assert.assertEquals((Object)LogicalRowExpressions.and((RowExpression[])new RowExpression[]{V_0, V_1, V_2}), (Object)this.and(this.and((RowExpression)V_0, (RowExpression)V_1), (RowExpression)V_2));
        Assert.assertEquals((Object)LogicalRowExpressions.and((Collection)ImmutableList.of((Object)V_0, (Object)V_1, (Object)V_2)), (Object)this.and(this.and((RowExpression)V_0, (RowExpression)V_1), (RowExpression)V_2));
    }

    @Test
    public void testOr() {
        Assert.assertEquals((Object)LogicalRowExpressions.or((RowExpression[])new RowExpression[]{a, b, c, d, e}), (Object)this.or(this.or(this.or(a, b), this.or(c, d)), e));
        Assert.assertEquals((Object)LogicalRowExpressions.or((RowExpression[])new RowExpression[0]), (Object)Expressions.constant((Object)false, (Type)BooleanType.BOOLEAN));
        Assert.assertEquals((Object)this.logicalRowExpressions.combinePredicates(SpecialFormExpression.Form.OR, new RowExpression[]{a, b, Expressions.constant((Object)true, (Type)BooleanType.BOOLEAN)}), (Object)Expressions.constant((Object)true, (Type)BooleanType.BOOLEAN));
        Assert.assertEquals((Collection)LogicalRowExpressions.extractPredicates((RowExpression)this.or(this.or(this.or(a, b), this.or(c, d)), e)), (Collection)ImmutableList.of((Object)a, (Object)b, (Object)c, (Object)d, (Object)e));
    }

    @Test
    public void testOrWithSubclassOfRowExpression() {
        Assert.assertEquals((Object)LogicalRowExpressions.or((RowExpression[])new RowExpression[]{V_0, V_1, V_2}), (Object)this.or(this.or((RowExpression)V_0, (RowExpression)V_1), (RowExpression)V_2));
        Assert.assertEquals((Object)LogicalRowExpressions.or((Collection)ImmutableList.of((Object)V_0, (Object)V_1, (Object)V_2)), (Object)this.or(this.or((RowExpression)V_0, (RowExpression)V_1), (RowExpression)V_2));
    }

    @Test
    public void testDeterminism() {
        CallExpression nondeterministic = Expressions.call((String)"random", (FunctionHandle)this.functionAndTypeManager.lookupFunction("random", TypeSignatureProvider.fromTypes((Type[])new Type[0])), (Type)DoubleType.DOUBLE, (RowExpression[])new RowExpression[0]);
        CallExpression deterministic = Expressions.call((String)"length", (FunctionHandle)this.functionAndTypeManager.lookupFunction("length", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR})), (Type)IntegerType.INTEGER, (RowExpression[])new RowExpression[0]);
        RowExpression expression = this.and(this.and(a, this.or(b, (RowExpression)nondeterministic)), (RowExpression)deterministic);
        Assert.assertEquals((Object)this.logicalRowExpressions.filterDeterministicConjuncts(expression), (Object)this.and(a, (RowExpression)deterministic));
        Assert.assertEquals((Object)this.logicalRowExpressions.filterNonDeterministicConjuncts(expression), (Object)this.or(b, (RowExpression)nondeterministic));
    }

    @Test
    public void testPushNegationToLeaves() {
        Assert.assertEquals((Object)this.logicalRowExpressions.pushNegationToLeaves(this.not(this.and(a, b))), (Object)this.or(this.not(a), this.not(b)));
        Assert.assertEquals((Object)this.logicalRowExpressions.pushNegationToLeaves(this.not(this.or(a, b))), (Object)this.and(this.not(a), this.not(b)));
        Assert.assertEquals((Object)this.logicalRowExpressions.pushNegationToLeaves(this.not(this.or(this.not(a), this.not(b)))), (Object)this.and(a, b));
        Assert.assertEquals((Object)this.logicalRowExpressions.pushNegationToLeaves(this.not(this.or(this.not(a), this.not(this.not(this.not(b)))))), (Object)this.and(a, b));
        Assert.assertEquals((Object)this.logicalRowExpressions.pushNegationToLeaves(this.not(this.or(this.not(this.and(a, b)), this.or(b, this.not(this.and(c, d)))))), (Object)this.and(this.and(a, b), this.and(this.not(b), this.and(c, d))));
        Assert.assertEquals((Object)this.logicalRowExpressions.pushNegationToLeaves(this.not(this.or(this.not(this.and(a, b)), this.not(b)))), (Object)this.and(this.and(a, b), b));
        Assert.assertEquals((Object)this.logicalRowExpressions.pushNegationToLeaves(this.not(this.or(this.not(this.and(a, b)), this.not(this.and(b, c))))), (Object)this.and(this.and(a, b), this.and(b, c)));
        Assert.assertEquals((Object)this.logicalRowExpressions.pushNegationToLeaves(this.not(this.or(this.not(this.and(a, b)), this.not(this.or(b, c))))), (Object)this.and(this.and(a, b), this.or(b, c)));
        Assert.assertEquals((Object)this.logicalRowExpressions.pushNegationToLeaves(this.not(this.or(this.not(this.and(a, b)), this.not(this.or(b, this.not(this.and(c, d))))))), (Object)this.and(this.and(a, b), this.or(b, this.or(this.not(c), this.not(d)))));
        Assert.assertEquals((Object)this.logicalRowExpressions.pushNegationToLeaves(this.or(this.not(this.and(a, b)), this.not(this.or(b, this.not(this.and(c, d)))))), (Object)this.or(this.or(this.not(a), this.not(b)), this.and(this.not(b), this.and(c, d))));
        Assert.assertEquals((Object)this.logicalRowExpressions.pushNegationToLeaves(this.and(this.and(a, b), c)), (Object)this.and(this.and(a, b), c));
        Assert.assertEquals((Object)this.logicalRowExpressions.pushNegationToLeaves(this.not(this.compare(a, OperatorType.EQUAL, b))), (Object)this.compare(a, OperatorType.NOT_EQUAL, b));
        Assert.assertEquals((Object)this.logicalRowExpressions.pushNegationToLeaves(this.not(this.compare(a, OperatorType.NOT_EQUAL, b))), (Object)this.compare(a, OperatorType.EQUAL, b));
        Assert.assertEquals((Object)this.logicalRowExpressions.pushNegationToLeaves(this.not(this.compare(a, OperatorType.GREATER_THAN, b))), (Object)this.compare(a, OperatorType.LESS_THAN_OR_EQUAL, b));
        Assert.assertEquals((Object)this.logicalRowExpressions.pushNegationToLeaves(this.not(this.compare(a, OperatorType.GREATER_THAN_OR_EQUAL, b))), (Object)this.compare(a, OperatorType.LESS_THAN, b));
        Assert.assertEquals((Object)this.logicalRowExpressions.pushNegationToLeaves(this.not(this.compare(a, OperatorType.GREATER_THAN_OR_EQUAL, this.not(this.not(b))))), (Object)this.compare(a, OperatorType.LESS_THAN, b));
        Assert.assertEquals((Object)this.logicalRowExpressions.pushNegationToLeaves(this.not(this.compare(a, OperatorType.LESS_THAN, b))), (Object)this.compare(a, OperatorType.GREATER_THAN_OR_EQUAL, b));
        Assert.assertEquals((Object)this.logicalRowExpressions.pushNegationToLeaves(this.not(this.compare(a, OperatorType.LESS_THAN_OR_EQUAL, b))), (Object)this.compare(a, OperatorType.GREATER_THAN, b));
        Assert.assertEquals((Object)this.logicalRowExpressions.pushNegationToLeaves(this.not(this.compare(a, OperatorType.LESS_THAN_OR_EQUAL, this.not(this.not(b))))), (Object)this.compare(a, OperatorType.GREATER_THAN, b));
    }

    @Test
    public void testEliminateConstant() {
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToConjunctiveNormalForm(this.or(this.and((RowExpression)LogicalRowExpressions.TRUE_CONSTANT, a), this.and((RowExpression)LogicalRowExpressions.FALSE_CONSTANT, b))), (Object)a);
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToDisjunctiveNormalForm(this.or(this.and((RowExpression)LogicalRowExpressions.TRUE_CONSTANT, a), this.and((RowExpression)LogicalRowExpressions.FALSE_CONSTANT, b))), (Object)a);
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToConjunctiveNormalForm(this.and(a, this.and(b, this.or(c, this.and((RowExpression)LogicalRowExpressions.FALSE_CONSTANT, d))))), (Object)this.and(this.and(a, b), c));
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToConjunctiveNormalForm(this.and(a, this.and(b, this.or(c, this.and(e, this.or(f, this.and((RowExpression)LogicalRowExpressions.FALSE_CONSTANT, d))))))), (Object)this.and(this.and(a, b), this.or(c, this.and(e, f))));
    }

    @Test
    public void testDuplicateIsNullExpressions() {
        SpecialFormExpression isNullExpression = new SpecialFormExpression(SpecialFormExpression.Form.IS_NULL, (Type)BooleanType.BOOLEAN, new RowExpression[]{a});
        List<SpecialFormExpression> arguments = Arrays.asList(isNullExpression, isNullExpression);
        SpecialFormExpression duplicateIsNullExpression = new SpecialFormExpression(SpecialFormExpression.Form.OR, (Type)BooleanType.BOOLEAN, arguments);
        this.logicalRowExpressions.minimalNormalForm((RowExpression)duplicateIsNullExpression);
    }

    @Test
    public void testEliminateDuplicate() {
        CallExpression nd = Expressions.call((String)"random", (FunctionHandle)this.functionAndTypeManager.lookupFunction("random", TypeSignatureProvider.fromTypes((Type[])new Type[0])), (Type)DoubleType.DOUBLE, (RowExpression[])new RowExpression[0]);
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToConjunctiveNormalForm(this.or(this.and((RowExpression)LogicalRowExpressions.TRUE_CONSTANT, a), this.and(b, b))), (Object)this.or(a, b));
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToConjunctiveNormalForm(this.or(this.and(a, b), this.and(a, b))), (Object)this.and(a, b));
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToDisjunctiveNormalForm(this.or(this.and(a, b), this.and(a, b))), (Object)this.and(a, b));
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToConjunctiveNormalForm(this.or(this.and(b, a), this.and(a, b))), (Object)this.and(b, a));
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToDisjunctiveNormalForm(this.or(this.and(b, a), this.and(a, b))), (Object)this.and(b, a));
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToConjunctiveNormalForm(this.or(this.and(b, a), a)), (Object)a);
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToDisjunctiveNormalForm(this.or(this.and(b, a), a)), (Object)a);
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToConjunctiveNormalForm(this.and(a, this.or(b, a))), (Object)a);
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToDisjunctiveNormalForm(this.and(a, this.or(b, a))), (Object)a);
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToConjunctiveNormalForm(this.or(this.and(b, a), this.and(this.and(a, b), c))), (Object)this.and(b, a));
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToDisjunctiveNormalForm(this.or(this.and(b, a), this.and(this.and(a, b), c))), (Object)this.and(b, a));
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToConjunctiveNormalForm(this.and(this.or(b, a), this.and(this.or(a, b), this.and(this.or(this.or(c, d), this.or(a, b)), this.or(a, this.or(b, c)))))), (Object)this.or(b, a));
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToConjunctiveNormalForm(this.and(this.and(this.or(b, a), this.and(this.or(a, this.or(b, c)), this.and(this.or(a, b), this.or(this.or(a, b), (RowExpression)nd)))), e)), (Object)this.and(this.and(this.or(b, a), this.or(this.or(a, b), (RowExpression)nd)), e));
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToDisjunctiveNormalForm(this.and(this.and(this.or(b, a), this.and(this.or(a, this.or(b, c)), this.and(this.or(a, b), this.or(this.or(a, b), (RowExpression)nd)))), e)), (Object)this.and(this.and(this.or(b, a), this.or(this.or(a, b), (RowExpression)nd)), e));
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToConjunctiveNormalForm(this.and(this.and(this.or(b, a), this.and(this.or(a, this.or(b, c)), this.and(this.or(a, b), this.or(this.or(a, b), d)))), e)), (Object)this.and(this.or(b, a), e));
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToDisjunctiveNormalForm(this.and(this.and(this.or(b, a), this.and(this.or(a, this.or(b, c)), this.and(this.or(a, b), this.or(this.or(a, b), d)))), e)), (Object)this.or(this.and(b, e), this.and(a, e)));
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToConjunctiveNormalForm(this.and(this.or(this.or(b, a), c), this.and(this.or(d, this.or(a, b)), this.and(this.or(this.or(a, b), e), this.or(this.or(a, b), f))))), (Object)this.and(this.and(this.or(this.or(b, a), c), this.or(this.or(b, a), d)), this.and(this.or(this.or(b, a), e), this.or(this.or(b, a), f))));
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToDisjunctiveNormalForm(this.and(this.or(this.or(b, a), c), this.and(this.or(d, this.or(a, b)), this.and(this.or(this.or(a, b), e), this.or(this.or(a, b), f))))), (Object)this.or(this.or(b, a), this.and(this.and(c, d), this.and(e, f))));
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToConjunctiveNormalForm(this.and(this.or(this.and(a, b), this.and(a, c), this.and(a, d)), this.or(this.and(c, b), this.and(c, a), this.and(c, d)))), (Object)this.and(a, c));
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToDisjunctiveNormalForm(this.and(this.or(this.and(a, b), this.and(a, c), this.and(a, d)), this.or(this.and(c, b), this.and(c, a), this.and(c, d)))), (Object)this.and(a, c));
    }

    @Test
    public void testConvertToCNF() {
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToConjunctiveNormalForm(this.and(a, b)), (Object)this.and(a, b), (String)"Failed 1,1");
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToConjunctiveNormalForm(this.or(a, b)), (Object)this.or(a, b), (String)"Failed to keep same form if cannot convert");
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToConjunctiveNormalForm(this.not(this.and(a, b))), (Object)this.or(this.not(a), this.not(b)), (String)"Failed 1,1 with NOT pushdown");
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToConjunctiveNormalForm(this.or(this.or(a, b), c)), (Object)this.or(this.or(a, b), c), (String)"Failed 1,2");
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToConjunctiveNormalForm(this.or(this.and(a, b), c)), (Object)this.and(this.or(a, c), this.or(b, c)), (String)"Failed 1,3");
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToConjunctiveNormalForm(this.or(this.and(a, this.and(b, this.or(e, g))), c)), (Object)this.and(this.and(this.or(a, c), this.or(b, c)), this.or(this.or(e, g), c)), (String)"Failed 1,3 with multiple clauses");
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToConjunctiveNormalForm(this.or(this.or(a, b), this.or(c, d))), (Object)this.or(this.or(a, b), this.or(c, d)), (String)"Failed 2,2");
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToConjunctiveNormalForm(this.or(this.or(a, b), this.and(this.or(e, f), this.or(g, h)))), (Object)this.and(this.or(this.or(a, b), this.or(e, f)), this.or(this.or(a, b), this.or(g, h))), (String)"Failed 2,3");
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToConjunctiveNormalForm(this.or(this.and(this.or(a, b), this.or(c, d)), this.and(this.or(e, f), this.or(g, h)))), (Object)this.and(this.and(this.or(this.or(a, b), this.or(e, f)), this.or(this.or(a, b), this.or(g, h))), this.and(this.or(this.or(c, d), this.or(e, f)), this.or(this.or(c, d), this.or(g, h)))), (String)"Failed 3,3");
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToConjunctiveNormalForm(this.or(c, this.or(a, b))), (Object)this.or(this.or(c, a), b), (String)"Failed 2,1");
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToConjunctiveNormalForm(this.or(c, this.and(a, b))), (Object)this.and(this.or(c, a), this.or(c, b)), (String)"Failed 3,1");
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToConjunctiveNormalForm(this.or(this.and(this.or(e, f), this.or(g, h)), this.or(a, b))), (Object)this.and(this.or(this.or(e, f), this.or(a, b)), this.or(this.or(g, h), this.or(a, b))), (String)"Failed 3,2");
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToConjunctiveNormalForm(this.or(this.and(a, this.and(b, this.or(e, g))), this.or(this.not(this.and(a, b)), this.not(this.or(b, this.not(this.and(c, d))))))), (Object)this.and(this.and(this.or(this.or(a, this.not(a)), this.not(b)), this.or(this.or(b, this.not(a)), this.not(b))), this.or(this.or(e, g), this.or(this.not(a), this.not(b)))), (String)"Failed 3,3 large with NOT pushdown");
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToConjunctiveNormalForm(this.or(a, this.or(b, this.or(c, this.or(d, this.or(this.and(d, e), this.and(e, f))))))), (Object)this.and(this.or(this.or(this.or(a, b), this.or(c, d)), e), this.or(this.or(this.or(a, b), this.or(c, d)), f)));
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToConjunctiveNormalForm(this.or(this.and(a, this.and(b, c)), this.and(this.and(d, e), f))), (Object)this.or(this.and(this.and(a, b), c), this.and(this.and(d, e), f)));
    }

    @Test
    public void testBigExpressions() {
        RowExpression bigExpression = this.or((RowExpression[])IntStream.range(0, 1000).boxed().map(i -> this.and(TestLogicalRowExpressions.name("a" + i), TestLogicalRowExpressions.name("b" + i))).toArray(RowExpression[]::new));
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToConjunctiveNormalForm(bigExpression), (Object)bigExpression);
        RowExpression bigExpressionWithCommonPredicate = this.or((RowExpression[])IntStream.range(0, 10001).boxed().map(i -> this.and(TestLogicalRowExpressions.name("a"), TestLogicalRowExpressions.name("b" + i))).toArray(RowExpression[]::new));
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToConjunctiveNormalForm(bigExpressionWithCommonPredicate), (Object)this.or((RowExpression[])IntStream.range(0, 10001).boxed().map(i -> this.and(TestLogicalRowExpressions.name("a"), TestLogicalRowExpressions.name("b" + i))).toArray(RowExpression[]::new)));
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToConjunctiveNormalForm(this.or(a, bigExpressionWithCommonPredicate)), (Object)this.or((RowExpression[])Stream.concat(Stream.of(TestLogicalRowExpressions.name("a")), IntStream.range(0, 10001).boxed().map(i -> this.and(TestLogicalRowExpressions.name("a"), TestLogicalRowExpressions.name("b" + i)))).toArray(RowExpression[]::new)));
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToDisjunctiveNormalForm(this.or(a, bigExpressionWithCommonPredicate)), (Object)this.or((RowExpression[])Stream.concat(Stream.of(TestLogicalRowExpressions.name("a")), IntStream.range(0, 10001).boxed().map(i -> this.and(TestLogicalRowExpressions.name("a"), TestLogicalRowExpressions.name("b" + i)))).toArray(RowExpression[]::new)));
    }

    @Test
    public void testConvertToDNF() {
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToDisjunctiveNormalForm(this.or(a, b)), (Object)this.or(a, b), (String)"Failed 1,1");
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToDisjunctiveNormalForm(this.and(a, b)), (Object)this.and(a, b), (String)"Failed to keep same form if cannot convert");
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToDisjunctiveNormalForm(this.not(this.or(a, b))), (Object)this.and(this.not(a), this.not(b)), (String)"Failed 1,1 with NOT pushdown");
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToDisjunctiveNormalForm(this.and(this.and(a, b), c)), (Object)this.and(this.and(a, b), c), (String)"Failed 1,2");
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToDisjunctiveNormalForm(this.and(this.or(a, b), c)), (Object)this.or(this.and(a, c), this.and(b, c)), (String)"Failed 1,3");
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToDisjunctiveNormalForm(this.and(this.or(a, this.or(b, this.and(e, g))), c)), (Object)this.or(this.or(this.and(a, c), this.and(b, c)), this.and(this.and(e, g), c)), (String)"Failed 1,3 with multiple clauses");
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToDisjunctiveNormalForm(this.and(this.and(a, b), this.and(c, d))), (Object)this.and(this.and(a, b), this.and(c, d)), (String)"Failed 2,2");
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToDisjunctiveNormalForm(this.and(this.and(a, b), this.or(this.and(e, f), this.and(g, h)))), (Object)this.or(this.and(this.and(a, b), this.and(e, f)), this.and(this.and(a, b), this.and(g, h))), (String)"Failed 2,3");
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToDisjunctiveNormalForm(this.and(this.or(this.and(a, b), this.and(c, d)), this.or(this.and(e, f), this.and(g, h)))), (Object)this.or(this.or(this.and(this.and(a, b), this.and(e, f)), this.and(this.and(a, b), this.and(g, h))), this.or(this.and(this.and(c, d), this.and(e, f)), this.and(this.and(c, d), this.and(g, h)))), (String)"Failed 3,3");
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToDisjunctiveNormalForm(this.and(c, this.and(a, b))), (Object)this.and(this.and(c, a), b), (String)"Failed 2,1");
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToDisjunctiveNormalForm(this.and(c, this.or(a, b))), (Object)this.or(this.and(c, a), this.and(c, b)), (String)"Failed 3,1");
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToDisjunctiveNormalForm(this.and(this.or(this.and(e, f), this.and(g, h)), this.and(a, b))), (Object)this.or(this.and(this.and(e, f), this.and(a, b)), this.and(this.and(g, h), this.and(a, b))), (String)"Failed 3,2");
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToDisjunctiveNormalForm(this.and(this.or(a, this.or(b, this.and(e, g))), this.and(this.not(this.or(a, b)), this.not(this.and(b, this.not(this.or(c, d))))))), (Object)this.or(this.or(this.and(this.and(a, this.not(a)), this.not(b)), this.and(this.and(b, this.not(a)), this.not(b))), this.and(this.and(e, g), this.and(this.not(a), this.not(b)))), (String)"Failed 3,3 large with NOT pushdown");
        Assert.assertEquals((Object)this.logicalRowExpressions.convertToDisjunctiveNormalForm(this.and(this.or(a, this.or(b, c)), this.or(this.or(d, e), f))), (Object)this.and(this.or(this.or(a, b), c), this.or(this.or(d, e), f)));
    }

    private static RowExpression name(String name) {
        return new VariableReferenceExpression(Optional.empty(), name, (Type)BooleanType.BOOLEAN);
    }

    private static VariableReferenceExpression variable(String name) {
        return new VariableReferenceExpression(Optional.empty(), name, (Type)BooleanType.BOOLEAN);
    }

    private RowExpression compare(RowExpression left, OperatorType operator, RowExpression right) {
        return Expressions.call((String)operator.getOperator(), (FunctionHandle)new FunctionResolution(this.functionAndTypeManager.getFunctionAndTypeResolver()).comparisonFunction(operator, left.getType(), right.getType()), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{left, right});
    }

    private RowExpression and(RowExpression left, RowExpression right) {
        return new SpecialFormExpression(SpecialFormExpression.Form.AND, (Type)BooleanType.BOOLEAN, new RowExpression[]{left, right});
    }

    private RowExpression or(RowExpression ... expressions) {
        return LogicalRowExpressions.or((RowExpression[])expressions);
    }

    private RowExpression or(RowExpression left, RowExpression right) {
        return new SpecialFormExpression(SpecialFormExpression.Form.OR, (Type)BooleanType.BOOLEAN, new RowExpression[]{left, right});
    }

    private RowExpression not(RowExpression expression) {
        return new CallExpression("not", new FunctionResolution(this.functionAndTypeManager.getFunctionAndTypeResolver()).notFunction(), (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)expression));
    }
}

