/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.ttl;

import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.metadata.InMemoryNodeManager;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ttl.ClusterTtlProviderFactory;
import com.facebook.presto.spi.ttl.ConfidenceBasedTtlInfo;
import com.facebook.presto.spi.ttl.NodeInfo;
import com.facebook.presto.spi.ttl.NodeTtl;
import com.facebook.presto.spi.ttl.NodeTtlFetcherFactory;
import com.facebook.presto.spi.ttl.TestingClusterTtlProviderFactory;
import com.facebook.presto.spi.ttl.TestingNodeTtlFetcherFactory;
import com.facebook.presto.ttl.clusterttlprovidermanagers.ConfidenceBasedClusterTtlProviderManager;
import com.facebook.presto.ttl.nodettlfetchermanagers.ConfidenceBasedNodeTtlFetcherManager;
import com.facebook.presto.ttl.nodettlfetchermanagers.NodeTtlFetcherManager;
import com.facebook.presto.ttl.nodettlfetchermanagers.NodeTtlFetcherManagerConfig;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestConfidenceBasedClusterTtlProviderManager {
    private final InternalNode node1 = new InternalNode("node_1", URI.create("local://127.0.0.1"), NodeVersion.UNKNOWN, true);
    private final InternalNode node2 = new InternalNode("node_2", URI.create("local://127.0.0.2"), NodeVersion.UNKNOWN, false);
    private final InternalNode node3 = new InternalNode("node_3", URI.create("local://127.0.0.3"), NodeVersion.UNKNOWN, false);
    private final NodeTtl ttl1 = new NodeTtl((Set)ImmutableSet.of((Object)new ConfidenceBasedTtlInfo(10L, 90.0)));
    private final NodeTtl ttl2 = new NodeTtl((Set)ImmutableSet.of((Object)new ConfidenceBasedTtlInfo(20L, 80.0)));
    private final NodeTtl ttl3 = new NodeTtl((Set)ImmutableSet.of((Object)new ConfidenceBasedTtlInfo(30L, 70.0)));
    private final Map<NodeInfo, NodeTtl> nodeToTtl = ImmutableMap.of((Object)new NodeInfo(this.node1.getNodeIdentifier(), this.node1.getHost()), (Object)this.ttl1, (Object)new NodeInfo(this.node2.getNodeIdentifier(), this.node2.getHost()), (Object)this.ttl2, (Object)new NodeInfo(this.node3.getNodeIdentifier(), this.node3.getHost()), (Object)this.ttl3);
    private ConfidenceBasedClusterTtlProviderManager clusterTtlProviderManager;

    @BeforeClass
    public void setup() {
        InMemoryNodeManager nodeManager = new InMemoryNodeManager();
        nodeManager.addNode(new ConnectorId("prism"), (Iterable)ImmutableSet.of((Object)this.node1, (Object)this.node2, (Object)this.node3));
        ConfidenceBasedNodeTtlFetcherManager nodeTtlFetcherManager = new ConfidenceBasedNodeTtlFetcherManager((InternalNodeManager)nodeManager, new NodeSchedulerConfig(), new NodeTtlFetcherManagerConfig());
        TestingNodeTtlFetcherFactory nodeTtlFetcherFactory = new TestingNodeTtlFetcherFactory(this.nodeToTtl);
        nodeTtlFetcherManager.addNodeTtlFetcherFactory((NodeTtlFetcherFactory)nodeTtlFetcherFactory);
        nodeTtlFetcherManager.load(nodeTtlFetcherFactory.getName(), (Map)ImmutableMap.of());
        nodeTtlFetcherManager.refreshTtlInfo();
        this.clusterTtlProviderManager = new ConfidenceBasedClusterTtlProviderManager((NodeTtlFetcherManager)nodeTtlFetcherManager);
        TestingClusterTtlProviderFactory clusterTtlProviderFactory = new TestingClusterTtlProviderFactory();
        this.clusterTtlProviderManager.addClusterTtlProviderFactory((ClusterTtlProviderFactory)clusterTtlProviderFactory);
        this.clusterTtlProviderManager.load(clusterTtlProviderFactory.getName(), (Map)ImmutableMap.of());
    }

    @Test
    public void testGetClusterTtl() {
        Assert.assertEquals((Object)this.clusterTtlProviderManager.getClusterTtl(), (Object)new ConfidenceBasedTtlInfo(60L, 100.0));
    }
}

