/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.RowPagesBuilder;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.SqlDecimal;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.operator.scalar.FunctionAssertions;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.relation.ExpressionOptimizer;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.relational.RowExpressionOptimizer;
import com.facebook.presto.sql.relational.SqlToRowExpressionTranslator;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Fork(value=3)
@Warmup(iterations=20, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, timeUnit=TimeUnit.MILLISECONDS)
public class BenchmarkDecimalOperators {
    private static final int PAGE_SIZE = 30000;
    private static final DecimalType SHORT_DECIMAL_TYPE = DecimalType.createDecimalType((int)10, (int)0);
    private static final DecimalType LONG_DECIMAL_TYPE = DecimalType.createDecimalType((int)20, (int)0);
    private static final SqlParser SQL_PARSER = new SqlParser();

    @Benchmark
    public Object castDoubleToDecimalBenchmark(CastDoubleToDecimalBenchmarkState state) {
        return this.execute(state);
    }

    @Test
    public void testCastDoubleToDecimalBenchmark() {
        CastDoubleToDecimalBenchmarkState state = new CastDoubleToDecimalBenchmarkState();
        state.setup();
        this.castDoubleToDecimalBenchmark(state);
    }

    @Benchmark
    public Object castDecimalToDoubleBenchmark(CastDecimalToDoubleBenchmarkState state) {
        return this.execute(state);
    }

    @Test
    public void testCastDecimalToDoubleBenchmark() {
        CastDecimalToDoubleBenchmarkState state = new CastDecimalToDoubleBenchmarkState();
        state.setup();
        this.castDecimalToDoubleBenchmark(state);
    }

    @Benchmark
    public Object castDecimalToVarcharBenchmark(CastDecimalToVarcharBenchmarkState state) {
        return this.execute(state);
    }

    @Test
    public void testCastDecimalToVarcharBenchmark() {
        CastDecimalToVarcharBenchmarkState state = new CastDecimalToVarcharBenchmarkState();
        state.setup();
        this.castDecimalToVarcharBenchmark(state);
    }

    @Benchmark
    public Object additionBenchmark(AdditionBenchmarkState state) {
        return this.execute(state);
    }

    @Test
    public void testAdditionBenchmark() {
        AdditionBenchmarkState state = new AdditionBenchmarkState();
        state.setup();
        this.additionBenchmark(state);
    }

    @Benchmark
    public Object multiplyBenchmark(MultiplyBenchmarkState state) {
        return this.execute(state);
    }

    @Test
    public void testMultiplyBenchmark() {
        MultiplyBenchmarkState state = new MultiplyBenchmarkState();
        state.setup();
        this.multiplyBenchmark(state);
    }

    @Benchmark
    public Object divisionBenchmark(DivisionBenchmarkState state) {
        return this.execute(state);
    }

    @Test
    public void testDivisionBenchmark() {
        DivisionBenchmarkState state = new DivisionBenchmarkState();
        state.setup();
        this.divisionBenchmark(state);
    }

    @Benchmark
    public Object moduloBenchmark(ModuloBenchmarkState state) {
        return this.execute(state);
    }

    @Test
    public void testModuloBenchmark() {
        ModuloBenchmarkState state = new ModuloBenchmarkState();
        state.setup();
        this.moduloBenchmark(state);
    }

    @Benchmark
    public Object inequalityBenchmark(InequalityBenchmarkState state) {
        return this.execute(state);
    }

    @Test
    public void testInequalityBenchmark() {
        InequalityBenchmarkState state = new InequalityBenchmarkState();
        state.setup();
        this.inequalityBenchmark(state);
    }

    @Benchmark
    public Object decimalToShortDecimalCastBenchmark(DecimalToShortDecimalCastBenchmarkState state) {
        return this.execute(state);
    }

    @Test
    public void testDecimalToShortDecimalCastBenchmark() {
        DecimalToShortDecimalCastBenchmarkState state = new DecimalToShortDecimalCastBenchmarkState();
        state.setup();
        this.decimalToShortDecimalCastBenchmark(state);
    }

    private Object execute(BaseState state) {
        return ImmutableList.copyOf((Iterator)state.getProcessor().process(TestingConnectorSession.SESSION.getSqlFunctionProperties(), new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), state.getInputPage()));
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkDecimalOperators.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    private static class BaseState {
        private final MetadataManager metadata = MetadataManager.createTestMetadataManager();
        private final Random random = new Random();
        protected final Map<String, Type> symbolTypes = new HashMap<String, Type>();
        private final Map<VariableReferenceExpression, Integer> sourceLayout = new HashMap<VariableReferenceExpression, Integer>();
        protected final List<Type> types = new LinkedList<Type>();
        protected Page inputPage;
        private PageProcessor processor;
        private double doubleMaxValue = 4.294967296E9;

        private BaseState() {
        }

        public Page getInputPage() {
            return this.inputPage;
        }

        public PageProcessor getProcessor() {
            return this.processor;
        }

        protected void addSymbol(String name, Type type) {
            this.symbolTypes.put(name, type);
            this.sourceLayout.put(new VariableReferenceExpression(Optional.empty(), name, type), this.types.size());
            this.types.add(type);
        }

        protected void generateRandomInputPage() {
            RowPagesBuilder buildPagesBuilder = RowPagesBuilder.rowPagesBuilder(this.types);
            for (int i = 0; i < 30000; ++i) {
                Object[] values = this.types.stream().map(this::generateRandomValue).collect(Collectors.toList()).toArray();
                buildPagesBuilder.row(values);
            }
            this.inputPage = (Page)Iterables.getOnlyElement(buildPagesBuilder.build());
        }

        protected void generateInputPage(int ... initialValues) {
            RowPagesBuilder buildPagesBuilder = RowPagesBuilder.rowPagesBuilder(this.types);
            buildPagesBuilder.addSequencePage(30000, initialValues);
            this.inputPage = (Page)Iterables.getOnlyElement(buildPagesBuilder.build());
        }

        protected void generateProcessor(String expression) {
            this.processor = (PageProcessor)new ExpressionCompiler((Metadata)this.metadata, new PageFunctionCompiler((Metadata)this.metadata, 0)).compilePageProcessor(TestingConnectorSession.SESSION.getSqlFunctionProperties(), Optional.empty(), (List)ImmutableList.of((Object)this.rowExpression(expression))).get();
        }

        protected void setDoubleMaxValue(double doubleMaxValue) {
            this.doubleMaxValue = doubleMaxValue;
        }

        private RowExpression rowExpression(String value) {
            Expression expression = FunctionAssertions.createExpression(value, (Metadata)this.metadata, TypeProvider.copyOf(this.symbolTypes));
            Map expressionTypes = ExpressionAnalyzer.getExpressionTypes((Session)SessionTestUtils.TEST_SESSION, (Metadata)this.metadata, (SqlParser)SQL_PARSER, (TypeProvider)TypeProvider.copyOf(this.symbolTypes), (Expression)expression, Collections.emptyMap(), (WarningCollector)WarningCollector.NOOP);
            RowExpression rowExpression = SqlToRowExpressionTranslator.translate((Expression)expression, (Map)expressionTypes, this.sourceLayout, (FunctionAndTypeManager)this.metadata.getFunctionAndTypeManager(), (Session)SessionTestUtils.TEST_SESSION);
            RowExpressionOptimizer optimizer = new RowExpressionOptimizer((Metadata)this.metadata);
            return optimizer.optimize(rowExpression, ExpressionOptimizer.Level.OPTIMIZED, SessionTestUtils.TEST_SESSION.toConnectorSession());
        }

        private Object generateRandomValue(Type type) {
            if (type instanceof DoubleType) {
                return this.random.nextDouble() * (2.0 * this.doubleMaxValue) - this.doubleMaxValue;
            }
            if (type instanceof DecimalType) {
                return this.randomDecimal((DecimalType)type);
            }
            if (type instanceof BigintType) {
                int randomInt = this.random.nextInt();
                return randomInt == 0 ? 1 : randomInt;
            }
            throw new UnsupportedOperationException(type.toString());
        }

        private SqlDecimal randomDecimal(DecimalType type) {
            int maxBits = (int)(Math.log(Math.pow(10.0, type.getPrecision())) / Math.log(2.0));
            BigInteger bigInteger = new BigInteger(maxBits, this.random);
            if (bigInteger.equals(BigInteger.ZERO)) {
                bigInteger = BigInteger.ONE;
            }
            if (this.random.nextBoolean()) {
                bigInteger = bigInteger.negate();
            }
            return new SqlDecimal(bigInteger, type.getPrecision(), type.getScale());
        }
    }

    @State(value=Scope.Thread)
    public static class DecimalToShortDecimalCastBenchmarkState
    extends BaseState {
        @Param(value={"cast(l_38_30 as decimal(8, 0))", "cast(l_26_18 as decimal(8, 0))", "cast(l_20_12 as decimal(8, 0))", "cast(l_20_8 as decimal(8, 0))", "cast(s_17_9 as decimal(8, 0))"})
        private String expression = "cast(l_38_30 as decimal(8, 0))";

        @Setup
        public void setup() {
            this.addSymbol("l_38_30", (Type)DecimalType.createDecimalType((int)38, (int)30));
            this.addSymbol("l_26_18", (Type)DecimalType.createDecimalType((int)26, (int)18));
            this.addSymbol("l_20_12", (Type)DecimalType.createDecimalType((int)20, (int)12));
            this.addSymbol("l_20_8", (Type)DecimalType.createDecimalType((int)20, (int)8));
            this.addSymbol("s_17_9", (Type)DecimalType.createDecimalType((int)17, (int)9));
            this.generateInputPage(10000, 10000, 10000, 10000, 10000);
            this.generateProcessor(this.expression);
        }
    }

    @State(value=Scope.Thread)
    public static class InequalityBenchmarkState
    extends BaseState {
        @Param(value={"d1 < d2", "d1 < d2 AND d1 < d3 AND d1 < d4 AND d2 < d3 AND d2 < d4 AND d3 < d4", "s1 < s2", "s1 < s2 AND s1 < s3 AND s1 < s4 AND s2 < s3 AND s2 < s4 AND s3 < s4", "l1 < l2", "l1 < l2 AND l1 < l3 AND l1 < l4 AND l2 < l3 AND l2 < l4 AND l3 < l4"})
        private String expression = "d1 < d2";

        @Setup
        public void setup() {
            this.addSymbol("d1", (Type)DoubleType.DOUBLE);
            this.addSymbol("d2", (Type)DoubleType.DOUBLE);
            this.addSymbol("d3", (Type)DoubleType.DOUBLE);
            this.addSymbol("d4", (Type)DoubleType.DOUBLE);
            this.addSymbol("s1", (Type)SHORT_DECIMAL_TYPE);
            this.addSymbol("s2", (Type)SHORT_DECIMAL_TYPE);
            this.addSymbol("s3", (Type)SHORT_DECIMAL_TYPE);
            this.addSymbol("s4", (Type)SHORT_DECIMAL_TYPE);
            this.addSymbol("l1", (Type)LONG_DECIMAL_TYPE);
            this.addSymbol("l2", (Type)LONG_DECIMAL_TYPE);
            this.addSymbol("l3", (Type)LONG_DECIMAL_TYPE);
            this.addSymbol("l4", (Type)LONG_DECIMAL_TYPE);
            this.generateInputPage(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11);
            this.generateProcessor(this.expression);
        }
    }

    @State(value=Scope.Thread)
    public static class ModuloBenchmarkState
    extends BaseState {
        @Param(value={"d1 % d2", "d1 % d2 % d3 % d4", "i1 % i2", "i1 % i2 % i3 % i4", "s1 % s2", "s1 % s2 % s2 % s2", "s2 % l2", "l3 % s3", "s4 % l3", "l2 % l3", "l2 % l3 % l4 % l1"})
        private String expression = "d1 % d2";

        @Setup
        public void setup() {
            this.addSymbol("d1", (Type)DoubleType.DOUBLE);
            this.addSymbol("d2", (Type)DoubleType.DOUBLE);
            this.addSymbol("d3", (Type)DoubleType.DOUBLE);
            this.addSymbol("d4", (Type)DoubleType.DOUBLE);
            this.addSymbol("i1", (Type)BigintType.BIGINT);
            this.addSymbol("i2", (Type)BigintType.BIGINT);
            this.addSymbol("i3", (Type)BigintType.BIGINT);
            this.addSymbol("i4", (Type)BigintType.BIGINT);
            this.addSymbol("s1", (Type)DecimalType.createDecimalType((int)8, (int)3));
            this.addSymbol("s2", (Type)DecimalType.createDecimalType((int)6, (int)2));
            this.addSymbol("s3", (Type)DecimalType.createDecimalType((int)9, (int)0));
            this.addSymbol("s4", (Type)DecimalType.createDecimalType((int)12, (int)2));
            this.addSymbol("l1", (Type)DecimalType.createDecimalType((int)19, (int)3));
            this.addSymbol("l2", (Type)DecimalType.createDecimalType((int)20, (int)3));
            this.addSymbol("l3", (Type)DecimalType.createDecimalType((int)21, (int)10));
            this.addSymbol("l4", (Type)DecimalType.createDecimalType((int)19, (int)4));
            this.generateRandomInputPage();
            this.generateProcessor(this.expression);
        }
    }

    @State(value=Scope.Thread)
    public static class DivisionBenchmarkState
    extends BaseState {
        @Param(value={"d1 / d2", "d1 / d2 / d3 / d4", "i1 / i2", "i1 / i2 / i3 / i4", "s1 / s2", "s1 / s2 / s2 / s2", "s1 / s3", "s2 / l1", "l1 / s2", "s3 / l1", "l2 / l3", "l2 / l4 / l4 / l4", "l2 / s4 / s4 / s4"})
        private String expression = "d1 / d2";

        @Setup
        public void setup() {
            this.addSymbol("d1", (Type)DoubleType.DOUBLE);
            this.addSymbol("d2", (Type)DoubleType.DOUBLE);
            this.addSymbol("d3", (Type)DoubleType.DOUBLE);
            this.addSymbol("d4", (Type)DoubleType.DOUBLE);
            this.addSymbol("i1", (Type)BigintType.BIGINT);
            this.addSymbol("i2", (Type)BigintType.BIGINT);
            this.addSymbol("i3", (Type)BigintType.BIGINT);
            this.addSymbol("i4", (Type)BigintType.BIGINT);
            this.addSymbol("s1", (Type)DecimalType.createDecimalType((int)8, (int)3));
            this.addSymbol("s2", (Type)DecimalType.createDecimalType((int)6, (int)2));
            this.addSymbol("s3", (Type)DecimalType.createDecimalType((int)17, (int)7));
            this.addSymbol("s4", (Type)DecimalType.createDecimalType((int)3, (int)2));
            this.addSymbol("l1", (Type)DecimalType.createDecimalType((int)19, (int)3));
            this.addSymbol("l2", (Type)DecimalType.createDecimalType((int)20, (int)3));
            this.addSymbol("l3", (Type)DecimalType.createDecimalType((int)21, (int)10));
            this.addSymbol("l4", (Type)DecimalType.createDecimalType((int)19, (int)4));
            this.generateRandomInputPage();
            this.generateProcessor(this.expression);
        }
    }

    @State(value=Scope.Thread)
    public static class MultiplyBenchmarkState
    extends BaseState {
        @Param(value={"d1 * d2", "d1 * d2 * d3 * d4", "i1 * i2", "s1 * s2", "s1 * s2 * s5 * s6", "s3 * s4", "l2 * s2", "l2 * s2 * s5 * s6", "s1 * l2", "l1 * l2"})
        private String expression = "d1 * d2";

        @Setup
        public void setup() {
            this.addSymbol("d1", (Type)DoubleType.DOUBLE);
            this.addSymbol("d2", (Type)DoubleType.DOUBLE);
            this.addSymbol("d3", (Type)DoubleType.DOUBLE);
            this.addSymbol("d4", (Type)DoubleType.DOUBLE);
            this.addSymbol("i1", (Type)BigintType.BIGINT);
            this.addSymbol("i2", (Type)BigintType.BIGINT);
            this.addSymbol("s1", (Type)DecimalType.createDecimalType((int)5, (int)2));
            this.addSymbol("s2", (Type)DecimalType.createDecimalType((int)3, (int)1));
            this.addSymbol("s3", (Type)DecimalType.createDecimalType((int)10, (int)5));
            this.addSymbol("s4", (Type)DecimalType.createDecimalType((int)10, (int)2));
            this.addSymbol("s5", (Type)DecimalType.createDecimalType((int)3, (int)2));
            this.addSymbol("s6", (Type)DecimalType.createDecimalType((int)2, (int)1));
            this.addSymbol("l1", (Type)DecimalType.createDecimalType((int)19, (int)10));
            this.addSymbol("l2", (Type)DecimalType.createDecimalType((int)19, (int)5));
            this.generateRandomInputPage();
            this.generateProcessor(this.expression);
        }
    }

    @State(value=Scope.Thread)
    public static class AdditionBenchmarkState
    extends BaseState {
        @Param(value={"d1 + d2", "d1 + d2 + d3 + d4", "s1 + s2", "s1 + s2 + s3 + s4", "l1 + l2", "l1 + l2 + l3 + l4", "s2 + l3 + l1 + s4"})
        private String expression = "d1 + d2";

        @Setup
        public void setup() {
            this.addSymbol("d1", (Type)DoubleType.DOUBLE);
            this.addSymbol("d2", (Type)DoubleType.DOUBLE);
            this.addSymbol("d3", (Type)DoubleType.DOUBLE);
            this.addSymbol("d4", (Type)DoubleType.DOUBLE);
            this.addSymbol("s1", (Type)DecimalType.createDecimalType((int)10, (int)5));
            this.addSymbol("s2", (Type)DecimalType.createDecimalType((int)7, (int)2));
            this.addSymbol("s3", (Type)DecimalType.createDecimalType((int)12, (int)2));
            this.addSymbol("s4", (Type)DecimalType.createDecimalType((int)2, (int)1));
            this.addSymbol("l1", (Type)DecimalType.createDecimalType((int)35, (int)10));
            this.addSymbol("l2", (Type)DecimalType.createDecimalType((int)25, (int)5));
            this.addSymbol("l3", (Type)DecimalType.createDecimalType((int)20, (int)6));
            this.addSymbol("l4", (Type)DecimalType.createDecimalType((int)25, (int)8));
            this.generateRandomInputPage();
            this.generateProcessor(this.expression);
        }
    }

    @State(value=Scope.Thread)
    public static class CastDecimalToVarcharBenchmarkState
    extends BaseState {
        private static final int SCALE = 10;
        @Param(value={"15", "35"})
        private String precision = "35";

        @Setup
        public void setup() {
            this.addSymbol("v1", (Type)DecimalType.createDecimalType((int)Integer.valueOf(this.precision), (int)10));
            String expression = "CAST(v1 AS VARCHAR)";
            this.generateRandomInputPage();
            this.generateProcessor(expression);
        }
    }

    @State(value=Scope.Thread)
    public static class CastDecimalToDoubleBenchmarkState
    extends BaseState {
        private static final int SCALE = 10;
        @Param(value={"15", "35"})
        private String precision = "15";

        @Setup
        public void setup() {
            this.addSymbol("v1", (Type)DecimalType.createDecimalType((int)Integer.valueOf(this.precision), (int)10));
            String expression = "CAST(v1 AS DOUBLE)";
            this.generateRandomInputPage();
            this.generateProcessor(expression);
        }
    }

    @State(value=Scope.Thread)
    public static class CastDoubleToDecimalBenchmarkState
    extends BaseState {
        private static final int SCALE = 2;
        @Param(value={"10", "35", "BIGINT"})
        private String precision = "10";

        @Setup
        public void setup() {
            String expression;
            this.addSymbol("d1", (Type)DoubleType.DOUBLE);
            if (this.precision.equals("BIGINT")) {
                this.setDoubleMaxValue(9.223372036854776E18);
                expression = "CAST(d1 AS BIGINT)";
            } else {
                this.setDoubleMaxValue(Math.pow(9.0, Integer.valueOf(this.precision) - 2));
                expression = String.format("CAST(d1 AS DECIMAL(%s, %d))", this.precision, 2);
            }
            this.generateRandomInputPage();
            this.generateProcessor(expression);
        }
    }
}

