/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.util.Failures;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestFailures {
    @Test
    public void testToFailureLoop() {
        Throwable exception1 = new PrestoException((ErrorCodeSupplier)StandardErrorCode.TOO_MANY_REQUESTS_FAILED, "fake exception 1");
        RuntimeException exception2 = new RuntimeException("fake exception 2", exception1);
        exception1.addSuppressed(exception2);
        ExecutionFailureInfo failure = Failures.toFailure((Throwable)exception1);
        Assert.assertEquals((String)failure.getMessage(), (String)"fake exception 1");
        Assert.assertNull((Object)failure.getCause());
        Assert.assertEquals((int)failure.getSuppressed().size(), (int)1);
        Assert.assertEquals((String)((ExecutionFailureInfo)failure.getSuppressed().get(0)).getMessage(), (String)"fake exception 2");
        Assert.assertEquals((Object)failure.getErrorCode(), (Object)StandardErrorCode.TOO_MANY_REQUESTS_FAILED.toErrorCode());
        failure = Failures.toFailure((Throwable)exception2);
        Assert.assertEquals((String)failure.getMessage(), (String)"fake exception 2");
        Assert.assertNotNull((Object)failure.getCause());
        Assert.assertEquals((String)failure.getCause().getMessage(), (String)"fake exception 1");
        Assert.assertEquals((int)failure.getSuppressed().size(), (int)0);
        Assert.assertEquals((Object)failure.getErrorCode(), (Object)StandardErrorCode.TOO_MANY_REQUESTS_FAILED.toErrorCode());
        exception1 = new PrestoException((ErrorCodeSupplier)StandardErrorCode.TOO_MANY_REQUESTS_FAILED, "fake exception 1");
        exception2 = new RuntimeException("fake exception 2");
        exception1.addSuppressed(exception2);
        exception2.addSuppressed(exception1);
        failure = Failures.toFailure((Throwable)exception1);
        Assert.assertEquals((String)failure.getMessage(), (String)"fake exception 1");
        Assert.assertNull((Object)failure.getCause());
        Assert.assertEquals((int)failure.getSuppressed().size(), (int)1);
        Assert.assertEquals((String)((ExecutionFailureInfo)failure.getSuppressed().get(0)).getMessage(), (String)"fake exception 2");
        Assert.assertEquals((Object)failure.getErrorCode(), (Object)StandardErrorCode.TOO_MANY_REQUESTS_FAILED.toErrorCode());
        exception1 = new RuntimeException("fake exception 1");
        exception2 = new RuntimeException("fake exception 2", exception1);
        exception1.initCause(exception2);
        failure = Failures.toFailure((Throwable)exception2);
        Assert.assertEquals((String)failure.getMessage(), (String)"fake exception 2");
        Assert.assertNotNull((Object)failure.getCause());
        Assert.assertEquals((String)failure.getCause().getMessage(), (String)"fake exception 1");
        Assert.assertEquals((int)failure.getSuppressed().size(), (int)0);
        Assert.assertEquals((Object)failure.getErrorCode(), (Object)StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode());
    }
}

