/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.util.PeriodicTaskExecutor;
import com.google.common.base.Stopwatch;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestPeriodicTaskExecutor {
    private ScheduledExecutorService executorService;

    @BeforeMethod
    public void setUp() {
        this.executorService = Executors.newSingleThreadScheduledExecutor();
    }

    @AfterMethod
    public void tearDown() {
        this.executorService.shutdownNow();
    }

    @Test(enabled=false)
    public void testTick() throws Exception {
        int numberOfTicks = 2;
        long durationBetweenTicksInSeconds = 2L;
        CountDownLatch latch = new CountDownLatch(3);
        Runnable runnable = latch::countDown;
        try (PeriodicTaskExecutor executor = new PeriodicTaskExecutor(TimeUnit.SECONDS.toMillis(durationBetweenTicksInSeconds), 500L, this.executorService, runnable, i -> i);){
            executor.start();
            Stopwatch stopwatch = Stopwatch.createStarted();
            latch.await(10L, TimeUnit.SECONDS);
            stopwatch.stop();
            Assert.assertEquals((long)((long)numberOfTicks * durationBetweenTicksInSeconds), (long)stopwatch.elapsed(TimeUnit.SECONDS));
            Assert.assertEquals((long)latch.getCount(), (long)0L);
        }
    }
}

