/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.util.QueryInfoUtils;
import com.google.common.base.Strings;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestQueryInfoUtils {
    @Test
    public void testComputeQueryHash() {
        String query = "SELECT * FROM CUSTOMER LIMIT 5";
        Assert.assertEquals((String)QueryInfoUtils.computeQueryHash((String)query), (String)"7f3325a942b43504");
    }

    @Test
    public void testComputeQueryHashLongQuery() {
        String longQuery = "SELECT x" + Strings.repeat((String)",x", (int)500000) + " FROM (VALUES 1,2,3,4,5) t(x)";
        Assert.assertEquals((String)QueryInfoUtils.computeQueryHash((String)longQuery), (String)"26691c4d35d09c7b");
    }

    @Test
    public void testComputeQueryHashEquivalentStrings() {
        String query1 = "SELECT * FROM REPORTS WHERE YEAR >= 2000 AND ID = 293";
        String query2 = "SELECT * FROM REPORTS WHERE YEAR >= 2000 AND ID = 293";
        Assert.assertEquals((String)QueryInfoUtils.computeQueryHash((String)query1), (String)QueryInfoUtils.computeQueryHash((String)query2));
    }

    @Test
    public void testComputeQueryHashEmptyString() {
        String query = "";
        Assert.assertTrue((boolean)QueryInfoUtils.computeQueryHash((String)query).isEmpty());
    }
}

