/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.common.type.DateTimeEncoding;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.util.DateTimeZoneIndex;
import java.time.ZoneId;
import java.util.SortedSet;
import java.util.TreeSet;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTimeZoneUtils {
    @Test
    public void testNamedZones() {
        TimeZoneKey.getTimeZoneKey((String)"GMT-13:00");
        TreeSet<String> jdkZones = new TreeSet<String>(ZoneId.getAvailableZoneIds());
        for (String zoneId : new TreeSet<String>((SortedSet<String>)jdkZones)) {
            if (zoneId.startsWith("Etc/") || zoneId.startsWith("GMT") || zoneId.startsWith("SystemV/") || zoneId.equals("Canada/East-Saskatchewan") || zoneId.equals("America/Godthab") || zoneId.equals("US/Pacific-New") || zoneId.equals("Europe/Zaporozhye") || zoneId.equals("Europe/Uzhgorod") || zoneId.equals("Europe/Kiev") || zoneId.equals("Europe/Kyiv")) continue;
            DateTimeZone dateTimeZone = DateTimeZone.forID((String)zoneId);
            DateTimeZone indexedZone = DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)zoneId));
            TestTimeZoneUtils.assertDateTimeZoneEquals(zoneId, indexedZone);
            TestTimeZoneUtils.assertTimeZone(zoneId, dateTimeZone);
        }
    }

    @Test
    public void testOffsets() {
        for (int offsetHours = -13; offsetHours < 14; ++offsetHours) {
            for (int offsetMinutes = 0; offsetMinutes < 60; ++offsetMinutes) {
                DateTimeZone dateTimeZone = DateTimeZone.forOffsetHoursMinutes((int)offsetHours, (int)offsetMinutes);
                TestTimeZoneUtils.assertTimeZone(dateTimeZone.getID(), dateTimeZone);
            }
        }
    }

    public static void assertTimeZone(String zoneId, DateTimeZone dateTimeZone) {
        long packWithZoneId;
        long packWithDateTime = DateTimeZoneIndex.packDateTimeWithZone((DateTime)new DateTime(42L, dateTimeZone));
        if (packWithDateTime != (packWithZoneId = DateTimeEncoding.packDateTimeWithZone((long)42L, (String)ZoneId.of(dateTimeZone.getID()).getId()))) {
            Assert.fail((String)String.format("packWithDateTime and packWithZoneId differ for zone [%s] / [%s]: %s [%s %s] and %s [%s %s]", zoneId, dateTimeZone, packWithDateTime, DateTimeEncoding.unpackMillisUtc((long)packWithDateTime), DateTimeEncoding.unpackZoneKey((long)packWithDateTime), packWithZoneId, DateTimeEncoding.unpackMillisUtc((long)packWithZoneId), DateTimeEncoding.unpackZoneKey((long)packWithZoneId)));
        }
        DateTimeZone unpackedZone = DateTimeZoneIndex.unpackDateTimeZone((long)packWithDateTime);
        TestTimeZoneUtils.assertDateTimeZoneEquals(zoneId, unpackedZone);
    }

    public static void assertDateTimeZoneEquals(String zoneId, DateTimeZone actualTimeZone) {
        DateTimeZone expectedDateTimeZone = TimeZoneKey.isUtcZoneId((String)zoneId) ? DateTimeZone.UTC : DateTimeZone.forID((String)zoneId);
        Assert.assertEquals((Object)actualTimeZone, (Object)expectedDateTimeZone);
    }
}

