/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.GroupByHashPageIndexer;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.PageIndexer;
import com.facebook.presto.spi.PageIndexerFactory;
import com.facebook.presto.sql.gen.JoinCompiler;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class GroupByHashPageIndexerFactory
implements PageIndexerFactory {
    private final JoinCompiler joinCompiler;

    @Inject
    public GroupByHashPageIndexerFactory(JoinCompiler joinCompiler) {
        this.joinCompiler = Objects.requireNonNull(joinCompiler, "joinCompiler is null");
    }

    public PageIndexer createPageIndexer(List<? extends Type> types) {
        if (types.isEmpty()) {
            return new NoHashPageIndexer();
        }
        return new GroupByHashPageIndexer(types, this.joinCompiler);
    }

    private static class NoHashPageIndexer
    implements PageIndexer {
        private NoHashPageIndexer() {
        }

        public int[] indexPage(Page page) {
            return new int[page.getPositionCount()];
        }

        public int getMaxIndex() {
            return 0;
        }
    }
}

