/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.common.type.FixedWidthType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VariableWidthType;
import com.facebook.presto.cost.JoinNodeStatsEstimate;
import com.facebook.presto.cost.PartialAggregationStatsEstimate;
import com.facebook.presto.cost.TableWriterNodeStatsEstimate;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.statistics.CostBasedSourceInfo;
import com.facebook.presto.spi.statistics.Estimate;
import com.facebook.presto.spi.statistics.JoinNodeStatistics;
import com.facebook.presto.spi.statistics.PartialAggregationStatistics;
import com.facebook.presto.spi.statistics.PlanStatistics;
import com.facebook.presto.spi.statistics.PlanStatisticsWithSourceInfo;
import com.facebook.presto.spi.statistics.SourceInfo;
import com.facebook.presto.spi.statistics.TableWriterNodeStatistics;
import com.facebook.presto.sql.Serialization;
import com.facebook.presto.util.MoreMath;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.pcollections.HashTreePMap;
import org.pcollections.PMap;

public class PlanNodeStatsEstimate {
    private static final double DEFAULT_DATA_SIZE_PER_COLUMN = 50.0;
    private static final PlanNodeStatsEstimate UNKNOWN = new PlanNodeStatsEstimate(Double.NaN, Double.NaN, false, (Map<VariableReferenceExpression, VariableStatsEstimate>)ImmutableMap.of(), JoinNodeStatsEstimate.unknown(), TableWriterNodeStatsEstimate.unknown(), PartialAggregationStatsEstimate.unknown());
    private final double outputRowCount;
    private final double totalSize;
    private final PMap<VariableReferenceExpression, VariableStatsEstimate> variableStatistics;
    private final SourceInfo sourceInfo;
    private final JoinNodeStatsEstimate joinNodeStatsEstimate;
    private final TableWriterNodeStatsEstimate tableWriterNodeStatsEstimate;
    private final PartialAggregationStatsEstimate partialAggregationStatsEstimate;

    public static PlanNodeStatsEstimate unknown() {
        return UNKNOWN;
    }

    @JsonCreator
    public PlanNodeStatsEstimate(@JsonProperty(value="outputRowCount") double outputRowCount, @JsonProperty(value="totalSize") double totalSize, @JsonProperty(value="confident") boolean confident, @JsonProperty(value="variableStatistics") Map<VariableReferenceExpression, VariableStatsEstimate> variableStatistics, @JsonProperty(value="joinNodeStatsEstimate") JoinNodeStatsEstimate joinNodeStatsEstimate, @JsonProperty(value="tableWriterNodeStatsEstimate") TableWriterNodeStatsEstimate tableWriterNodeStatsEstimate, @JsonProperty(value="partialAggregationStatsEstimate") PartialAggregationStatsEstimate partialAggregationStatsEstimate) {
        this(outputRowCount, totalSize, (PMap<VariableReferenceExpression, VariableStatsEstimate>)HashTreePMap.from(Objects.requireNonNull(variableStatistics, "variableStatistics is null")), (SourceInfo)new CostBasedSourceInfo(confident), joinNodeStatsEstimate, tableWriterNodeStatsEstimate, partialAggregationStatsEstimate);
    }

    private PlanNodeStatsEstimate(double outputRowCount, double totalSize, boolean confident, PMap<VariableReferenceExpression, VariableStatsEstimate> variableStatistics) {
        this(outputRowCount, totalSize, variableStatistics, (SourceInfo)new CostBasedSourceInfo(confident));
    }

    public PlanNodeStatsEstimate(double outputRowCount, double totalSize, PMap<VariableReferenceExpression, VariableStatsEstimate> variableStatistics, SourceInfo sourceInfo) {
        this(outputRowCount, totalSize, variableStatistics, sourceInfo, JoinNodeStatsEstimate.unknown(), TableWriterNodeStatsEstimate.unknown(), PartialAggregationStatsEstimate.unknown());
    }

    public PlanNodeStatsEstimate(double outputRowCount, double totalSize, PMap<VariableReferenceExpression, VariableStatsEstimate> variableStatistics, SourceInfo sourceInfo, JoinNodeStatsEstimate joinNodeStatsEstimate, TableWriterNodeStatsEstimate tableWriterNodeStatsEstimate, PartialAggregationStatsEstimate partialAggregationStatsEstimate) {
        Preconditions.checkArgument((Double.isNaN(outputRowCount) || outputRowCount >= 0.0 ? 1 : 0) != 0, (Object)"outputRowCount cannot be negative");
        this.outputRowCount = outputRowCount;
        this.totalSize = totalSize;
        this.variableStatistics = variableStatistics;
        this.sourceInfo = Objects.requireNonNull(sourceInfo, "SourceInfo is null");
        this.joinNodeStatsEstimate = Objects.requireNonNull(joinNodeStatsEstimate, "joinNodeSpecificStatsEstimate is null");
        this.tableWriterNodeStatsEstimate = Objects.requireNonNull(tableWriterNodeStatsEstimate, "tableWriterNodeStatsEstimate is null");
        this.partialAggregationStatsEstimate = Objects.requireNonNull(partialAggregationStatsEstimate, "partialAggregationStatsEstimate is null");
    }

    @JsonProperty
    public double getOutputRowCount() {
        return this.outputRowCount;
    }

    @JsonProperty
    public double getTotalSize() {
        return this.totalSize;
    }

    @JsonProperty
    public boolean isConfident() {
        return this.sourceInfo.isConfident();
    }

    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    @JsonProperty
    public JoinNodeStatsEstimate getJoinNodeStatsEstimate() {
        return this.joinNodeStatsEstimate;
    }

    @JsonProperty
    public TableWriterNodeStatsEstimate getTableWriterNodeStatsEstimate() {
        return this.tableWriterNodeStatsEstimate;
    }

    @JsonProperty
    public PartialAggregationStatsEstimate getPartialAggregationStatsEstimate() {
        return this.partialAggregationStatsEstimate;
    }

    public double getOutputSizeInBytes() {
        return this.totalSize;
    }

    public double getOutputSizeInBytes(PlanNode planNode) {
        Objects.requireNonNull(planNode, "planNode is null");
        if (!this.sourceInfo.estimateSizeUsingVariables() && !Double.isNaN(this.totalSize)) {
            return this.totalSize;
        }
        return this.getOutputSizeForVariables(planNode.getOutputVariables());
    }

    public double getOutputSizeForVariables(Collection<VariableReferenceExpression> outputVariables) {
        Objects.requireNonNull(outputVariables, "outputSymbols is null");
        return outputVariables.stream().mapToDouble(variable -> this.getOutputSizeForVariable(this.getVariableStatistics((VariableReferenceExpression)variable), variable.getType())).sum();
    }

    private double getOutputSizeForVariable(VariableStatsEstimate variableStatistics, Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type is null");
        double averageRowSize = variableStatistics.getAverageRowSize();
        double nullsFraction = MoreMath.firstNonNaN(variableStatistics.getNullsFraction(), 0.0);
        double numberOfNonNullRows = this.outputRowCount * (1.0 - nullsFraction);
        if (Double.isNaN(averageRowSize)) {
            averageRowSize = type instanceof FixedWidthType ? (double)((FixedWidthType)type).getFixedSize() : 50.0;
        }
        double outputSize = numberOfNonNullRows * averageRowSize;
        outputSize += this.outputRowCount * 1.0;
        if (type instanceof VariableWidthType) {
            outputSize += this.outputRowCount * 4.0;
        }
        return outputSize;
    }

    public PlanNodeStatsEstimate mapOutputRowCount(Function<Double, Double> mappingFunction) {
        return PlanNodeStatsEstimate.buildFrom(this).setOutputRowCount(mappingFunction.apply(this.outputRowCount)).build();
    }

    public PlanNodeStatsEstimate mapVariableColumnStatistics(VariableReferenceExpression variable, Function<VariableStatsEstimate, VariableStatsEstimate> mappingFunction) {
        return PlanNodeStatsEstimate.buildFrom(this).addVariableStatistics(variable, mappingFunction.apply(this.getVariableStatistics(variable))).build();
    }

    public VariableStatsEstimate getVariableStatistics(VariableReferenceExpression variable) {
        return (VariableStatsEstimate)this.variableStatistics.getOrDefault((Object)variable, (Object)VariableStatsEstimate.unknown());
    }

    @JsonSerialize(keyUsing=Serialization.VariableReferenceExpressionSerializer.class)
    @JsonProperty
    public Map<VariableReferenceExpression, VariableStatsEstimate> getVariableStatistics() {
        return this.variableStatistics;
    }

    public Set<VariableReferenceExpression> getVariablesWithKnownStatistics() {
        return this.variableStatistics.keySet();
    }

    public boolean isOutputRowCountUnknown() {
        return Double.isNaN(this.outputRowCount);
    }

    public boolean isTotalSizeUnknown() {
        return Double.isNaN(this.totalSize);
    }

    public PlanNodeStatsEstimate combineStats(PlanStatistics planStatistics, SourceInfo statsSourceInfo) {
        if (planStatistics.getConfidence() > 0.0) {
            return new PlanNodeStatsEstimate(planStatistics.getRowCount().getValue(), planStatistics.getOutputSize().getValue(), this.variableStatistics, statsSourceInfo, planStatistics.getJoinNodeStatistics().isEmpty() ? this.getJoinNodeStatsEstimate() : new JoinNodeStatsEstimate(planStatistics.getJoinNodeStatistics().getNullJoinBuildKeyCount().getValue(), planStatistics.getJoinNodeStatistics().getJoinBuildKeyCount().getValue(), planStatistics.getJoinNodeStatistics().getNullJoinProbeKeyCount().getValue(), planStatistics.getJoinNodeStatistics().getJoinProbeKeyCount().getValue()), planStatistics.getTableWriterNodeStatistics().isEmpty() ? this.getTableWriterNodeStatsEstimate() : new TableWriterNodeStatsEstimate(planStatistics.getTableWriterNodeStatistics().getTaskCountIfScaledWriter().getValue()), planStatistics.getPartialAggregationStatistics().isEmpty() ? this.getPartialAggregationStatsEstimate() : new PartialAggregationStatsEstimate(planStatistics.getPartialAggregationStatistics().getPartialAggregationInputBytes().getValue(), planStatistics.getPartialAggregationStatistics().getPartialAggregationOutputBytes().getValue(), planStatistics.getPartialAggregationStatistics().getPartialAggregationInputRows().getValue(), planStatistics.getPartialAggregationStatistics().getPartialAggregationOutputRows().getValue()));
        }
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("outputRowCount", this.outputRowCount).add("totalSize", this.totalSize).add("variableStatistics", this.variableStatistics).add("sourceInfo", (Object)this.sourceInfo).add("joinNodeSpecificStatsEstimate", (Object)this.joinNodeStatsEstimate).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlanNodeStatsEstimate that = (PlanNodeStatsEstimate)o;
        return Double.compare(this.outputRowCount, that.outputRowCount) == 0 && Double.compare(this.totalSize, that.totalSize) == 0 && Objects.equals(this.variableStatistics, that.variableStatistics) && Objects.equals(this.sourceInfo, that.sourceInfo) && Objects.equals(this.joinNodeStatsEstimate, that.joinNodeStatsEstimate);
    }

    public int hashCode() {
        return Objects.hash(this.outputRowCount, this.totalSize, this.variableStatistics, this.sourceInfo, this.joinNodeStatsEstimate);
    }

    public PlanStatisticsWithSourceInfo toPlanStatisticsWithSourceInfo(PlanNodeId id) {
        return new PlanStatisticsWithSourceInfo(id, new PlanStatistics(Estimate.estimateFromDouble((double)this.outputRowCount), Estimate.estimateFromDouble((double)this.totalSize), this.sourceInfo.isConfident() ? 1.0 : 0.0, new JoinNodeStatistics(Estimate.estimateFromDouble((double)this.joinNodeStatsEstimate.getNullJoinBuildKeyCount()), Estimate.estimateFromDouble((double)this.joinNodeStatsEstimate.getJoinBuildKeyCount()), Estimate.estimateFromDouble((double)this.joinNodeStatsEstimate.getNullJoinProbeKeyCount()), Estimate.estimateFromDouble((double)this.joinNodeStatsEstimate.getJoinProbeKeyCount())), new TableWriterNodeStatistics(Estimate.estimateFromDouble((double)this.tableWriterNodeStatsEstimate.getTaskCountIfScaledWriter())), PartialAggregationStatistics.empty()), this.sourceInfo);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder buildFrom(PlanNodeStatsEstimate other) {
        return new Builder(other.getOutputRowCount(), Double.NaN, other.isConfident(), other.variableStatistics);
    }

    public static final class Builder {
        private double outputRowCount;
        private double totalSize;
        private boolean confident;
        private PMap<VariableReferenceExpression, VariableStatsEstimate> variableStatistics;
        private PartialAggregationStatsEstimate partialAggregationStatsEstimate;

        public Builder() {
            this(Double.NaN, Double.NaN, false, (PMap<VariableReferenceExpression, VariableStatsEstimate>)HashTreePMap.empty());
        }

        private Builder(double outputRowCount, double totalSize, boolean confident, PMap<VariableReferenceExpression, VariableStatsEstimate> variableStatistics) {
            this.outputRowCount = outputRowCount;
            this.totalSize = totalSize;
            this.confident = confident;
            this.variableStatistics = variableStatistics;
            this.partialAggregationStatsEstimate = PartialAggregationStatsEstimate.unknown();
        }

        public Builder setOutputRowCount(double outputRowCount) {
            this.outputRowCount = outputRowCount;
            return this;
        }

        public Builder setTotalSize(double totalSize) {
            this.totalSize = totalSize;
            return this;
        }

        public Builder setConfident(boolean confident) {
            this.confident = confident;
            return this;
        }

        public Builder setPartialAggregationStatsEstimate(PartialAggregationStatsEstimate partialAggregationStatsEstimate) {
            this.partialAggregationStatsEstimate = partialAggregationStatsEstimate;
            return this;
        }

        public Builder addVariableStatistics(VariableReferenceExpression variable, VariableStatsEstimate statistics) {
            this.variableStatistics = this.variableStatistics.plus((Object)variable, (Object)statistics);
            return this;
        }

        public Builder addVariableStatistics(Map<VariableReferenceExpression, VariableStatsEstimate> variableStatistics) {
            this.variableStatistics = this.variableStatistics.plusAll(variableStatistics);
            return this;
        }

        public Builder removeVariableStatistics(VariableReferenceExpression variable) {
            this.variableStatistics = this.variableStatistics.minus((Object)variable);
            return this;
        }

        public PlanNodeStatsEstimate build() {
            return new PlanNodeStatsEstimate(this.outputRowCount, this.totalSize, this.confident, (Map<VariableReferenceExpression, VariableStatsEstimate>)this.variableStatistics, JoinNodeStatsEstimate.unknown(), TableWriterNodeStatsEstimate.unknown(), this.partialAggregationStatsEstimate);
        }
    }
}

