/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.NamedTypeSignature;
import com.facebook.presto.common.type.RowFieldName;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.UserDefinedType;
import com.facebook.presto.execution.DDLDefinitionTask;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.CreateType;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class CreateTypeTask
implements DDLDefinitionTask<CreateType> {
    private final SqlParser sqlParser;

    @Inject
    public CreateTypeTask(SqlParser sqlParser) {
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
    }

    @Override
    public String getName() {
        return "CREATE TYPE";
    }

    @Override
    public String explain(CreateType statement, List<Expression> parameters) {
        return String.format("CREATE TYPE %s", statement.getTypeName());
    }

    @Override
    public ListenableFuture<?> execute(CreateType statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, Session session, List<Expression> parameters, WarningCollector warningCollector) {
        TypeSignature signature;
        if (statement.getDistinctType().isPresent()) {
            signature = new TypeSignature((String)statement.getDistinctType().get(), new TypeSignatureParameter[0]);
        } else {
            List typeParameters = (List)Streams.zip(statement.getParameterNames().stream(), statement.getParameterTypes().stream(), (name, type) -> TypeSignatureParameter.of((NamedTypeSignature)new NamedTypeSignature(Optional.of(new RowFieldName(name, false)), TypeSignature.parseTypeSignature((String)type)))).collect(ImmutableList.toImmutableList());
            signature = new TypeSignature("row", typeParameters);
        }
        UserDefinedType userDefinedType = new UserDefinedType(QualifiedObjectName.valueOf((String)statement.getTypeName().toString()), signature);
        metadata.getFunctionAndTypeManager().addUserDefinedType(userDefinedType);
        return Futures.immediateFuture(null);
    }
}

