/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.common.analyzer.PreparedQuery;
import com.facebook.presto.common.resourceGroups.QueryType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.QueryTracker;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.memory.VersionedMemoryPoolId;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.analyzer.AnalyzerProvider;
import com.facebook.presto.spi.resourceGroups.ResourceGroupQueryLimits;
import com.facebook.presto.sql.planner.Plan;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public interface QueryExecution
extends QueryTracker.TrackedQuery {
    public QueryState getState();

    public ListenableFuture<QueryState> getStateChange(QueryState var1);

    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> var1);

    public void addOutputInfoListener(Consumer<QueryOutputInfo> var1);

    public Plan getQueryPlan();

    public BasicQueryInfo getBasicQueryInfo();

    public QueryInfo getQueryInfo();

    public String getSlug();

    public int getRetryCount();

    public Duration getTotalCpuTime();

    public DataSize getRawInputDataSize();

    public long getOutputPositions();

    public DataSize getOutputDataSize();

    public int getRunningTaskCount();

    public DataSize getUserMemoryReservation();

    public DataSize getTotalMemoryReservation();

    public VersionedMemoryPoolId getMemoryPool();

    @Override
    public Optional<ResourceGroupQueryLimits> getResourceGroupQueryLimits();

    public void setResourceGroupQueryLimits(ResourceGroupQueryLimits var1);

    public void setMemoryPool(VersionedMemoryPoolId var1);

    public void start();

    public void cancelQuery();

    public void cancelStage(StageId var1);

    public void recordHeartbeat();

    public void addFinalQueryInfoListener(StateMachine.StateChangeListener<QueryInfo> var1);

    public static class QueryOutputInfo {
        private final List<String> columnNames;
        private final List<Type> columnTypes;
        private final Map<URI, TaskId> bufferLocations;
        private final boolean noMoreBufferLocations;

        public QueryOutputInfo(List<String> columnNames, List<Type> columnTypes, Map<URI, TaskId> bufferLocations, boolean noMoreBufferLocations) {
            this.columnNames = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnNames, "columnNames is null"));
            this.columnTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnTypes, "columnTypes is null"));
            this.bufferLocations = ImmutableMap.copyOf(Objects.requireNonNull(bufferLocations, "bufferLocations is null"));
            this.noMoreBufferLocations = noMoreBufferLocations;
        }

        public List<String> getColumnNames() {
            return this.columnNames;
        }

        public List<Type> getColumnTypes() {
            return this.columnTypes;
        }

        public Map<URI, TaskId> getBufferLocations() {
            return this.bufferLocations;
        }

        public boolean isNoMoreBufferLocations() {
            return this.noMoreBufferLocations;
        }
    }

    public static interface QueryExecutionFactory<T extends QueryExecution> {
        public T createQueryExecution(AnalyzerProvider var1, PreparedQuery var2, QueryStateMachine var3, String var4, int var5, WarningCollector var6, Optional<QueryType> var7);
    }
}

