/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.execution.DDLDefinitionTask;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.RenameColumn;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class RenameColumnTask
implements DDLDefinitionTask<RenameColumn> {
    @Override
    public String getName() {
        return "RENAME COLUMN";
    }

    @Override
    public ListenableFuture<?> execute(RenameColumn statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, Session session, List<Expression> parameters, WarningCollector warningCollector) {
        QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getTable());
        Optional tableHandleOptional = metadata.getMetadataResolver(session).getTableHandle(tableName);
        if (!tableHandleOptional.isPresent()) {
            if (!statement.isTableExists()) {
                throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)statement, "Table '%s' does not exist", new Object[]{tableName});
            }
            return Futures.immediateFuture(null);
        }
        Optional optionalMaterializedView = metadata.getMetadataResolver(session).getMaterializedView(tableName);
        if (optionalMaterializedView.isPresent()) {
            if (!statement.isTableExists()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)statement, "'%s' is a materialized view, and rename column is not supported", new Object[]{tableName});
            }
            return Futures.immediateFuture(null);
        }
        TableHandle tableHandle = (TableHandle)tableHandleOptional.get();
        String source = statement.getSource().getValueLowerCase();
        String target = statement.getTarget().getValueLowerCase();
        accessControl.checkCanRenameColumn(session.getRequiredTransactionId(), session.getIdentity(), session.getAccessControlContext(), tableName);
        Map<String, ColumnHandle> columnHandles = metadata.getColumnHandles(session, tableHandle);
        ColumnHandle columnHandle = columnHandles.get(source);
        if (columnHandle == null) {
            if (!statement.isColumnExists()) {
                throw new SemanticException(SemanticErrorCode.MISSING_COLUMN, (Node)statement, "Column '%s' does not exist", new Object[]{source});
            }
            return Futures.immediateFuture(null);
        }
        if (columnHandles.containsKey(target)) {
            throw new SemanticException(SemanticErrorCode.COLUMN_ALREADY_EXISTS, (Node)statement, "Column '%s' already exists", new Object[]{target});
        }
        if (metadata.getColumnMetadata(session, tableHandle, columnHandle).isHidden()) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)statement, "Cannot rename hidden column", new Object[0]);
        }
        metadata.renameColumn(session, tableHandle, columnHandle, target);
        return Futures.immediateFuture(null);
    }
}

