/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.operator.scalar.annotations.CodegenScalarFromAnnotationsParser;
import com.facebook.presto.operator.scalar.annotations.ScalarFromAnnotationsParser;
import com.facebook.presto.operator.scalar.annotations.SqlInvokedScalarFromAnnotationsParser;
import com.facebook.presto.operator.window.WindowAnnotationsParser;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlFunction;
import com.facebook.presto.spi.function.SqlInvokedScalarFunction;
import com.facebook.presto.spi.function.WindowFunction;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

public final class FunctionExtractor {
    private FunctionExtractor() {
    }

    public static List<SqlFunction> extractFunctions(Collection<Class<?>> classes) {
        return (List)classes.stream().map(FunctionExtractor::extractFunctions).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
    }

    public static List<? extends SqlFunction> extractFunctions(Class<?> clazz) {
        if (WindowFunction.class.isAssignableFrom(clazz)) {
            Class<?> windowClazz = clazz;
            return WindowAnnotationsParser.parseFunctionDefinition(windowClazz);
        }
        if (clazz.isAnnotationPresent(AggregationFunction.class)) {
            return SqlAggregationFunction.createFunctionsByAnnotations(clazz);
        }
        if (clazz.isAnnotationPresent(ScalarFunction.class) || clazz.isAnnotationPresent(ScalarOperator.class)) {
            return ScalarFromAnnotationsParser.parseFunctionDefinition(clazz);
        }
        if (clazz.isAnnotationPresent(SqlInvokedScalarFunction.class)) {
            return SqlInvokedScalarFromAnnotationsParser.parseFunctionDefinition(clazz);
        }
        ImmutableList scalarFunctions = ImmutableList.builder().addAll(ScalarFromAnnotationsParser.parseFunctionDefinitions(clazz)).addAll(SqlInvokedScalarFromAnnotationsParser.parseFunctionDefinitions(clazz)).addAll(CodegenScalarFromAnnotationsParser.parseFunctionDefinitions(clazz)).build();
        Preconditions.checkArgument((!scalarFunctions.isEmpty() ? 1 : 0) != 0, (String)"Class [%s] does not define any scalar functions", (Object)clazz.getName());
        return scalarFunctions;
    }
}

