/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.RuntimeUnit;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskMetadataContext;
import com.facebook.presto.execution.scheduler.ExecutionWriterTarget;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.metadata.ConnectorMetadataUpdaterManager;
import com.facebook.presto.operator.DevNullOperator;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.OperationTimer;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.OperatorInfo;
import com.facebook.presto.operator.PageSinkCommitStrategy;
import com.facebook.presto.operator.TableCommitContext;
import com.facebook.presto.operator.TableWriterUtils;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PageSinkContext;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.connector.ConnectorMetadataUpdater;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.split.PageSinkManager;
import com.facebook.presto.util.AutoCloseableCloser;
import com.facebook.presto.util.Mergeable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public class TableWriterOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final LocalMemoryContext pageSinkMemoryContext;
    private final ConnectorPageSink pageSink;
    private final List<Integer> columnChannels;
    private final List<String> notNullChannelColumnNames;
    private final AtomicLong pageSinkPeakMemoryUsage = new AtomicLong();
    private final Operator statisticAggregationOperator;
    private final List<Type> types;
    private ListenableFuture<?> blocked = NOT_BLOCKED;
    private CompletableFuture<Collection<Slice>> finishFuture;
    private State state = State.RUNNING;
    private long rowCount;
    private boolean committed;
    private boolean closed;
    private long writtenBytes;
    private final OperationTimer.OperationTiming statisticsTiming = new OperationTimer.OperationTiming();
    private final boolean statisticsCpuTimerEnabled;
    private final JsonCodec<TableCommitContext> tableCommitContextCodec;
    private final PageSinkCommitStrategy pageSinkCommitStrategy;
    private final Supplier<TableWriterInfo> tableWriterInfoSupplier;

    public TableWriterOperator(OperatorContext operatorContext, ConnectorPageSink pageSink, List<Integer> columnChannels, List<String> notNullChannelColumnNames, Operator statisticAggregationOperator, List<Type> types, boolean statisticsCpuTimerEnabled, JsonCodec<TableCommitContext> tableCommitContextCodec, PageSinkCommitStrategy pageSinkCommitStrategy) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.pageSinkMemoryContext = operatorContext.localSystemMemoryContext();
        this.pageSink = Objects.requireNonNull(pageSink, "pageSink is null");
        this.columnChannels = Objects.requireNonNull(columnChannels, "columnChannels is null");
        this.notNullChannelColumnNames = Objects.requireNonNull(notNullChannelColumnNames, "notNullChannelColumnNames is null");
        Preconditions.checkArgument((columnChannels.size() == notNullChannelColumnNames.size() ? 1 : 0) != 0, (Object)"columnChannels and notNullColumnNames have different sizes");
        this.statisticAggregationOperator = Objects.requireNonNull(statisticAggregationOperator, "statisticAggregationOperator is null");
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.statisticsCpuTimerEnabled = statisticsCpuTimerEnabled;
        this.tableCommitContextCodec = Objects.requireNonNull(tableCommitContextCodec, "tableCommitContextCodec is null");
        this.pageSinkCommitStrategy = Objects.requireNonNull(pageSinkCommitStrategy, "pageSinkCommitStrategy is null");
        this.tableWriterInfoSupplier = TableWriterOperator.createTableWriterInfoSupplier(this.pageSinkPeakMemoryUsage, this.statisticsTiming, pageSink);
        this.operatorContext.setInfoSupplier(this.tableWriterInfoSupplier);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        ListenableFuture<?> currentlyBlocked = this.blocked;
        OperationTimer timer = new OperationTimer(this.statisticsCpuTimerEnabled);
        this.statisticAggregationOperator.finish();
        timer.end(this.statisticsTiming);
        ListenableFuture<?> blockedOnAggregation = this.statisticAggregationOperator.isBlocked();
        ListenableFuture blockedOnFinish = NOT_BLOCKED;
        if (this.state == State.RUNNING) {
            this.state = State.FINISHING;
            this.finishFuture = this.pageSink.finish();
            blockedOnFinish = MoreFutures.toListenableFuture(this.finishFuture);
            this.updateWrittenBytes();
        }
        this.blocked = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{currentlyBlocked, blockedOnAggregation, blockedOnFinish});
    }

    @Override
    public boolean isFinished() {
        return this.state == State.FINISHED && this.blocked.isDone();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.blocked;
    }

    @Override
    public boolean needsInput() {
        if (this.state != State.RUNNING || !this.blocked.isDone()) {
            return false;
        }
        return this.statisticAggregationOperator.needsInput();
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((boolean)this.needsInput(), (Object)"Operator does not need input");
        Block[] blocks = new Block[this.columnChannels.size()];
        for (int outputChannel = 0; outputChannel < this.columnChannels.size(); ++outputChannel) {
            Block block = page.getBlock(this.columnChannels.get(outputChannel).intValue());
            String columnName = this.notNullChannelColumnNames.get(outputChannel);
            if (columnName != null) {
                this.verifyBlockHasNoNulls(block, columnName);
            }
            blocks[outputChannel] = block;
        }
        OperationTimer timer = new OperationTimer(this.statisticsCpuTimerEnabled);
        this.statisticAggregationOperator.addInput(page);
        timer.end(this.statisticsTiming);
        ListenableFuture<?> blockedOnAggregation = this.statisticAggregationOperator.isBlocked();
        CompletableFuture future = this.pageSink.appendPage(new Page(blocks));
        this.updateMemoryUsage();
        ListenableFuture blockedOnWrite = MoreFutures.toListenableFuture((CompletableFuture)future);
        this.blocked = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{blockedOnAggregation, blockedOnWrite});
        this.rowCount += (long)page.getPositionCount();
        this.updateWrittenBytes();
    }

    private void verifyBlockHasNoNulls(Block block, String columnName) {
        if (!block.mayHaveNull()) {
            return;
        }
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (!block.isNull(position)) continue;
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.CONSTRAINT_VIOLATION, "NULL value not allowed for NOT NULL column: " + columnName);
        }
    }

    @Override
    public Page getOutput() {
        if (!this.blocked.isDone()) {
            return null;
        }
        if (!this.statisticAggregationOperator.isFinished()) {
            OperationTimer timer = new OperationTimer(this.statisticsCpuTimerEnabled);
            Page aggregationOutput = this.statisticAggregationOperator.getOutput();
            timer.end(this.statisticsTiming);
            if (aggregationOutput == null) {
                return null;
            }
            return TableWriterUtils.createStatisticsPage(this.types, aggregationOutput, this.createTableCommitContext(false));
        }
        if (this.state != State.FINISHING) {
            return null;
        }
        Page fragmentsPage = this.createFragmentsPage();
        int positionCount = fragmentsPage.getPositionCount();
        Block[] outputBlocks = new Block[this.types.size()];
        for (int channel = 0; channel < this.types.size(); ++channel) {
            outputBlocks[channel] = channel < 3 ? fragmentsPage.getBlock(channel) : RunLengthEncodedBlock.create((Type)this.types.get(channel), null, (int)positionCount);
        }
        this.updateWrittenFilesCount();
        this.state = State.FINISHED;
        return new Page(positionCount, outputBlocks);
    }

    private Page createFragmentsPage() {
        Collection fragments = (Collection)MoreFutures.getFutureValue(this.finishFuture);
        int positionCount = fragments.size() + 1;
        this.committed = true;
        this.updateWrittenBytes();
        BlockBuilder rowsBuilder = BigintType.BIGINT.createBlockBuilder(null, positionCount);
        BlockBuilder fragmentBuilder = VarbinaryType.VARBINARY.createBlockBuilder(null, positionCount);
        BigintType.BIGINT.writeLong(rowsBuilder, this.rowCount);
        fragmentBuilder.appendNull();
        for (Slice fragment : fragments) {
            rowsBuilder.appendNull();
            VarbinaryType.VARBINARY.writeSlice(fragmentBuilder, fragment);
        }
        return new Page(positionCount, new Block[]{rowsBuilder.build(), fragmentBuilder.build(), RunLengthEncodedBlock.create((Type)VarbinaryType.VARBINARY, (Object)this.createTableCommitContext(true), (int)positionCount)});
    }

    private Slice createTableCommitContext(boolean lastPage) {
        TaskId taskId = this.operatorContext.getDriverContext().getPipelineContext().getTaskId();
        return Slices.wrappedBuffer((byte[])this.tableCommitContextCodec.toJsonBytes((Object)new TableCommitContext(this.operatorContext.getDriverContext().getLifespan(), taskId, this.pageSinkCommitStrategy, lastPage)));
    }

    @Override
    public void close() throws Exception {
        AutoCloseableCloser closer = AutoCloseableCloser.create();
        if (!this.closed) {
            this.closed = true;
            if (!this.committed) {
                closer.register(() -> ((ConnectorPageSink)this.pageSink).abort());
            }
        }
        closer.register(this.statisticAggregationOperator);
        closer.register(() -> this.pageSinkMemoryContext.setBytes(0L));
        closer.close();
    }

    private void updateWrittenBytes() {
        long current = this.pageSink.getCompletedBytes();
        this.operatorContext.recordPhysicalWrittenData(current - this.writtenBytes);
        this.writtenBytes = current;
    }

    private void updateWrittenFilesCount() {
        this.operatorContext.getRuntimeStats().addMetricValue("writtenFilesCount", RuntimeUnit.NONE, this.pageSink.getWrittenFilesCount());
    }

    private void updateMemoryUsage() {
        long pageSinkMemoryUsage = this.pageSink.getSystemMemoryUsage();
        this.pageSinkMemoryContext.setBytes(pageSinkMemoryUsage);
        this.pageSinkPeakMemoryUsage.accumulateAndGet(pageSinkMemoryUsage, Math::max);
    }

    @VisibleForTesting
    Operator getStatisticAggregationOperator() {
        return this.statisticAggregationOperator;
    }

    @VisibleForTesting
    TableWriterInfo getInfo() {
        return this.tableWriterInfoSupplier.get();
    }

    private static Supplier<TableWriterInfo> createTableWriterInfoSupplier(AtomicLong pageSinkPeakMemoryUsage, OperationTimer.OperationTiming statisticsTiming, ConnectorPageSink pageSink) {
        Objects.requireNonNull(pageSinkPeakMemoryUsage, "pageSinkPeakMemoryUsage is null");
        Objects.requireNonNull(statisticsTiming, "statisticsTiming is null");
        Objects.requireNonNull(pageSink, "pageSink is null");
        return () -> new TableWriterInfo(pageSinkPeakMemoryUsage.get(), Duration.succinctNanos((long)statisticsTiming.getWallNanos()), Duration.succinctNanos((long)statisticsTiming.getCpuNanos()), Duration.succinctNanos((long)pageSink.getValidationCpuNanos()));
    }

    @ThriftStruct
    public static class TableWriterInfo
    implements Mergeable<TableWriterInfo>,
    OperatorInfo {
        private final long pageSinkPeakMemoryUsage;
        private final Duration statisticsWallTime;
        private final Duration statisticsCpuTime;
        private final Duration validationCpuTime;

        @JsonCreator
        @ThriftConstructor
        public TableWriterInfo(@JsonProperty(value="pageSinkPeakMemoryUsage") long pageSinkPeakMemoryUsage, @JsonProperty(value="statisticsWallTime") Duration statisticsWallTime, @JsonProperty(value="statisticsCpuTime") Duration statisticsCpuTime, @JsonProperty(value="validationCpuTime") Duration validationCpuTime) {
            this.pageSinkPeakMemoryUsage = pageSinkPeakMemoryUsage;
            this.statisticsWallTime = Objects.requireNonNull(statisticsWallTime, "statisticsWallTime is null");
            this.statisticsCpuTime = Objects.requireNonNull(statisticsCpuTime, "statisticsCpuTime is null");
            this.validationCpuTime = Objects.requireNonNull(validationCpuTime, "validationCpuTime is null");
        }

        @JsonProperty
        @ThriftField(value=1)
        public long getPageSinkPeakMemoryUsage() {
            return this.pageSinkPeakMemoryUsage;
        }

        @JsonProperty
        @ThriftField(value=2)
        public Duration getStatisticsWallTime() {
            return this.statisticsWallTime;
        }

        @JsonProperty
        @ThriftField(value=3)
        public Duration getStatisticsCpuTime() {
            return this.statisticsCpuTime;
        }

        @JsonProperty
        @ThriftField(value=4)
        public Duration getValidationCpuTime() {
            return this.validationCpuTime;
        }

        @Override
        public TableWriterInfo mergeWith(TableWriterInfo other) {
            return new TableWriterInfo(Math.max(this.pageSinkPeakMemoryUsage, other.pageSinkPeakMemoryUsage), Duration.succinctNanos((long)(this.statisticsWallTime.roundTo(TimeUnit.NANOSECONDS) + other.statisticsWallTime.roundTo(TimeUnit.NANOSECONDS))), Duration.succinctNanos((long)(this.statisticsCpuTime.roundTo(TimeUnit.NANOSECONDS) + other.statisticsCpuTime.roundTo(TimeUnit.NANOSECONDS))), Duration.succinctNanos((long)(this.validationCpuTime.roundTo(TimeUnit.NANOSECONDS) + other.validationCpuTime.roundTo(TimeUnit.NANOSECONDS))));
        }

        @Override
        public boolean isFinal() {
            return true;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("pageSinkPeakMemoryUsage", this.pageSinkPeakMemoryUsage).add("statisticsWallTime", (Object)this.statisticsWallTime).add("statisticsCpuTime", (Object)this.statisticsCpuTime).add("validationCpuTime", (Object)this.validationCpuTime).toString();
        }
    }

    private static enum State {
        RUNNING,
        FINISHING,
        FINISHED;

    }

    public static class TableWriterOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final PageSinkManager pageSinkManager;
        private final ConnectorMetadataUpdaterManager metadataUpdaterManager;
        private final TaskMetadataContext taskMetadataContext;
        private final ExecutionWriterTarget target;
        private final List<Integer> columnChannels;
        private final List<String> notNullChannelColumnNames;
        private final Session session;
        private final OperatorFactory statisticsAggregationOperatorFactory;
        private final List<Type> types;
        private final PageSinkCommitStrategy pageSinkCommitStrategy;
        private boolean closed;
        private final JsonCodec<TableCommitContext> tableCommitContextCodec;

        public TableWriterOperatorFactory(int operatorId, PlanNodeId planNodeId, PageSinkManager pageSinkManager, ConnectorMetadataUpdaterManager metadataUpdaterManager, TaskMetadataContext taskMetadataContext, ExecutionWriterTarget writerTarget, List<Integer> columnChannels, List<String> notNullChannelColumnNames, Session session, OperatorFactory statisticsAggregationOperatorFactory, List<Type> types, JsonCodec<TableCommitContext> tableCommitContextCodec, PageSinkCommitStrategy pageSinkCommitStrategy) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.columnChannels = Objects.requireNonNull(columnChannels, "columnChannels is null");
            this.notNullChannelColumnNames = Objects.requireNonNull(notNullChannelColumnNames, "notNullChannelColumnNames is null");
            this.pageSinkManager = Objects.requireNonNull(pageSinkManager, "pageSinkManager is null");
            this.metadataUpdaterManager = Objects.requireNonNull(metadataUpdaterManager, "metadataUpdaterManager is null");
            this.taskMetadataContext = Objects.requireNonNull(taskMetadataContext, "taskMetadataContext is null");
            Preconditions.checkArgument((writerTarget instanceof ExecutionWriterTarget.CreateHandle || writerTarget instanceof ExecutionWriterTarget.InsertHandle || writerTarget instanceof ExecutionWriterTarget.RefreshMaterializedViewHandle ? 1 : 0) != 0, (Object)"writerTarget must be CreateHandle or InsertHandle or RefreshMaterializedViewHandle");
            this.target = Objects.requireNonNull(writerTarget, "writerTarget is null");
            this.session = session;
            this.statisticsAggregationOperatorFactory = Objects.requireNonNull(statisticsAggregationOperatorFactory, "statisticsAggregationOperatorFactory is null");
            this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
            this.tableCommitContextCodec = Objects.requireNonNull(tableCommitContextCodec, "tableCommitContextCodec is null");
            this.pageSinkCommitStrategy = Objects.requireNonNull(pageSinkCommitStrategy, "pageSinkCommitStrategy is null");
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext context = driverContext.addOperatorContext(this.operatorId, this.planNodeId, TableWriterOperator.class.getSimpleName());
            Operator statisticsAggregationOperator = this.statisticsAggregationOperatorFactory.createOperator(driverContext);
            boolean statisticsCpuTimerEnabled = !(statisticsAggregationOperator instanceof DevNullOperator) && SystemSessionProperties.isStatisticsCpuTimerEnabled(this.session);
            return new TableWriterOperator(context, this.createPageSink(), this.columnChannels, this.notNullChannelColumnNames, statisticsAggregationOperator, this.types, statisticsCpuTimerEnabled, this.tableCommitContextCodec, this.pageSinkCommitStrategy);
        }

        private ConnectorPageSink createPageSink() {
            ConnectorId connectorId = TableWriterOperatorFactory.getConnectorId(this.target);
            Optional<ConnectorMetadataUpdater> metadataUpdater = this.metadataUpdaterManager.getMetadataUpdater(connectorId);
            if (metadataUpdater.isPresent()) {
                this.taskMetadataContext.setConnectorId(connectorId);
                this.taskMetadataContext.addMetadataUpdater(metadataUpdater.get());
            }
            PageSinkContext.Builder pageSinkContextBuilder = PageSinkContext.builder().setCommitRequired(this.pageSinkCommitStrategy.isCommitRequired());
            metadataUpdater.ifPresent(arg_0 -> ((PageSinkContext.Builder)pageSinkContextBuilder).setConnectorMetadataUpdater(arg_0));
            if (this.target instanceof ExecutionWriterTarget.CreateHandle) {
                return this.pageSinkManager.createPageSink(this.session, ((ExecutionWriterTarget.CreateHandle)this.target).getHandle(), pageSinkContextBuilder.build());
            }
            if (this.target instanceof ExecutionWriterTarget.InsertHandle) {
                return this.pageSinkManager.createPageSink(this.session, ((ExecutionWriterTarget.InsertHandle)this.target).getHandle(), pageSinkContextBuilder.build());
            }
            if (this.target instanceof ExecutionWriterTarget.RefreshMaterializedViewHandle) {
                return this.pageSinkManager.createPageSink(this.session, ((ExecutionWriterTarget.RefreshMaterializedViewHandle)this.target).getHandle(), pageSinkContextBuilder.build());
            }
            throw new UnsupportedOperationException("Unhandled target type: " + this.target.getClass().getName());
        }

        private static ConnectorId getConnectorId(ExecutionWriterTarget handle) {
            if (handle instanceof ExecutionWriterTarget.CreateHandle) {
                return ((ExecutionWriterTarget.CreateHandle)handle).getHandle().getConnectorId();
            }
            if (handle instanceof ExecutionWriterTarget.InsertHandle) {
                return ((ExecutionWriterTarget.InsertHandle)handle).getHandle().getConnectorId();
            }
            if (handle instanceof ExecutionWriterTarget.RefreshMaterializedViewHandle) {
                return ((ExecutionWriterTarget.RefreshMaterializedViewHandle)handle).getHandle().getConnectorId();
            }
            throw new UnsupportedOperationException("Unhandled target type: " + handle.getClass().getName());
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new TableWriterOperatorFactory(this.operatorId, this.planNodeId, this.pageSinkManager, this.metadataUpdaterManager, this.taskMetadataContext, this.target, this.columnChannels, this.notNullChannelColumnNames, this.session, this.statisticsAggregationOperatorFactory, this.types, this.tableCommitContextCodec, this.pageSinkCommitStrategy);
        }
    }
}

