/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.common.Page;
import com.facebook.presto.operator.AbstractRowChangeOperator;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.TableCommitContext;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class UpdateOperator
extends AbstractRowChangeOperator {
    private final List<Integer> columnValueAndRowIdChannels;

    public UpdateOperator(OperatorContext operatorContext, List<Integer> columnValueAndRowIdChannels, JsonCodec<TableCommitContext> tableCommitContextCodec) {
        super(operatorContext, tableCommitContextCodec);
        this.columnValueAndRowIdChannels = columnValueAndRowIdChannels;
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((this.state == AbstractRowChangeOperator.State.RUNNING ? 1 : 0) != 0, (String)"Operator is %s", (Object)((Object)this.state));
        this.pageSource().updateRows(page, this.columnValueAndRowIdChannels);
        this.rowCount += (long)page.getPositionCount();
    }

    public static class UpdateOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final List<Integer> columnValueAndRowIdChannels;
        private boolean closed;
        private final JsonCodec<TableCommitContext> tableCommitContextCodec;

        public UpdateOperatorFactory(int operatorId, PlanNodeId planNodeId, List<Integer> columnValueAndRowIdChannels, JsonCodec<TableCommitContext> tableCommitContextCodec) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.columnValueAndRowIdChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnValueAndRowIdChannels, "columnValueAndRowIdChannels is null"));
            this.tableCommitContextCodec = Objects.requireNonNull(tableCommitContextCodec, "tableCommitContextCodec is null");
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext context = driverContext.addOperatorContext(this.operatorId, this.planNodeId, UpdateOperator.class.getSimpleName());
            return new UpdateOperator(context, this.columnValueAndRowIdChannels, this.tableCommitContextCodec);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new UpdateOperatorFactory(this.operatorId, this.planNodeId, this.columnValueAndRowIdChannels, this.tableCommitContextCodec);
        }
    }
}

