/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.BuiltInFunction;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.operator.aggregation.BuiltInAggregationFunctionImplementation;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public final class AlternativeApproxPercentile {
    private AlternativeApproxPercentile() {
    }

    public static BuiltInFunction[] getFunctions() {
        ArrayList<Function> functions = new ArrayList<Function>();
        boolean[] ft = new boolean[]{false, true};
        for (Type type : new Type[]{BigintType.BIGINT, RealType.REAL, DoubleType.DOUBLE}) {
            for (boolean percentileArray : ft) {
                for (boolean weighted : ft) {
                    for (boolean accuracy : ft) {
                        functions.add(new Function(type, percentileArray, weighted, accuracy));
                    }
                }
            }
        }
        return functions.toArray(new BuiltInFunction[0]);
    }

    private static Type createReturnType(Type valueType, boolean percentileArray) {
        return percentileArray ? new ArrayType(valueType) : valueType;
    }

    private static List<Type> createArgumentTypes(Type valueType, boolean percentileArray, boolean weighted, boolean accuracy) {
        ArrayList<Type> arguments = new ArrayList<Type>();
        arguments.add(valueType);
        if (weighted) {
            arguments.add((Type)BigintType.BIGINT);
        }
        if (percentileArray) {
            arguments.add((Type)new ArrayType((Type)DoubleType.DOUBLE));
        } else {
            arguments.add((Type)DoubleType.DOUBLE);
        }
        if (accuracy) {
            arguments.add((Type)DoubleType.DOUBLE);
        }
        return arguments;
    }

    private static class Function
    extends SqlAggregationFunction {
        private static final String NAME = "approx_percentile";
        private final Type valueType;
        private final List<Type> inputTypes;
        private final Type outputType;

        Function(Type valueType, boolean percentileArray, boolean weighted, boolean accuracy) {
            super(NAME, Collections.emptyList(), Collections.emptyList(), AlternativeApproxPercentile.createReturnType(valueType, percentileArray).getTypeSignature(), (List)AlternativeApproxPercentile.createArgumentTypes(valueType, percentileArray, weighted, accuracy).stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList()));
            this.valueType = valueType;
            this.inputTypes = AlternativeApproxPercentile.createArgumentTypes(valueType, percentileArray, weighted, accuracy);
            this.outputType = AlternativeApproxPercentile.createReturnType(valueType, percentileArray);
        }

        public String getDescription() {
            return "";
        }

        @Override
        public BuiltInAggregationFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
            RowType intermediateType = RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("percentiles"), (Type)new ArrayType((Type)DoubleType.DOUBLE)), (Object)new RowType.Field(Optional.of("percentileArray"), (Type)BooleanType.BOOLEAN), (Object)new RowType.Field(Optional.of("accuracy"), (Type)DoubleType.DOUBLE), (Object)new RowType.Field(Optional.of("k"), (Type)IntegerType.INTEGER), (Object)new RowType.Field(Optional.of("n"), (Type)BigintType.BIGINT), (Object)new RowType.Field(Optional.of("minValue"), this.valueType), (Object)new RowType.Field(Optional.of("maxValue"), this.valueType), (Object)new RowType.Field(Optional.of("items"), (Type)new ArrayType(this.valueType)), (Object)new RowType.Field(Optional.of("levels"), (Type)new ArrayType((Type)IntegerType.INTEGER))));
            return new BuiltInAggregationFunctionImplementation(NAME, this.inputTypes, (List<Type>)ImmutableList.of((Object)intermediateType), this.outputType, true, false, null, null, null);
        }
    }
}

