/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.noisyaggregation;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.operator.aggregation.noisyaggregation.SfmSketchAggregationUtils;
import com.facebook.presto.operator.aggregation.noisyaggregation.SfmSketchState;
import com.facebook.presto.operator.aggregation.noisyaggregation.sketch.SfmSketch;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import io.airlift.slice.Slice;

@AggregationFunction(value="merge")
public final class SfmSketchMergeAggregation {
    private SfmSketchMergeAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState SfmSketchState state, @SqlType(value="SfmSketch") Slice value) {
        SfmSketch sketch = SfmSketch.deserialize(value);
        SfmSketch previous = state.getSketch();
        if (previous == null) {
            state.setSketch(sketch);
            state.setEpsilon(0.0);
        } else {
            try {
                state.mergeSketch(sketch);
            }
            catch (IllegalArgumentException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, e.getMessage(), (Throwable)e);
            }
        }
    }

    @CombineFunction
    public static void combine(@AggregationState SfmSketchState state, @AggregationState SfmSketchState otherState) {
        SfmSketchAggregationUtils.mergeStates(state, otherState);
    }

    @OutputFunction(value="SfmSketch")
    public static void output(@AggregationState SfmSketchState state, BlockBuilder out) {
        VarbinaryType.VARBINARY.writeSlice(out, state.getSketch().serialize());
    }
}

