/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.exchange;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class LocalExchangeMemoryManager {
    private static final ListenableFuture<?> NOT_BLOCKED = Futures.immediateFuture(null);
    private final long maxBufferedBytes;
    private final AtomicLong bufferedBytes = new AtomicLong();
    @Nullable
    @GuardedBy(value="this")
    private SettableFuture<?> notFullFuture;

    public LocalExchangeMemoryManager(long maxBufferedBytes) {
        Preconditions.checkArgument((maxBufferedBytes > 0L ? 1 : 0) != 0, (Object)"maxBufferedBytes must be > 0");
        this.maxBufferedBytes = maxBufferedBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMemoryUsage(long bytesAdded) {
        long bufferedBytes = this.bufferedBytes.addAndGet(bytesAdded);
        if (bufferedBytes <= this.maxBufferedBytes && bufferedBytes - bytesAdded > this.maxBufferedBytes) {
            SettableFuture<?> future;
            LocalExchangeMemoryManager localExchangeMemoryManager = this;
            synchronized (localExchangeMemoryManager) {
                if (this.notFullFuture == null) {
                    return;
                }
                future = this.notFullFuture;
                this.notFullFuture = null;
            }
            future.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<?> getNotFullFuture() {
        if (this.bufferedBytes.get() <= this.maxBufferedBytes) {
            return NOT_BLOCKED;
        }
        LocalExchangeMemoryManager localExchangeMemoryManager = this;
        synchronized (localExchangeMemoryManager) {
            if (this.bufferedBytes.get() <= this.maxBufferedBytes) {
                return NOT_BLOCKED;
            }
            if (this.notFullFuture == null) {
                this.notFullFuture = SettableFuture.create();
            }
            return this.notFullFuture;
        }
    }

    public long getBufferedBytes() {
        return this.bufferedBytes.get();
    }
}

