/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.exchange;

import com.facebook.presto.common.Page;
import com.facebook.presto.operator.WorkProcessor;
import com.facebook.presto.operator.exchange.LocalExchangeBufferInfo;
import com.facebook.presto.operator.exchange.PageReference;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class LocalExchangeSource {
    private static final ListenableFuture<?> NOT_BLOCKED = Futures.immediateFuture(null);
    private final Consumer<LocalExchangeSource> onFinish;
    private final BlockingQueue<PageReference> buffer = new LinkedBlockingDeque<PageReference>();
    private final AtomicLong bufferedBytes = new AtomicLong();
    @Nullable
    @GuardedBy(value="this")
    private SettableFuture<?> notEmptyFuture;
    private volatile boolean finishing;

    public LocalExchangeSource(Consumer<LocalExchangeSource> onFinish) {
        this.onFinish = Objects.requireNonNull(onFinish, "onFinish is null");
    }

    public LocalExchangeBufferInfo getBufferInfo() {
        return new LocalExchangeBufferInfo(this.bufferedBytes.get(), this.buffer.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPage(PageReference pageReference) {
        this.checkNotHoldsLock();
        boolean added = false;
        SettableFuture<?> notEmptyFuture = null;
        long retainedSizeInBytes = pageReference.getRetainedSizeInBytes();
        LocalExchangeSource localExchangeSource = this;
        synchronized (localExchangeSource) {
            if (!this.finishing) {
                this.bufferedBytes.addAndGet(retainedSizeInBytes);
                this.buffer.add(pageReference);
                added = true;
            }
            if (this.notEmptyFuture != null) {
                notEmptyFuture = this.notEmptyFuture;
                this.notEmptyFuture = null;
            }
        }
        if (!added) {
            pageReference.removePage();
        }
        if (notEmptyFuture != null) {
            notEmptyFuture.set(null);
        }
    }

    public WorkProcessor<Page> pages() {
        return WorkProcessor.create(() -> {
            Page page = this.removePage();
            if (page == null) {
                if (this.isFinished()) {
                    return WorkProcessor.ProcessState.finished();
                }
                ListenableFuture<?> blocked = this.waitForReading();
                if (!blocked.isDone()) {
                    return WorkProcessor.ProcessState.blocked(blocked);
                }
                return WorkProcessor.ProcessState.yield();
            }
            return WorkProcessor.ProcessState.ofResult(page);
        });
    }

    public Page removePage() {
        this.checkNotHoldsLock();
        PageReference pageReference = (PageReference)this.buffer.poll();
        if (pageReference == null) {
            return null;
        }
        Page page = pageReference.removePage();
        this.bufferedBytes.addAndGet(-page.getRetainedSizeInBytes());
        this.checkFinished();
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<?> waitForReading() {
        this.checkNotHoldsLock();
        if (this.finishing || !this.buffer.isEmpty()) {
            return NOT_BLOCKED;
        }
        LocalExchangeSource localExchangeSource = this;
        synchronized (localExchangeSource) {
            if (this.finishing || !this.buffer.isEmpty()) {
                return NOT_BLOCKED;
            }
            if (this.notEmptyFuture == null) {
                this.notEmptyFuture = SettableFuture.create();
            }
            return this.notEmptyFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFinished() {
        if (!this.finishing) {
            return false;
        }
        LocalExchangeSource localExchangeSource = this;
        synchronized (localExchangeSource) {
            return this.finishing && this.buffer.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        SettableFuture<?> notEmptyFuture;
        this.checkNotHoldsLock();
        LocalExchangeSource localExchangeSource = this;
        synchronized (localExchangeSource) {
            if (this.finishing) {
                return;
            }
            this.finishing = true;
            notEmptyFuture = this.notEmptyFuture;
            this.notEmptyFuture = null;
        }
        if (notEmptyFuture != null) {
            notEmptyFuture.set(null);
        }
        this.checkFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        SettableFuture<?> notEmptyFuture;
        this.checkNotHoldsLock();
        ArrayList remainingPages = new ArrayList();
        LocalExchangeSource localExchangeSource = this;
        synchronized (localExchangeSource) {
            this.finishing = true;
            this.buffer.drainTo(remainingPages);
            this.bufferedBytes.addAndGet(-remainingPages.stream().mapToLong(PageReference::getRetainedSizeInBytes).sum());
            notEmptyFuture = this.notEmptyFuture;
            this.notEmptyFuture = null;
        }
        remainingPages.forEach(PageReference::removePage);
        if (notEmptyFuture != null) {
            notEmptyFuture.set(null);
        }
        Preconditions.checkState((boolean)this.isFinished(), (Object)"Expected buffer to be finished");
        this.checkFinished();
    }

    private void checkFinished() {
        this.checkNotHoldsLock();
        if (this.isFinished()) {
            this.onFinish.accept(this);
        }
    }

    private void checkNotHoldsLock() {
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Can not execute this method while holding the lock");
    }
}

