/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.OperatorDependency;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.util.Failures;
import java.lang.invoke.MethodHandle;

@Description(value="Get the cumulative sum array for the input array")
@ScalarFunction(value="array_cum_sum", deterministic=true)
public final class ArrayCumSum {
    private ArrayCumSum() {
    }

    @TypeParameter(value="T")
    @SqlType(value="array(T)")
    public static Block sum(@OperatorDependency(operator=OperatorType.ADD, argumentTypes={"T", "T"}) MethodHandle addFunction, @TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock) {
        int positionCount = arrayBlock.getPositionCount();
        BlockBuilder resultBuilder = elementType.createBlockBuilder(null, positionCount);
        if (positionCount == 0) {
            return resultBuilder.build();
        }
        if (arrayBlock.isNull(0)) {
            return RunLengthEncodedBlock.create((Type)elementType, null, (int)positionCount);
        }
        elementType.appendTo(arrayBlock, 0, resultBuilder);
        if (arrayBlock.mayHaveNull()) {
            int pos;
            for (pos = 1; pos < positionCount && !arrayBlock.isNull(pos); ++pos) {
                ArrayCumSum.writeSum(elementType, resultBuilder, addFunction, pos, arrayBlock);
            }
            while (pos < positionCount) {
                resultBuilder.appendNull();
                ++pos;
            }
        } else {
            for (int pos = 1; pos < positionCount; ++pos) {
                ArrayCumSum.writeSum(elementType, resultBuilder, addFunction, pos, arrayBlock);
            }
        }
        return resultBuilder.build();
    }

    private static void writeSum(Type elementType, BlockBuilder resultBuilder, MethodHandle addFunction, int pos, Block arrayBlock) {
        try {
            TypeUtils.writeNativeValue((Type)elementType, (BlockBuilder)resultBuilder, (Object)addFunction.invoke(TypeUtils.readNativeValue((Type)elementType, (Block)resultBuilder, (int)(pos - 1)), TypeUtils.readNativeValue((Type)elementType, (Block)arrayBlock, (int)pos)));
        }
        catch (Throwable throwable) {
            throw Failures.internalError(throwable);
        }
    }
}

