/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.scalar.JsonPathTokenizer;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.util.JsonUtil;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.SerializedString;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.Objects;

public final class JsonExtract {
    private static final int ESTIMATED_JSON_OUTPUT_SIZE = 512;
    private static final JsonFactory JSON_FACTORY = new JsonFactory().disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);

    private JsonExtract() {
    }

    public static <T> T extract(Slice jsonInput, JsonExtractor<T> jsonExtractor) {
        Objects.requireNonNull(jsonInput, "jsonInput is null");
        try {
            return jsonExtractor.extract((InputStream)jsonInput.getInput());
        }
        catch (JsonParseException e) {
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> PrestoJsonExtractor<T> generateExtractor(String path, PrestoJsonExtractor<T> rootExtractor) {
        return JsonExtract.generateExtractor(path, rootExtractor, false);
    }

    public static <T> PrestoJsonExtractor<T> generateExtractor(String path, PrestoJsonExtractor<T> rootExtractor, boolean exceptionOnOutOfBounds) {
        ImmutableList tokens = ImmutableList.copyOf((Iterator)((Object)new JsonPathTokenizer(path)));
        PrestoJsonExtractor<T> jsonExtractor = rootExtractor;
        for (String token : tokens.reverse()) {
            jsonExtractor = new ObjectFieldJsonExtractor<T>(token, jsonExtractor, exceptionOnOutOfBounds);
        }
        return jsonExtractor;
    }

    private static int tryParseInt(String fieldName, int defaultValue) {
        int index = defaultValue;
        try {
            index = Integer.parseInt(fieldName);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return index;
    }

    public static class JsonSizeExtractor
    extends PrestoJsonExtractor<Long> {
        @Override
        public Long extract(JsonParser jsonParser) throws IOException {
            if (!jsonParser.hasCurrentToken()) {
                throw new JsonParseException(jsonParser, "Unexpected end of value");
            }
            if (jsonParser.getCurrentToken() == JsonToken.START_ARRAY) {
                long length = 0L;
                while (true) {
                    JsonToken token;
                    if ((token = jsonParser.nextToken()) == null) {
                        return null;
                    }
                    if (token == JsonToken.END_ARRAY) {
                        return length;
                    }
                    jsonParser.skipChildren();
                    ++length;
                }
            }
            if (jsonParser.getCurrentToken() == JsonToken.START_OBJECT) {
                long length = 0L;
                while (true) {
                    JsonToken token;
                    if ((token = jsonParser.nextToken()) == null) {
                        return null;
                    }
                    if (token == JsonToken.END_OBJECT) {
                        return length;
                    }
                    if (token == JsonToken.FIELD_NAME) {
                        ++length;
                        continue;
                    }
                    jsonParser.skipChildren();
                }
            }
            return 0L;
        }
    }

    public static class JsonValueJsonExtractor
    extends PrestoJsonExtractor<Slice> {
        @Override
        public Slice extract(JsonParser jsonParser) throws IOException {
            if (!jsonParser.hasCurrentToken()) {
                throw new JsonParseException(jsonParser, "Unexpected end of value");
            }
            DynamicSliceOutput dynamicSliceOutput = new DynamicSliceOutput(512);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JSON_FACTORY, (SliceOutput)dynamicSliceOutput);){
                jsonGenerator.copyCurrentStructure(jsonParser);
            }
            return dynamicSliceOutput.slice();
        }
    }

    public static class ScalarValueJsonExtractor
    extends PrestoJsonExtractor<Slice> {
        @Override
        public Slice extract(JsonParser jsonParser) throws IOException {
            JsonToken token = jsonParser.getCurrentToken();
            if (token == null) {
                throw new JsonParseException(jsonParser, "Unexpected end of value");
            }
            if (!token.isScalarValue() || token == JsonToken.VALUE_NULL) {
                return null;
            }
            return Slices.utf8Slice((String)jsonParser.getText());
        }
    }

    public static class ObjectFieldJsonExtractor<T>
    extends PrestoJsonExtractor<T> {
        private final SerializedString fieldName;
        private final PrestoJsonExtractor<? extends T> delegate;
        private final int index;
        private final boolean exceptionOnOutOfBounds;

        public ObjectFieldJsonExtractor(String fieldName, PrestoJsonExtractor<? extends T> delegate) {
            this(fieldName, delegate, false);
        }

        public ObjectFieldJsonExtractor(String fieldName, PrestoJsonExtractor<? extends T> delegate, boolean exceptionOnOutOfBounds) {
            this.fieldName = new SerializedString(Objects.requireNonNull(fieldName, "fieldName is null"));
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
            this.exceptionOnOutOfBounds = exceptionOnOutOfBounds;
            this.index = JsonExtract.tryParseInt(fieldName, -1);
        }

        @Override
        public T extract(JsonParser jsonParser) throws IOException {
            if (jsonParser.getCurrentToken() == JsonToken.START_OBJECT) {
                return this.processJsonObject(jsonParser);
            }
            if (jsonParser.getCurrentToken() == JsonToken.START_ARRAY) {
                return this.processJsonArray(jsonParser);
            }
            throw new JsonParseException(jsonParser, "Expected a JSON object or array");
        }

        public T processJsonObject(JsonParser jsonParser) throws IOException {
            while (!jsonParser.nextFieldName((SerializableString)this.fieldName)) {
                if (!jsonParser.hasCurrentToken()) {
                    throw new JsonParseException(jsonParser, "Unexpected end of object");
                }
                if (jsonParser.getCurrentToken() == JsonToken.END_OBJECT) {
                    return null;
                }
                jsonParser.skipChildren();
            }
            jsonParser.nextToken();
            return this.delegate.extract(jsonParser);
        }

        public T processJsonArray(JsonParser jsonParser) throws IOException {
            int currentIndex = 0;
            while (true) {
                JsonToken token;
                if ((token = jsonParser.nextToken()) == null) {
                    throw new JsonParseException(jsonParser, "Unexpected end of array");
                }
                if (token == JsonToken.END_ARRAY) {
                    if (this.exceptionOnOutOfBounds) {
                        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Index out of bounds");
                    }
                    return null;
                }
                if (currentIndex == this.index) break;
                ++currentIndex;
                jsonParser.skipChildren();
            }
            return this.delegate.extract(jsonParser);
        }
    }

    public static abstract class PrestoJsonExtractor<T>
    implements JsonExtractor<T> {
        abstract T extract(JsonParser var1) throws IOException;

        @Override
        public T extract(InputStream inputStream) throws IOException {
            try (JsonParser jsonParser = JsonUtil.createJsonParser(JSON_FACTORY, inputStream);){
                if (jsonParser.nextToken() == null) {
                    T t = null;
                    return t;
                }
                T t = this.extract(jsonParser);
                return t;
            }
        }
    }

    public static interface JsonExtractor<T> {
        public T extract(InputStream var1) throws IOException;
    }
}

