/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.window;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.BuiltInTypeAndFunctionNamespaceManager;
import com.facebook.presto.operator.window.AbstractWindowFunctionSupplier;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.ValueWindowFunction;
import com.facebook.presto.spi.function.WindowFunction;
import com.google.common.collect.Lists;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Objects;

public class ReflectionWindowFunctionSupplier<T extends WindowFunction>
extends AbstractWindowFunctionSupplier {
    private final Constructor<T> constructor;

    public ReflectionWindowFunctionSupplier(String name, Type returnType, List<? extends Type> argumentTypes, Class<T> type) {
        this(new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)name), FunctionKind.WINDOW, returnType.getTypeSignature(), Lists.transform(argumentTypes, Type::getTypeSignature)), type);
    }

    public ReflectionWindowFunctionSupplier(Signature signature, Class<T> type) {
        super(signature, ReflectionWindowFunctionSupplier.getDescription(Objects.requireNonNull(type, "type is null")));
        try {
            this.constructor = signature.getArgumentTypes().isEmpty() ? type.getConstructor(new Class[0]) : type.getConstructor(List.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    protected T newWindowFunction(List<Integer> inputs, boolean ignoreNulls) {
        try {
            WindowFunction windowFunction = this.getSignature().getArgumentTypes().isEmpty() ? (WindowFunction)this.constructor.newInstance(new Object[0]) : (WindowFunction)this.constructor.newInstance(inputs);
            if (windowFunction instanceof ValueWindowFunction) {
                ((ValueWindowFunction)windowFunction).setIgnoreNulls(ignoreNulls);
            }
            return (T)windowFunction;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getDescription(AnnotatedElement annotatedElement) {
        Description description = annotatedElement.getAnnotation(Description.class);
        return description == null ? null : description.value();
    }
}

