/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourcemanager;

import com.facebook.drift.client.DriftClient;
import com.facebook.presto.resourcemanager.ForResourceManager;
import com.facebook.presto.resourcemanager.ResourceManagerClient;
import com.facebook.presto.resourcemanager.ResourceManagerConfig;
import com.facebook.presto.util.PeriodicTaskExecutor;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class ClusterQueryTrackerService {
    private final DriftClient<ResourceManagerClient> resourceManagerClient;
    private final ScheduledExecutorService executorService;
    private final long runningTaskCountFetchIntervalMillis;
    private AtomicInteger runningTaskCount;
    private final PeriodicTaskExecutor runningTaskCountUpdater;

    @Inject
    public ClusterQueryTrackerService(@ForResourceManager DriftClient<ResourceManagerClient> resourceManagerClient, @ForResourceManager ScheduledExecutorService executorService, ResourceManagerConfig resourceManagerConfig) {
        this.resourceManagerClient = Objects.requireNonNull(resourceManagerClient, "resourceManagerClient is null");
        this.executorService = Objects.requireNonNull(executorService, "executorService is null");
        this.runningTaskCountFetchIntervalMillis = Objects.requireNonNull(resourceManagerConfig, "resourceManagerConfig is null").getRunningTaskCountFetchInterval().toMillis();
        this.runningTaskCount = new AtomicInteger(0);
        this.runningTaskCountUpdater = new PeriodicTaskExecutor(this.runningTaskCountFetchIntervalMillis, executorService, () -> this.updateRunningTaskCount());
    }

    @PostConstruct
    public void init() {
        this.runningTaskCountUpdater.start();
    }

    @PreDestroy
    public void stop() {
        this.runningTaskCountUpdater.stop();
    }

    public int getRunningTaskCount() {
        return this.runningTaskCount.get();
    }

    private void updateRunningTaskCount() {
        this.runningTaskCount.set(((ResourceManagerClient)this.resourceManagerClient.get()).getRunningTaskCount());
    }
}

