/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.event.client.ServiceUnavailableException;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.server.remotetask.Backoff;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.PrestoTransportException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import io.airlift.units.Duration;
import java.io.EOFException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class RequestErrorTracker {
    private static final Logger log = Logger.get(RequestErrorTracker.class);
    private final Object id;
    private final URI uri;
    private ErrorCodeSupplier errorCode;
    private String nodeErrorMessage;
    private final ScheduledExecutorService scheduledExecutor;
    private final String jobDescription;
    private final Backoff backoff;
    private final Queue<Throwable> errorsSinceLastSuccess = new ConcurrentLinkedQueue<Throwable>();

    public RequestErrorTracker(Object id, URI uri, ErrorCodeSupplier errorCode, String nodeErrorMessage, Duration maxErrorDuration, ScheduledExecutorService scheduledExecutor, String jobDescription) {
        this.id = Objects.requireNonNull(id, "id is null");
        this.uri = Objects.requireNonNull(uri, "uri is null");
        this.errorCode = Objects.requireNonNull(errorCode, "errorCode is null");
        this.nodeErrorMessage = Objects.requireNonNull(nodeErrorMessage, "nodeErrorMessage is null");
        this.scheduledExecutor = Objects.requireNonNull(scheduledExecutor, "scheduledExecutor is null");
        this.backoff = new Backoff(Objects.requireNonNull(maxErrorDuration, "maxErrorDuration is null"));
        this.jobDescription = Objects.requireNonNull(jobDescription, "jobDescription is null");
    }

    public static RequestErrorTracker taskRequestErrorTracker(TaskId taskId, URI taskUri, Duration maxErrorDuration, ScheduledExecutorService scheduledExecutor, String jobDescription) {
        return new RequestErrorTracker(taskId, taskUri, (ErrorCodeSupplier)StandardErrorCode.REMOTE_TASK_ERROR, "Encountered too many errors talking to a worker node. The node may have crashed or be under too much load. This is probably a transient issue, so please retry your query in a few minutes.", maxErrorDuration, scheduledExecutor, jobDescription);
    }

    public ListenableFuture<?> acquireRequestPermit() {
        long delayNanos = this.backoff.getBackoffDelayNanos();
        if (delayNanos == 0L) {
            return Futures.immediateFuture(null);
        }
        ListenableFutureTask futureTask = ListenableFutureTask.create(() -> null);
        this.scheduledExecutor.schedule((Runnable)futureTask, delayNanos, TimeUnit.NANOSECONDS);
        return futureTask;
    }

    public void startRequest() {
        if (this.backoff.getFailureCount() == 0L) {
            this.requestSucceeded();
        }
        this.backoff.startRequest();
    }

    public void requestSucceeded() {
        this.backoff.success();
        this.errorsSinceLastSuccess.clear();
    }

    public void requestFailed(Throwable reason) throws PrestoException {
        if (reason instanceof CancellationException) {
            return;
        }
        if (reason instanceof RejectedExecutionException) {
            if (reason.getMessage() == null) {
                throw new PrestoException(this.errorCode, reason);
            }
            if (!reason.getMessage().contains("Max requests queued per destination")) {
                throw new PrestoException(this.errorCode, reason);
            }
        }
        if (RequestErrorTracker.isExpectedError(reason)) {
            log.warn("Error " + this.jobDescription + " %s: %s: %s", new Object[]{this.id, reason.getMessage(), this.uri});
        } else {
            log.warn(reason, "Error " + this.jobDescription + " %s: %s", new Object[]{this.id, this.uri});
        }
        if (this.errorsSinceLastSuccess.size() < 10) {
            this.errorsSinceLastSuccess.add(reason);
        }
        if (this.backoff.failure()) {
            PrestoTransportException exception = new PrestoTransportException((ErrorCodeSupplier)StandardErrorCode.TOO_MANY_REQUESTS_FAILED, HostAddress.fromUri((URI)this.uri), String.format("%s (%s %s - %s failures, failure duration %s, total failed request time %s)", this.nodeErrorMessage, this.jobDescription, this.uri, this.backoff.getFailureCount(), this.backoff.getFailureDuration().convertTo(TimeUnit.SECONDS), this.backoff.getFailureRequestTimeTotal().convertTo(TimeUnit.SECONDS)));
            this.errorsSinceLastSuccess.forEach(((PrestoException)exception)::addSuppressed);
            throw exception;
        }
    }

    public static boolean isExpectedError(Throwable t) {
        while (t != null) {
            if (t instanceof SocketException || t instanceof SocketTimeoutException || t instanceof EOFException || t instanceof TimeoutException || t instanceof ServiceUnavailableException) {
                return true;
            }
            t = t.getCause();
        }
        return false;
    }
}

