/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.concurrent.BoundedExecutor;
import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.http.server.AsyncResponseHandler;
import com.facebook.airlift.json.Codec;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.Session;
import com.facebook.presto.connector.ConnectorTypeSerdeManager;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskManager;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.execution.TaskStatus;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.metadata.HandleResolver;
import com.facebook.presto.metadata.MetadataUpdates;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.server.ForAsyncRpc;
import com.facebook.presto.server.TaskResourceUtils;
import com.facebook.presto.server.TaskUpdateRequest;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.util.TaskUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1/task")
@RolesAllowed(value={"internal"})
public class TaskResource {
    private static final Duration ADDITIONAL_WAIT_TIME = new Duration(5.0, TimeUnit.SECONDS);
    private final TaskManager taskManager;
    private final SessionPropertyManager sessionPropertyManager;
    private final Executor responseExecutor;
    private final ScheduledExecutorService timeoutExecutor;
    private final Codec<PlanFragment> planFragmentCodec;
    private final HandleResolver handleResolver;
    private final ConnectorTypeSerdeManager connectorTypeSerdeManager;

    @Inject
    public TaskResource(TaskManager taskManager, SessionPropertyManager sessionPropertyManager, @ForAsyncRpc BoundedExecutor responseExecutor, @ForAsyncRpc ScheduledExecutorService timeoutExecutor, JsonCodec<PlanFragment> planFragmentJsonCodec, HandleResolver handleResolver, ConnectorTypeSerdeManager connectorTypeSerdeManager) {
        this.taskManager = Objects.requireNonNull(taskManager, "taskManager is null");
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.responseExecutor = (Executor)Objects.requireNonNull(responseExecutor, "responseExecutor is null");
        this.timeoutExecutor = Objects.requireNonNull(timeoutExecutor, "timeoutExecutor is null");
        this.planFragmentCodec = planFragmentJsonCodec;
        this.handleResolver = Objects.requireNonNull(handleResolver, "handleResolver is null");
        this.connectorTypeSerdeManager = Objects.requireNonNull(connectorTypeSerdeManager, "connectorTypeSerdeManager is null");
    }

    @GET
    @Consumes(value={"application/json", "application/x-jackson-smile"})
    @Produces(value={"application/json", "application/x-jackson-smile"})
    public List<TaskInfo> getAllTaskInfo(@Context UriInfo uriInfo) {
        ImmutableList allTaskInfo = this.taskManager.getAllTaskInfo();
        if (TaskResource.shouldSummarize(uriInfo)) {
            allTaskInfo = ImmutableList.copyOf((Iterable)Iterables.transform(allTaskInfo, TaskInfo::summarize));
        }
        return allTaskInfo;
    }

    @POST
    @Path(value="{taskId}")
    @Consumes(value={"application/json", "application/x-jackson-smile"})
    @Produces(value={"application/json", "application/x-jackson-smile"})
    public Response createOrUpdateTask(@PathParam(value="taskId") TaskId taskId, TaskUpdateRequest taskUpdateRequest, @Context UriInfo uriInfo) {
        Objects.requireNonNull(taskUpdateRequest, "taskUpdateRequest is null");
        Session session = taskUpdateRequest.getSession().toSession(this.sessionPropertyManager, taskUpdateRequest.getExtraCredentials());
        TaskInfo taskInfo = this.taskManager.updateTask(session, taskId, taskUpdateRequest.getFragment().map(arg_0 -> this.planFragmentCodec.fromBytes(arg_0)), taskUpdateRequest.getSources(), taskUpdateRequest.getOutputIds(), taskUpdateRequest.getTableWriteInfo());
        if (TaskResource.shouldSummarize(uriInfo)) {
            taskInfo = taskInfo.summarize();
        }
        return Response.ok().entity((Object)taskInfo).build();
    }

    @GET
    @Path(value="{taskId}")
    @Consumes(value={"application/json", "application/x-jackson-smile", "application/x-thrift+binary", "application/x-thrift+compact", "application/x-thrift+fb_compact"})
    @Produces(value={"application/json", "application/x-jackson-smile", "application/x-thrift+binary", "application/x-thrift+compact", "application/x-thrift+fb_compact"})
    public void getTaskInfo(@PathParam(value="taskId") TaskId taskId, @HeaderParam(value="X-Presto-Current-State") TaskState currentState, @HeaderParam(value="X-Presto-Max-Wait") Duration maxWait, @Context UriInfo uriInfo, @Context HttpHeaders httpHeaders, @Suspended AsyncResponse asyncResponse) {
        Objects.requireNonNull(taskId, "taskId is null");
        boolean isThriftRequest = TaskResourceUtils.isThriftRequest(httpHeaders);
        if (currentState == null || maxWait == null) {
            TaskInfo taskInfo2 = this.taskManager.getTaskInfo(taskId);
            if (TaskResource.shouldSummarize(uriInfo)) {
                taskInfo2 = taskInfo2.summarize();
            }
            if (isThriftRequest) {
                taskInfo2 = TaskResourceUtils.convertToThriftTaskInfo(taskInfo2, this.connectorTypeSerdeManager, this.handleResolver);
            }
            asyncResponse.resume((Object)taskInfo2);
            return;
        }
        Duration waitTime = TaskUtils.randomizeWaitTime(maxWait);
        ListenableFuture futureTaskInfo = MoreFutures.addTimeout(this.taskManager.getTaskInfo(taskId, currentState), () -> this.taskManager.getTaskInfo(taskId), (Duration)waitTime, (ScheduledExecutorService)this.timeoutExecutor);
        if (TaskResource.shouldSummarize(uriInfo)) {
            futureTaskInfo = Futures.transform((ListenableFuture)futureTaskInfo, TaskInfo::summarize, (Executor)MoreExecutors.directExecutor());
        }
        if (isThriftRequest) {
            futureTaskInfo = Futures.transform((ListenableFuture)futureTaskInfo, taskInfo -> TaskResourceUtils.convertToThriftTaskInfo(taskInfo, this.connectorTypeSerdeManager, this.handleResolver), (Executor)MoreExecutors.directExecutor());
        }
        Duration timeout = new Duration((double)(waitTime.toMillis() + ADDITIONAL_WAIT_TIME.toMillis()), TimeUnit.MILLISECONDS);
        AsyncResponseHandler.bindAsyncResponse((AsyncResponse)asyncResponse, (ListenableFuture)futureTaskInfo, (Executor)this.responseExecutor).withTimeout(timeout);
    }

    @GET
    @Path(value="{taskId}/status")
    @Consumes(value={"application/json", "application/x-jackson-smile", "application/x-thrift+binary", "application/x-thrift+compact", "application/x-thrift+fb_compact"})
    @Produces(value={"application/json", "application/x-jackson-smile", "application/x-thrift+binary", "application/x-thrift+compact", "application/x-thrift+fb_compact"})
    public void getTaskStatus(@PathParam(value="taskId") TaskId taskId, @HeaderParam(value="X-Presto-Current-State") TaskState currentState, @HeaderParam(value="X-Presto-Max-Wait") Duration maxWait, @Context UriInfo uriInfo, @Suspended AsyncResponse asyncResponse) {
        Objects.requireNonNull(taskId, "taskId is null");
        if (currentState == null || maxWait == null) {
            TaskStatus taskStatus = this.taskManager.getTaskStatus(taskId);
            asyncResponse.resume((Object)taskStatus);
            return;
        }
        Duration waitTime = TaskUtils.randomizeWaitTime(maxWait);
        ListenableFuture futureTaskStatus = MoreFutures.addTimeout(this.taskManager.getTaskStatus(taskId, currentState), () -> this.taskManager.getTaskStatus(taskId), (Duration)waitTime, (ScheduledExecutorService)this.timeoutExecutor);
        Duration timeout = new Duration((double)(waitTime.toMillis() + ADDITIONAL_WAIT_TIME.toMillis()), TimeUnit.MILLISECONDS);
        AsyncResponseHandler.bindAsyncResponse((AsyncResponse)asyncResponse, (ListenableFuture)futureTaskStatus, (Executor)this.responseExecutor).withTimeout(timeout);
    }

    @POST
    @Path(value="{taskId}/metadataresults")
    @Consumes(value={"application/json", "application/x-jackson-smile"})
    public Response updateMetadataResults(@PathParam(value="taskId") TaskId taskId, MetadataUpdates metadataUpdates, @Context UriInfo uriInfo) {
        Objects.requireNonNull(metadataUpdates, "metadataUpdates is null");
        this.taskManager.updateMetadataResults(taskId, metadataUpdates);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="{taskId}")
    @Consumes(value={"application/json", "application/x-jackson-smile", "application/x-thrift+binary", "application/x-thrift+compact", "application/x-thrift+fb_compact"})
    @Produces(value={"application/json", "application/x-jackson-smile", "application/x-thrift+binary", "application/x-thrift+compact", "application/x-thrift+fb_compact"})
    public TaskInfo deleteTask(@PathParam(value="taskId") TaskId taskId, @QueryParam(value="abort") @DefaultValue(value="true") boolean abort, @Context UriInfo uriInfo, @Context HttpHeaders httpHeaders) {
        Objects.requireNonNull(taskId, "taskId is null");
        TaskInfo taskInfo = abort ? this.taskManager.abortTask(taskId) : this.taskManager.cancelTask(taskId);
        if (TaskResource.shouldSummarize(uriInfo)) {
            taskInfo = taskInfo.summarize();
        }
        if (TaskResourceUtils.isThriftRequest(httpHeaders)) {
            taskInfo = TaskResourceUtils.convertToThriftTaskInfo(taskInfo, this.connectorTypeSerdeManager, this.handleResolver);
        }
        return taskInfo;
    }

    @GET
    @Path(value="{taskId}/results/{bufferId}/{token}/acknowledge")
    public void acknowledgeResults(@PathParam(value="taskId") TaskId taskId, @PathParam(value="bufferId") OutputBuffers.OutputBufferId bufferId, @PathParam(value="token") long token) {
        Objects.requireNonNull(taskId, "taskId is null");
        Objects.requireNonNull(bufferId, "bufferId is null");
        this.taskManager.acknowledgeTaskResults(taskId, bufferId, token);
    }

    @DELETE
    @Path(value="{taskId}/results/{bufferId}")
    @Produces(value={"application/json"})
    public void abortResults(@PathParam(value="taskId") TaskId taskId, @PathParam(value="bufferId") OutputBuffers.OutputBufferId bufferId, @Context UriInfo uriInfo) {
        Objects.requireNonNull(taskId, "taskId is null");
        Objects.requireNonNull(bufferId, "bufferId is null");
        this.taskManager.abortTaskResults(taskId, bufferId);
    }

    @DELETE
    @Path(value="{taskId}/remote-source/{remoteSourceTaskId}")
    public void removeRemoteSource(@PathParam(value="taskId") TaskId taskId, @PathParam(value="remoteSourceTaskId") TaskId remoteSourceTaskId) {
        Objects.requireNonNull(taskId, "taskId is null");
        Objects.requireNonNull(remoteSourceTaskId, "remoteSourceTaskId is null");
        this.taskManager.removeRemoteSource(taskId, remoteSourceTaskId);
    }

    private static boolean shouldSummarize(UriInfo uriInfo) {
        return uriInfo.getQueryParameters().containsKey((Object)"summarize");
    }
}

