/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.plan.PlanCanonicalizationStrategy;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.expressions.CanonicalRowExpressionRewriter;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.DistinctLimitNode;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.MarkDistinctNode;
import com.facebook.presto.spi.plan.Ordering;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.plan.OutputNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.CanonicalJoinNode;
import com.facebook.presto.sql.planner.CanonicalPartitioningScheme;
import com.facebook.presto.sql.planner.CanonicalPlan;
import com.facebook.presto.sql.planner.CanonicalPlanFragment;
import com.facebook.presto.sql.planner.CanonicalTableScanNode;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.RowExpressionVariableInliner;
import com.facebook.presto.sql.planner.StatsEquivalentPlanNodeWithLimit;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.plan.AssignUniqueId;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.TreeMultimap;
import com.google.common.graph.Traverser;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class CanonicalPlanGenerator
extends InternalPlanVisitor<Optional<PlanNode>, Context> {
    private final PlanNodeIdAllocator planNodeidAllocator = new PlanNodeIdAllocator();
    private final VariableAllocator variableAllocator = new VariableAllocator();
    private final PlanCanonicalizationStrategy strategy;
    private final ObjectMapper objectMapper;
    private final Session session;

    public CanonicalPlanGenerator(PlanCanonicalizationStrategy strategy, ObjectMapper objectMapper, Session session) {
        this.strategy = Objects.requireNonNull(strategy, "strategy is null");
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper is null");
        this.session = Objects.requireNonNull(session, "session is null");
    }

    public static Optional<CanonicalPlanFragment> generateCanonicalPlanFragment(PlanNode root, PartitioningScheme partitioningScheme, ObjectMapper objectMapper, Session session) {
        Context context = new Context();
        Optional canonicalPlan = (Optional)root.accept((PlanVisitor)new CanonicalPlanGenerator(PlanCanonicalizationStrategy.DEFAULT, objectMapper, session), (Object)context);
        if (!context.getExpressions().keySet().containsAll(partitioningScheme.getOutputLayout())) {
            return Optional.empty();
        }
        return canonicalPlan.map(planNode -> new CanonicalPlanFragment(new CanonicalPlan((PlanNode)planNode, PlanCanonicalizationStrategy.DEFAULT), CanonicalPartitioningScheme.getCanonicalPartitioningScheme(partitioningScheme, context.getExpressions())));
    }

    public static Optional<CanonicalPlan> generateCanonicalPlan(PlanNode root, PlanCanonicalizationStrategy strategy, ObjectMapper objectMapper, Session session) {
        Optional canonicalPlanNode = (Optional)root.accept((PlanVisitor)new CanonicalPlanGenerator(strategy, objectMapper, session), (Object)new Context());
        return canonicalPlanNode.map(planNode -> new CanonicalPlan((PlanNode)planNode, strategy));
    }

    public Optional<PlanNode> visitPlan(PlanNode node, Context context) {
        return Optional.empty();
    }

    @Override
    public Optional<PlanNode> visitStatsEquivalentPlanNodeWithLimit(StatsEquivalentPlanNodeWithLimit node, Context context) {
        if (this.strategy == PlanCanonicalizationStrategy.DEFAULT) {
            return Optional.empty();
        }
        Optional limit = (Optional)node.getLimit().accept((PlanVisitor)this, (Object)context);
        if (!limit.isPresent()) {
            return Optional.empty();
        }
        Optional plan = (Optional)node.getPlan().accept((PlanVisitor)this, (Object)context);
        if (!plan.isPresent()) {
            return Optional.empty();
        }
        StatsEquivalentPlanNodeWithLimit result = new StatsEquivalentPlanNodeWithLimit(((PlanNode)plan.get()).getId(), (PlanNode)plan.get(), (PlanNode)limit.get());
        context.addPlan(node, new CanonicalPlan(result, this.strategy));
        return Optional.of(result);
    }

    @Override
    public Optional<PlanNode> visitTableWriter(TableWriterNode node, Context context) {
        if (this.strategy == PlanCanonicalizationStrategy.DEFAULT) {
            return Optional.empty();
        }
        Optional source = (Optional)node.getSource().accept((PlanVisitor)this, (Object)context);
        if (!source.isPresent()) {
            return Optional.empty();
        }
        List columns = (List)node.getColumns().stream().map(variable -> this.rename((VariableReferenceExpression)variable, "", context)).sorted().collect(ImmutableList.toImmutableList());
        List columnNames = (List)node.getColumnNames().stream().sorted().collect(ImmutableList.toImmutableList());
        TableWriterNode result = new TableWriterNode(Optional.empty(), this.planNodeidAllocator.getNextId(), (PlanNode)source.get(), node.getTarget().map(target -> CanonicalWriterTarget.from(target)), node.getRowCountVariable(), node.getFragmentVariable(), node.getTableCommitContextVariable(), columns, columnNames, (Set<VariableReferenceExpression>)ImmutableSet.of(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        context.addPlan(node, new CanonicalPlan(result, this.strategy));
        return Optional.of(result);
    }

    @Override
    public Optional<PlanNode> visitTableFinish(TableFinishNode node, Context context) {
        if (this.strategy == PlanCanonicalizationStrategy.DEFAULT) {
            return Optional.empty();
        }
        Optional source = (Optional)node.getSource().accept((PlanVisitor)this, (Object)context);
        if (!source.isPresent()) {
            return Optional.empty();
        }
        TableFinishNode result = new TableFinishNode(Optional.empty(), this.planNodeidAllocator.getNextId(), (PlanNode)source.get(), node.getTarget().map(target -> CanonicalWriterTarget.from(target)), node.getRowCountVariable(), Optional.empty(), Optional.empty());
        context.addPlan(node, new CanonicalPlan(result, this.strategy));
        return Optional.of(result);
    }

    public Optional<PlanNode> visitLimit(LimitNode node, Context context) {
        if (this.strategy == PlanCanonicalizationStrategy.DEFAULT) {
            return Optional.empty();
        }
        Optional source = (Optional)node.getSource().accept((PlanVisitor)this, (Object)context);
        if (!source.isPresent()) {
            return Optional.empty();
        }
        LimitNode result = new LimitNode(Optional.empty(), this.planNodeidAllocator.getNextId(), (PlanNode)source.get(), node.getCount(), node.getStep());
        context.addLimitingNodePlan((PlanNode)node, new CanonicalPlan((PlanNode)result, this.strategy));
        return Optional.of(result);
    }

    public Optional<PlanNode> visitTopN(TopNNode node, Context context) {
        if (this.strategy == PlanCanonicalizationStrategy.DEFAULT) {
            return Optional.empty();
        }
        Optional source = (Optional)node.getSource().accept((PlanVisitor)this, (Object)context);
        if (!source.isPresent()) {
            return Optional.empty();
        }
        TopNNode result = new TopNNode(Optional.empty(), this.planNodeidAllocator.getNextId(), (PlanNode)source.get(), node.getCount(), CanonicalPlanGenerator.getCanonicalOrderingScheme(node.getOrderingScheme(), context.getExpressions()), node.getStep());
        context.addLimitingNodePlan((PlanNode)node, new CanonicalPlan((PlanNode)result, this.strategy));
        return Optional.of(result);
    }

    @Override
    public Optional<PlanNode> visitJoin(JoinNode node, Context context) {
        if (this.strategy == PlanCanonicalizationStrategy.DEFAULT) {
            return Optional.empty();
        }
        if (node.getType().equals((Object)JoinType.RIGHT)) {
            return this.visitJoin(node.flipChildren(), context);
        }
        List<Object> sources = new ArrayList<PlanNode>();
        ImmutableList.Builder allFilters = ImmutableList.builder();
        ImmutableList.Builder criterias = ImmutableList.builder();
        Stack<JoinNode> stack = new Stack<JoinNode>();
        stack.push(node);
        while (!stack.empty()) {
            JoinNode top = (JoinNode)((Object)stack.pop());
            top.getCriteria().forEach(arg_0 -> ((ImmutableList.Builder)criterias).add(arg_0));
            if (top.getFilter().isPresent()) {
                List filters = LogicalRowExpressions.extractConjuncts((RowExpression)top.getFilter().get());
                filters.forEach(filter -> {
                    Optional<EquiJoinClause> criteria = CanonicalPlanGenerator.toEquiJoinClause(filter);
                    criteria.ifPresent(arg_0 -> ((ImmutableList.Builder)criterias).add(arg_0));
                    allFilters.add(filter);
                });
            }
            for (PlanNode planNode : top.getSources()) {
                if (planNode instanceof JoinNode && ((JoinNode)planNode).getType().equals((Object)node.getType()) && this.shouldMergeJoinNodes(node.getType())) {
                    stack.push((JoinNode)planNode);
                    continue;
                }
                sources.add(planNode);
            }
        }
        if (this.shouldMergeJoinNodes(node.getType()) || node.getType().equals((Object)JoinType.FULL) && sources.size() == 2) {
            Optional<List<Integer>> sourceIndexes = this.orderSources(sources);
            if (!sourceIndexes.isPresent()) {
                return Optional.empty();
            }
            sources = (List)sourceIndexes.get().stream().map(sources::get).collect(ImmutableList.toImmutableList());
        }
        ImmutableList.Builder newSources = ImmutableList.builder();
        for (PlanNode planNode : sources) {
            Optional newSource = (Optional)planNode.accept((PlanVisitor)this, (Object)context);
            if (!newSource.isPresent()) {
                return Optional.empty();
            }
            newSources.add(newSource.get());
        }
        Set newCriterias = criterias.build().stream().map(criteria -> CanonicalPlanGenerator.canonicalize(criteria, context)).sorted(Comparator.comparing(EquiJoinClause::toString)).collect(Collectors.toCollection(LinkedHashSet::new));
        Set set = allFilters.build().stream().map(filter -> CanonicalPlanGenerator.inlineAndCanonicalize(context.getExpressions(), filter)).sorted(Comparator.comparing(this::writeValueAsString)).collect(Collectors.toCollection(LinkedHashSet::new));
        List outputVariables = (List)node.getOutputVariables().stream().map(variable -> CanonicalPlanGenerator.inlineAndCanonicalize(context.getExpressions(), variable)).sorted().collect(ImmutableList.toImmutableList());
        CanonicalJoinNode result = new CanonicalJoinNode(this.planNodeidAllocator.getNextId(), (List<PlanNode>)newSources.build(), node.getType(), newCriterias, set, outputVariables);
        context.addPlan(node, new CanonicalPlan(result, this.strategy));
        return Optional.of(result);
    }

    @Override
    public Optional<PlanNode> visitSemiJoin(SemiJoinNode node, Context context) {
        if (this.strategy == PlanCanonicalizationStrategy.DEFAULT) {
            return Optional.empty();
        }
        Optional source = (Optional)node.getSource().accept((PlanVisitor)this, (Object)context);
        if (!source.isPresent()) {
            return Optional.empty();
        }
        Optional filteringSource = (Optional)node.getFilteringSource().accept((PlanVisitor)this, (Object)context);
        if (!filteringSource.isPresent()) {
            return Optional.empty();
        }
        VariableReferenceExpression sourceJoinVariable = CanonicalPlanGenerator.inlineAndCanonicalize(context.getExpressions(), node.getSourceJoinVariable());
        VariableReferenceExpression filteringSourceJoinVariable = CanonicalPlanGenerator.inlineAndCanonicalize(context.getExpressions(), node.getFilteringSourceJoinVariable());
        VariableReferenceExpression semiJoinOutput = this.rename(node.getSemiJoinOutput(), "semijoinoutput", context);
        SemiJoinNode result = new SemiJoinNode(Optional.empty(), this.planNodeidAllocator.getNextId(), (PlanNode)source.get(), (PlanNode)filteringSource.get(), sourceJoinVariable, filteringSourceJoinVariable, semiJoinOutput, Optional.empty(), Optional.empty(), Optional.empty(), (Map<String, VariableReferenceExpression>)ImmutableMap.of());
        context.addPlan(node, new CanonicalPlan(result, this.strategy));
        return Optional.of(result);
    }

    public Optional<PlanNode> visitUnion(UnionNode node, Context context) {
        if (this.strategy == PlanCanonicalizationStrategy.DEFAULT) {
            return Optional.empty();
        }
        Optional<List<Integer>> sourceIndexes = this.orderSources(node.getSources());
        if (!sourceIndexes.isPresent()) {
            return Optional.empty();
        }
        ImmutableList.Builder canonicalSources = ImmutableList.builder();
        ImmutableList.Builder outputVariables = ImmutableList.builder();
        ImmutableMap.Builder outputsToInputs = ImmutableMap.builder();
        for (Integer sourceIndex : sourceIndexes.get()) {
            Optional canonicalSource = (Optional)((PlanNode)node.getSources().get(sourceIndex)).accept((PlanVisitor)this, (Object)context);
            if (!canonicalSource.isPresent()) {
                return Optional.empty();
            }
            canonicalSources.add(canonicalSource.get());
        }
        node.getVariableMapping().forEach((outputVariable, sourceVariables) -> {
            ImmutableList.Builder newSourceVariablesBuilder = ImmutableList.builder();
            ((List)sourceIndexes.get()).forEach(index -> newSourceVariablesBuilder.add((Object)CanonicalPlanGenerator.inlineAndCanonicalize(context.getExpressions(), (RowExpression)sourceVariables.get((int)index))));
            ImmutableList newSourceVariables = newSourceVariablesBuilder.build();
            VariableReferenceExpression newVariable = this.variableAllocator.newVariable((VariableReferenceExpression)newSourceVariables.get(0));
            outputVariables.add((Object)newVariable);
            context.mapExpression((VariableReferenceExpression)outputVariable, newVariable);
            outputsToInputs.put((Object)newVariable, (Object)newSourceVariables);
        });
        UnionNode result = new UnionNode(Optional.empty(), this.planNodeidAllocator.getNextId(), (List)canonicalSources.build(), (List)outputVariables.build().stream().sorted().collect(ImmutableList.toImmutableList()), (Map)ImmutableSortedMap.copyOf((Map)outputsToInputs.build()));
        context.addPlan((PlanNode)node, new CanonicalPlan((PlanNode)result, this.strategy));
        return Optional.of(result);
    }

    @Override
    public Optional<PlanNode> visitWindow(WindowNode node, Context context) {
        if (this.strategy == PlanCanonicalizationStrategy.DEFAULT) {
            return Optional.empty();
        }
        Optional source = (Optional)node.getSource().accept((PlanVisitor)this, (Object)context);
        if (!source.isPresent()) {
            return Optional.empty();
        }
        Set prePartitionedInputs = (Set)node.getPrePartitionedInputs().stream().map(variable -> CanonicalPlanGenerator.inlineAndCanonicalize(context.getExpressions(), variable)).sorted(Comparator.comparing(this::writeValueAsString)).collect(ImmutableSet.toImmutableSet());
        WindowNode.Specification specification = new WindowNode.Specification((List)node.getSpecification().getPartitionBy().stream().map(variable -> CanonicalPlanGenerator.inlineAndCanonicalize(context.getExpressions(), variable)).sorted(Comparator.comparing(this::writeValueAsString)).collect(ImmutableList.toImmutableList()), node.getOrderingScheme().map(scheme -> CanonicalPlanGenerator.getCanonicalOrderingScheme(scheme, context.getExpressions())));
        Map windowFunctions = (Map)node.getWindowFunctions().entrySet().stream().map(entry -> {
            WindowNode.Function function = (WindowNode.Function)entry.getValue();
            CallExpression callExpression = new CallExpression(Optional.empty(), function.getFunctionCall().getDisplayName(), function.getFunctionCall().getFunctionHandle(), function.getFunctionCall().getType(), (List)function.getFunctionCall().getArguments().stream().map(expression -> CanonicalPlanGenerator.inlineAndCanonicalize(context.getExpressions(), expression)).collect(ImmutableList.toImmutableList()));
            Optional<VariableReferenceExpression> startValue = function.getFrame().getStartValue().map(expression -> CanonicalPlanGenerator.inlineAndCanonicalize(context.getExpressions(), expression));
            Optional<VariableReferenceExpression> endValue = function.getFrame().getEndValue().map(expression -> CanonicalPlanGenerator.inlineAndCanonicalize(context.getExpressions(), expression));
            Optional<VariableReferenceExpression> sortKeyCoercedForFrameStartComparison = function.getFrame().getSortKeyCoercedForFrameStartComparison().map(expression -> CanonicalPlanGenerator.inlineAndCanonicalize(context.getExpressions(), expression));
            Optional<VariableReferenceExpression> sortKeyCoercedForFrameEndComparison = function.getFrame().getSortKeyCoercedForFrameEndComparison().map(expression -> CanonicalPlanGenerator.inlineAndCanonicalize(context.getExpressions(), expression));
            WindowNode.Frame frame = new WindowNode.Frame(function.getFrame().getType(), function.getFrame().getStartType(), startValue, sortKeyCoercedForFrameStartComparison, function.getFrame().getEndType(), endValue, sortKeyCoercedForFrameEndComparison, startValue.map(ignored -> ""), endValue.map(ignored -> ""));
            WindowNode.Function newFunction = new WindowNode.Function(callExpression, frame, function.isIgnoreNulls());
            return Maps.immutableEntry(entry.getKey(), (Object)newFunction);
        }).sorted(Comparator.comparing(entry -> this.writeValueAsString(entry.getValue()))).map(entry -> {
            VariableReferenceExpression variable = this.rename((VariableReferenceExpression)entry.getKey(), ((WindowNode.Function)entry.getValue()).getFunctionCall().getDisplayName(), context);
            return Maps.immutableEntry((Object)variable, entry.getValue());
        }).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        WindowNode canonicalPlan = new WindowNode(Optional.empty(), this.planNodeidAllocator.getNextId(), (PlanNode)source.get(), specification, windowFunctions, Optional.empty(), prePartitionedInputs, node.getPreSortedOrderPrefix());
        context.addPlan(node, new CanonicalPlan(canonicalPlan, this.strategy));
        return Optional.of(canonicalPlan);
    }

    public Optional<PlanNode> visitValues(ValuesNode node, Context context) {
        if (this.strategy == PlanCanonicalizationStrategy.DEFAULT) {
            return Optional.empty();
        }
        List rows = (List)node.getRows().stream().map(row -> (ImmutableList)row.stream().map(expression -> CanonicalPlanGenerator.inlineAndCanonicalize(context.getExpressions(), expression)).collect(ImmutableList.toImmutableList())).collect(ImmutableList.toImmutableList());
        List outputVariables = (List)node.getOutputVariables().stream().map(variable -> this.rename((VariableReferenceExpression)variable, "", context)).collect(ImmutableList.toImmutableList());
        ValuesNode canonicalPlan = new ValuesNode(Optional.empty(), this.planNodeidAllocator.getNextId(), outputVariables, rows, Optional.empty());
        context.addPlan((PlanNode)node, new CanonicalPlan((PlanNode)canonicalPlan, this.strategy));
        return Optional.of(canonicalPlan);
    }

    public Optional<PlanNode> visitMarkDistinct(MarkDistinctNode node, Context context) {
        if (this.strategy == PlanCanonicalizationStrategy.DEFAULT) {
            return Optional.empty();
        }
        Optional source = (Optional)node.getSource().accept((PlanVisitor)this, (Object)context);
        if (!source.isPresent()) {
            return Optional.empty();
        }
        List distinctVariables = (List)node.getDistinctVariables().stream().map(variable -> CanonicalPlanGenerator.inlineAndCanonicalize(context.getExpressions(), variable)).sorted(Comparator.comparing(this::writeValueAsString)).collect(ImmutableList.toImmutableList());
        VariableReferenceExpression markerVariable = this.rename(node.getMarkerVariable(), "is_distinct", context);
        MarkDistinctNode canonicalPlan = new MarkDistinctNode(Optional.empty(), this.planNodeidAllocator.getNextId(), (PlanNode)source.get(), markerVariable, distinctVariables, Optional.empty());
        context.addPlan((PlanNode)node, new CanonicalPlan((PlanNode)canonicalPlan, this.strategy));
        return Optional.of(canonicalPlan);
    }

    @Override
    public Optional<PlanNode> visitAssignUniqueId(AssignUniqueId node, Context context) {
        if (this.strategy == PlanCanonicalizationStrategy.DEFAULT) {
            return Optional.empty();
        }
        Optional source = (Optional)node.getSource().accept((PlanVisitor)this, (Object)context);
        if (!source.isPresent()) {
            return Optional.empty();
        }
        VariableReferenceExpression idVariable = this.rename(node.getIdVariable(), "unique", context);
        AssignUniqueId canonicalPlan = new AssignUniqueId(Optional.empty(), this.planNodeidAllocator.getNextId(), (PlanNode)source.get(), idVariable);
        context.addPlan(node, new CanonicalPlan(canonicalPlan, this.strategy));
        return Optional.of(canonicalPlan);
    }

    @Override
    public Optional<PlanNode> visitEnforceSingleRow(EnforceSingleRowNode node, Context context) {
        if (this.strategy == PlanCanonicalizationStrategy.DEFAULT) {
            return Optional.empty();
        }
        Optional source = (Optional)node.getSource().accept((PlanVisitor)this, (Object)context);
        if (!source.isPresent()) {
            return Optional.empty();
        }
        EnforceSingleRowNode canonicalPlan = new EnforceSingleRowNode(Optional.empty(), this.planNodeidAllocator.getNextId(), (PlanNode)source.get());
        context.addPlan(node, new CanonicalPlan(canonicalPlan, this.strategy));
        return Optional.of(canonicalPlan);
    }

    @Override
    public Optional<PlanNode> visitRowNumber(RowNumberNode node, Context context) {
        if (this.strategy == PlanCanonicalizationStrategy.DEFAULT) {
            return Optional.empty();
        }
        Optional source = (Optional)node.getSource().accept((PlanVisitor)this, (Object)context);
        if (!source.isPresent()) {
            return Optional.empty();
        }
        List partitionBy = (List)node.getPartitionBy().stream().map(variable -> CanonicalPlanGenerator.inlineAndCanonicalize(context.getExpressions(), variable)).sorted(Comparator.comparing(this::writeValueAsString)).collect(ImmutableList.toImmutableList());
        VariableReferenceExpression rowNumberVariable = this.rename(node.getRowNumberVariable(), "row_number", context);
        RowNumberNode canonicalPlan = new RowNumberNode(Optional.empty(), this.planNodeidAllocator.getNextId(), (PlanNode)source.get(), partitionBy, rowNumberVariable, node.getMaxRowCountPerPartition(), node.isPartial(), Optional.empty());
        context.addPlan(node, new CanonicalPlan(canonicalPlan, this.strategy));
        return Optional.of(canonicalPlan);
    }

    @Override
    public Optional<PlanNode> visitTopNRowNumber(TopNRowNumberNode node, Context context) {
        if (this.strategy == PlanCanonicalizationStrategy.DEFAULT) {
            return Optional.empty();
        }
        Optional source = (Optional)node.getSource().accept((PlanVisitor)this, (Object)context);
        if (!source.isPresent()) {
            return Optional.empty();
        }
        List partitionBy = (List)node.getPartitionBy().stream().map(variable -> CanonicalPlanGenerator.inlineAndCanonicalize(context.getExpressions(), variable)).sorted(Comparator.comparing(this::writeValueAsString)).collect(ImmutableList.toImmutableList());
        VariableReferenceExpression rowNumberVariable = this.rename(node.getRowNumberVariable(), "row_number", context);
        TopNRowNumberNode canonicalPlan = new TopNRowNumberNode(Optional.empty(), this.planNodeidAllocator.getNextId(), (PlanNode)source.get(), new WindowNode.Specification(partitionBy, node.getSpecification().getOrderingScheme().map(scheme -> CanonicalPlanGenerator.getCanonicalOrderingScheme(scheme, context.getExpressions()))), rowNumberVariable, node.getMaxRowCountPerPartition(), node.isPartial(), Optional.empty());
        context.addLimitingNodePlan(node, new CanonicalPlan(canonicalPlan, this.strategy));
        return Optional.of(canonicalPlan);
    }

    public Optional<PlanNode> visitDistinctLimit(DistinctLimitNode node, Context context) {
        if (this.strategy == PlanCanonicalizationStrategy.DEFAULT) {
            return Optional.empty();
        }
        Optional source = (Optional)node.getSource().accept((PlanVisitor)this, (Object)context);
        if (!source.isPresent()) {
            return Optional.empty();
        }
        List distinctVariables = (List)node.getDistinctVariables().stream().map(variable -> CanonicalPlanGenerator.inlineAndCanonicalize(context.getExpressions(), variable)).sorted(Comparator.comparing(this::writeValueAsString)).collect(ImmutableList.toImmutableList());
        DistinctLimitNode canonicalPlan = new DistinctLimitNode(Optional.empty(), this.planNodeidAllocator.getNextId(), (PlanNode)source.get(), node.getLimit(), node.isPartial(), distinctVariables, Optional.empty(), 0);
        context.addLimitingNodePlan((PlanNode)node, new CanonicalPlan((PlanNode)canonicalPlan, this.strategy));
        return Optional.of(canonicalPlan);
    }

    @Override
    public Optional<PlanNode> visitSort(SortNode node, Context context) {
        if (this.strategy == PlanCanonicalizationStrategy.DEFAULT) {
            return Optional.empty();
        }
        Optional source = (Optional)node.getSource().accept((PlanVisitor)this, (Object)context);
        if (!source.isPresent()) {
            return Optional.empty();
        }
        SortNode canonicalPlan = new SortNode(Optional.empty(), this.planNodeidAllocator.getNextId(), (PlanNode)source.get(), CanonicalPlanGenerator.getCanonicalOrderingScheme(node.getOrderingScheme(), context.getExpressions()), node.isPartial());
        context.addPlan(node, new CanonicalPlan(canonicalPlan, this.strategy));
        return Optional.of(canonicalPlan);
    }

    public Optional<PlanNode> visitOutput(OutputNode node, Context context) {
        if (this.strategy == PlanCanonicalizationStrategy.DEFAULT) {
            return Optional.empty();
        }
        Optional source = (Optional)node.getSource().accept((PlanVisitor)this, (Object)context);
        if (!source.isPresent()) {
            return Optional.empty();
        }
        List rowExpressionReferences = (List)node.getOutputVariables().stream().map(variable -> new RowExpressionReference((RowExpression)CanonicalPlanGenerator.inlineAndCanonicalize(context.getExpressions(), variable, this.strategy == PlanCanonicalizationStrategy.REMOVE_SAFE_CONSTANTS), (VariableReferenceExpression)variable)).sorted(Comparator.comparing(rowExpressionReference -> this.writeValueAsString(rowExpressionReference.getRowExpression()))).collect(ImmutableList.toImmutableList());
        ImmutableMap.Builder assignments = ImmutableMap.builder();
        for (RowExpressionReference rowExpressionReference2 : rowExpressionReferences) {
            VariableReferenceExpression reference = this.variableAllocator.newVariable(rowExpressionReference2.getRowExpression());
            context.mapExpression(rowExpressionReference2.getVariableReferenceExpression(), reference);
            assignments.put((Object)reference, (Object)rowExpressionReference2.getRowExpression());
        }
        ProjectNode canonicalPlan = new ProjectNode(Optional.empty(), this.planNodeidAllocator.getNextId(), (PlanNode)source.get(), new Assignments((Map)assignments.build()), ProjectNode.Locality.LOCAL);
        context.addPlan((PlanNode)node, new CanonicalPlan((PlanNode)canonicalPlan, this.strategy));
        return Optional.of(canonicalPlan);
    }

    public Optional<PlanNode> visitAggregation(AggregationNode node, Context context) {
        Optional source = (Optional)node.getSource().accept((PlanVisitor)this, (Object)context);
        if (!source.isPresent()) {
            return Optional.empty();
        }
        List aggregationReferences = (List)node.getAggregations().entrySet().stream().map(entry -> new AggregationReference(this.getCanonicalAggregation((AggregationNode.Aggregation)entry.getValue(), context.getExpressions()), (VariableReferenceExpression)entry.getKey())).sorted(Comparator.comparing(aggregationReference -> this.writeValueAsString(aggregationReference.getAggregation().getCall()))).collect(ImmutableList.toImmutableList());
        ImmutableMap.Builder aggregations = ImmutableMap.builder();
        for (AggregationReference aggregationReference2 : aggregationReferences) {
            VariableReferenceExpression reference = this.variableAllocator.newVariable((RowExpression)aggregationReference2.getAggregation().getCall());
            context.mapExpression(aggregationReference2.getVariableReferenceExpression(), reference);
            aggregations.put((Object)reference, (Object)aggregationReference2.getAggregation());
        }
        AggregationNode canonicalPlan = new AggregationNode(Optional.empty(), this.planNodeidAllocator.getNextId(), (PlanNode)source.get(), (Map)aggregations.build(), CanonicalPlanGenerator.getCanonicalGroupingSetDescriptor(node.getGroupingSets(), context.getExpressions()), (List)node.getPreGroupedVariables().stream().map(variable -> context.getExpressions().get(variable)).collect(ImmutableList.toImmutableList()), node.getStep(), node.getHashVariable().map(ignored -> this.variableAllocator.newHashVariable()), node.getGroupIdVariable().map(variable -> context.getExpressions().get(variable)), Optional.empty());
        context.addPlan((PlanNode)node, new CanonicalPlan((PlanNode)canonicalPlan, this.strategy));
        return Optional.of(canonicalPlan);
    }

    private AggregationNode.Aggregation getCanonicalAggregation(AggregationNode.Aggregation aggregation, Map<VariableReferenceExpression, VariableReferenceExpression> context) {
        return new AggregationNode.Aggregation(CanonicalPlanGenerator.inlineAndCanonicalize(context, aggregation.getCall()), aggregation.getFilter().map(filter -> CanonicalPlanGenerator.inlineAndCanonicalize(context, filter)), aggregation.getOrderBy().map(orderBy -> CanonicalPlanGenerator.getCanonicalOrderingScheme(orderBy, context)), aggregation.isDistinct(), aggregation.getMask().map(mask -> CanonicalPlanGenerator.inlineAndCanonicalize(context, mask)));
    }

    private static OrderingScheme getCanonicalOrderingScheme(OrderingScheme orderingScheme, Map<VariableReferenceExpression, VariableReferenceExpression> context) {
        return new OrderingScheme((List)orderingScheme.getOrderBy().stream().map(orderBy -> new Ordering(CanonicalPlanGenerator.inlineAndCanonicalize(context, orderBy.getVariable()), orderBy.getSortOrder())).collect(ImmutableList.toImmutableList()));
    }

    private static AggregationNode.GroupingSetDescriptor getCanonicalGroupingSetDescriptor(AggregationNode.GroupingSetDescriptor groupingSetDescriptor, Map<VariableReferenceExpression, VariableReferenceExpression> context) {
        return new AggregationNode.GroupingSetDescriptor((List)groupingSetDescriptor.getGroupingKeys().stream().map(key -> CanonicalPlanGenerator.inlineAndCanonicalize(context, key)).collect(ImmutableList.toImmutableList()), groupingSetDescriptor.getGroupingSetCount(), groupingSetDescriptor.getGlobalGroupingSets());
    }

    @Override
    public Optional<PlanNode> visitGroupId(GroupIdNode node, Context context) {
        Optional source = (Optional)node.getSource().accept((PlanVisitor)this, (Object)context);
        if (!source.isPresent()) {
            return Optional.empty();
        }
        ImmutableMap.Builder groupingColumns = ImmutableMap.builder();
        for (Map.Entry<VariableReferenceExpression, VariableReferenceExpression> entry : node.getGroupingColumns().entrySet()) {
            VariableReferenceExpression variableReferenceExpression = context.getExpressions().get(entry.getValue());
            VariableReferenceExpression reference = this.variableAllocator.newVariable((RowExpression)variableReferenceExpression, "gid");
            context.mapExpression(entry.getKey(), reference);
            groupingColumns.put((Object)reference, (Object)variableReferenceExpression);
        }
        ImmutableList.Builder groupingSets = ImmutableList.builder();
        for (List<VariableReferenceExpression> list : node.getGroupingSets()) {
            groupingSets.add(list.stream().map(variable -> context.getExpressions().get(variable)).collect(ImmutableList.toImmutableList()));
        }
        VariableReferenceExpression variableReferenceExpression = this.variableAllocator.newVariable("groupid", (Type)IntegerType.INTEGER);
        context.mapExpression(node.getGroupIdVariable(), variableReferenceExpression);
        GroupIdNode groupIdNode = new GroupIdNode(Optional.empty(), this.planNodeidAllocator.getNextId(), (PlanNode)source.get(), (List<List<VariableReferenceExpression>>)groupingSets.build(), (Map<VariableReferenceExpression, VariableReferenceExpression>)groupingColumns.build(), (List)node.getAggregationArguments().stream().map(variable -> context.getExpressions().get(variable)).collect(ImmutableList.toImmutableList()), variableReferenceExpression);
        context.addPlan(node, new CanonicalPlan(groupIdNode, this.strategy));
        return Optional.of(groupIdNode);
    }

    @Override
    public Optional<PlanNode> visitUnnest(UnnestNode node, Context context) {
        Optional source = (Optional)node.getSource().accept((PlanVisitor)this, (Object)context);
        if (!source.isPresent()) {
            return Optional.empty();
        }
        ImmutableMap.Builder newUnnestVariables = ImmutableMap.builder();
        for (Map.Entry<VariableReferenceExpression, List<VariableReferenceExpression>> unnestVariable : node.getUnnestVariables().entrySet()) {
            VariableReferenceExpression input = (VariableReferenceExpression)CanonicalPlanGenerator.inlineAndCanonicalize(context.getExpressions(), (RowExpression)unnestVariable.getKey());
            ImmutableList.Builder newVariables = ImmutableList.builder();
            for (VariableReferenceExpression variable2 : unnestVariable.getValue()) {
                VariableReferenceExpression newVariable = this.variableAllocator.newVariable(Optional.empty(), "unnest_field", variable2.getType());
                context.mapExpression(variable2, newVariable);
                newVariables.add((Object)newVariable);
            }
            newUnnestVariables.put((Object)input, (Object)newVariables.build());
        }
        Optional<VariableReferenceExpression> ordinalityVariable = node.getOrdinalityVariable().map(variable -> {
            VariableReferenceExpression newVariable = this.variableAllocator.newVariable(Optional.empty(), "unnest_ordinality", variable.getType());
            context.mapExpression((VariableReferenceExpression)variable, newVariable);
            return newVariable;
        });
        UnnestNode canonicalPlan = new UnnestNode(Optional.empty(), this.planNodeidAllocator.getNextId(), (PlanNode)source.get(), (List)node.getReplicateVariables().stream().map(variable -> CanonicalPlanGenerator.inlineAndCanonicalize(context.getExpressions(), variable)).collect(ImmutableList.toImmutableList()), (Map<VariableReferenceExpression, List<VariableReferenceExpression>>)newUnnestVariables.build(), ordinalityVariable);
        context.addPlan(node, new CanonicalPlan(canonicalPlan, this.strategy));
        return Optional.of(canonicalPlan);
    }

    public Optional<PlanNode> visitProject(ProjectNode node, Context context) {
        Optional source = (Optional)node.getSource().accept((PlanVisitor)this, (Object)context);
        if (!source.isPresent()) {
            return Optional.empty();
        }
        List rowExpressionReferences = (List)node.getAssignments().entrySet().stream().map(entry -> new RowExpressionReference(CanonicalPlanGenerator.inlineAndCanonicalize(context.getExpressions(), (RowExpression)entry.getValue(), this.strategy == PlanCanonicalizationStrategy.REMOVE_SAFE_CONSTANTS), (VariableReferenceExpression)entry.getKey())).sorted(Comparator.comparing(rowExpressionReference -> this.writeValueAsString(rowExpressionReference.getRowExpression()))).collect(ImmutableList.toImmutableList());
        ImmutableMap.Builder assignments = ImmutableMap.builder();
        for (RowExpressionReference rowExpressionReference2 : rowExpressionReferences) {
            VariableReferenceExpression reference = this.variableAllocator.newVariable(rowExpressionReference2.getRowExpression());
            context.mapExpression(rowExpressionReference2.getVariableReferenceExpression(), reference);
            assignments.put((Object)reference, (Object)rowExpressionReference2.getRowExpression());
        }
        ProjectNode canonicalPlan = new ProjectNode(Optional.empty(), this.planNodeidAllocator.getNextId(), (PlanNode)source.get(), new Assignments((Map)assignments.build()), node.getLocality());
        context.addPlan((PlanNode)node, new CanonicalPlan((PlanNode)canonicalPlan, this.strategy));
        return Optional.of(canonicalPlan);
    }

    private Optional<List<Integer>> orderSources(List<PlanNode> sources) {
        Optional<List<Integer>> sourcesByTables = this.orderSourcesByTables(sources);
        if (sourcesByTables.isPresent()) {
            return sourcesByTables;
        }
        if (!SystemSessionProperties.usePerfectlyConsistentHistories(this.session)) {
            return Optional.of(IntStream.range(0, sources.size()).boxed().collect(ImmutableList.toImmutableList()));
        }
        TreeMultimap sourceToPosition = TreeMultimap.create();
        for (int i = 0; i < sources.size(); ++i) {
            Optional<CanonicalPlan> canonicalSource = CanonicalPlanGenerator.generateCanonicalPlan(sources.get(i), this.strategy, this.objectMapper, this.session);
            if (!canonicalSource.isPresent()) {
                return Optional.empty();
            }
            sourceToPosition.put((Object)canonicalSource.get().toString(this.objectMapper), (Object)i);
        }
        return Optional.of(sourceToPosition.values().stream().collect(ImmutableList.toImmutableList()));
    }

    private Optional<List<Integer>> orderSourcesByTables(List<PlanNode> sources) {
        TreeMultimap sourceToPosition = TreeMultimap.create();
        for (int i = 0; i < sources.size(); ++i) {
            ArrayList tables = new ArrayList();
            PlanNodeSearcher.searchFrom(sources.get(i)).where(node -> node instanceof TableScanNode).findAll().forEach(node -> tables.add(((TableScanNode)node).getTable().getConnectorHandle().toString()));
            sourceToPosition.put((Object)tables.stream().sorted().collect(Collectors.joining(",")), (Object)i);
        }
        String lastIdentifier = ",";
        for (Map.Entry entry : sourceToPosition.entries()) {
            String identifier = (String)entry.getKey();
            if (lastIdentifier.equals(identifier)) {
                return Optional.empty();
            }
            lastIdentifier = identifier;
        }
        return Optional.of(sourceToPosition.values().stream().collect(ImmutableList.toImmutableList()));
    }

    public Optional<PlanNode> visitFilter(FilterNode node, Context context) {
        Optional source = (Optional)node.getSource().accept((PlanVisitor)this, (Object)context);
        if (!source.isPresent()) {
            return Optional.empty();
        }
        FilterNode canonicalPlan = new FilterNode(Optional.empty(), this.planNodeidAllocator.getNextId(), (PlanNode)source.get(), CanonicalPlanGenerator.inlineAndCanonicalize(context.getExpressions(), node.getPredicate()));
        context.addPlan((PlanNode)node, new CanonicalPlan((PlanNode)canonicalPlan, this.strategy));
        return Optional.of(canonicalPlan);
    }

    public Optional<PlanNode> visitTableScan(TableScanNode node, Context context) {
        List columnReferences = (List)node.getAssignments().entrySet().stream().map(entry -> new ColumnReference((ColumnHandle)entry.getValue(), (VariableReferenceExpression)entry.getKey())).sorted(Comparator.comparing(columnReference -> columnReference.getColumnHandle().toString())).collect(ImmutableList.toImmutableList());
        ImmutableList.Builder outputVariables = ImmutableList.builder();
        ImmutableMap.Builder assignments = ImmutableMap.builder();
        for (ColumnReference columnReference2 : columnReferences) {
            VariableReferenceExpression reference = this.variableAllocator.newVariable(Optional.empty(), columnReference2.getColumnHandle().toString(), columnReference2.getVariableReferenceExpression().getType());
            context.mapExpression(columnReference2.getVariableReferenceExpression(), reference);
            outputVariables.add((Object)reference);
            assignments.put((Object)reference, (Object)columnReference2.getColumnHandle());
        }
        CanonicalTableScanNode canonicalPlan = new CanonicalTableScanNode(Optional.empty(), this.planNodeidAllocator.getNextId(), CanonicalTableScanNode.CanonicalTableHandle.getCanonicalTableHandle(node.getTable(), this.strategy), (List<VariableReferenceExpression>)outputVariables.build(), (Map<VariableReferenceExpression, ColumnHandle>)assignments.build());
        context.addPlan((PlanNode)node, new CanonicalPlan(canonicalPlan, this.strategy));
        return Optional.of(canonicalPlan);
    }

    private boolean shouldMergeJoinNodes(JoinType type) {
        return type.equals((Object)JoinType.INNER);
    }

    private VariableReferenceExpression rename(VariableReferenceExpression variable, String nameHint, Context context) {
        VariableReferenceExpression newVariable = this.variableAllocator.newVariable(Optional.empty(), nameHint, variable.getType());
        context.mapExpression(variable, newVariable);
        return newVariable;
    }

    private String writeValueAsString(Object object) {
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.PLAN_SERIALIZATION_ERROR, "Cannot serialize plan to JSON", (Throwable)e);
        }
    }

    private static EquiJoinClause canonicalize(EquiJoinClause criteria, Context context) {
        VariableReferenceExpression right;
        VariableReferenceExpression left = CanonicalPlanGenerator.inlineAndCanonicalize(context.getExpressions(), criteria.getLeft());
        return left.compareTo(right = CanonicalPlanGenerator.inlineAndCanonicalize(context.getExpressions(), criteria.getRight())) > 0 ? new EquiJoinClause(left, right) : new EquiJoinClause(right, left);
    }

    private static Optional<EquiJoinClause> toEquiJoinClause(RowExpression expression) {
        boolean isValid;
        if (!(expression instanceof CallExpression)) {
            return Optional.empty();
        }
        CallExpression callExpression = (CallExpression)expression;
        boolean bl = isValid = callExpression.getDisplayName().equals(OperatorType.EQUAL.getFunctionName().getObjectName()) && callExpression.getArguments().size() == 2 && callExpression.getArguments().get(0) instanceof VariableReferenceExpression && callExpression.getArguments().get(1) instanceof VariableReferenceExpression;
        if (!isValid) {
            return Optional.empty();
        }
        return Optional.of(new EquiJoinClause((VariableReferenceExpression)callExpression.getArguments().get(0), (VariableReferenceExpression)callExpression.getArguments().get(1)));
    }

    private static <T extends RowExpression> T inlineAndCanonicalize(Map<VariableReferenceExpression, VariableReferenceExpression> context, T expression) {
        return CanonicalPlanGenerator.inlineAndCanonicalize(context, expression, false);
    }

    private static <T extends RowExpression> T inlineAndCanonicalize(Map<VariableReferenceExpression, VariableReferenceExpression> context, T expression, boolean removeConstants) {
        return (T)CanonicalRowExpressionRewriter.canonicalizeRowExpression((RowExpression)RowExpressionVariableInliner.inlineVariables(variable -> context.getOrDefault(variable, (VariableReferenceExpression)variable), expression), (boolean)removeConstants);
    }

    public static class Context {
        private final Map<VariableReferenceExpression, VariableReferenceExpression> expressions = new HashMap<VariableReferenceExpression, VariableReferenceExpression>();
        private final Map<PlanNode, CanonicalPlan> canonicalPlans = new IdentityHashMap<PlanNode, CanonicalPlan>();
        private final Map<PlanNode, PlanNode> canonicalPlanToPlan = new IdentityHashMap<PlanNode, PlanNode>();
        private final Map<PlanNode, List<TableScanNode>> inputTables = new IdentityHashMap<PlanNode, List<TableScanNode>>();

        public Map<VariableReferenceExpression, VariableReferenceExpression> getExpressions() {
            return this.expressions;
        }

        public Map<PlanNode, CanonicalPlan> getCanonicalPlans() {
            return this.canonicalPlans;
        }

        public Map<PlanNode, List<TableScanNode>> getInputTables() {
            return this.inputTables;
        }

        public void mapExpression(VariableReferenceExpression from, VariableReferenceExpression to) {
            this.expressions.put(from, to);
        }

        private void addLimitingNodePlan(PlanNode limit, CanonicalPlan canonicalPlan) {
            if (!limit.getStatsEquivalentPlanNode().isPresent()) {
                this.addPlanInternal(limit, canonicalPlan);
                return;
            }
            PlanNode statsEquivalentPlanNode = (PlanNode)limit.getStatsEquivalentPlanNode().get();
            StatsEquivalentPlanNodeWithLimit statsEquivalentPlanNodeWithLimit = (StatsEquivalentPlanNodeWithLimit)statsEquivalentPlanNode;
            if (this.childrenCount(statsEquivalentPlanNodeWithLimit.getLimit()) != this.childrenCount(statsEquivalentPlanNodeWithLimit.getPlan())) {
                this.addPlanInternal(limit, canonicalPlan);
                return;
            }
            Traverser.forTree(PlanNode::getSources).depthFirstPreOrder((Object)limit).forEach(child -> {
                CanonicalPlan childCanonicalPlan;
                CanonicalPlan canonicalPlan2 = childCanonicalPlan = child == limit ? canonicalPlan : this.canonicalPlans.get(child);
                if (childCanonicalPlan == null || !child.getStatsEquivalentPlanNode().isPresent()) {
                    return;
                }
                this.canonicalPlans.remove(child);
                this.inputTables.remove(child);
                this.addPlanInternal((PlanNode)child.getStatsEquivalentPlanNode().get(), new CanonicalPlan(new StatsEquivalentPlanNodeWithLimit(childCanonicalPlan.getPlan().getId(), childCanonicalPlan.getPlan(), canonicalPlan.getPlan()), canonicalPlan.getStrategy()));
            });
        }

        private void addPlan(PlanNode plan, CanonicalPlan canonicalPlan) {
            if (!plan.getStatsEquivalentPlanNode().isPresent()) {
                this.addPlanInternal(plan, canonicalPlan);
                return;
            }
            PlanNode statsEquivalentPlanNode = (PlanNode)plan.getStatsEquivalentPlanNode().get();
            if (this.childrenCount(plan) == this.childrenCount(statsEquivalentPlanNode)) {
                this.addPlanInternal(statsEquivalentPlanNode, canonicalPlan);
            } else {
                this.addPlanInternal(plan, canonicalPlan);
            }
        }

        private int childrenCount(PlanNode root) {
            return Iterables.size((Iterable)Traverser.forTree(PlanNode::getSources).depthFirstPreOrder((Object)root));
        }

        private void addPlanInternal(PlanNode plan, CanonicalPlan canonicalPlan) {
            ImmutableList.Builder inputs = ImmutableList.builder();
            this.canonicalPlans.put(plan, canonicalPlan);
            this.canonicalPlanToPlan.put(canonicalPlan.getPlan(), plan);
            for (PlanNode node : Traverser.forTree(PlanNode::getSources).depthFirstPreOrder((Object)canonicalPlan.getPlan())) {
                if (!(node instanceof CanonicalTableScanNode) || !this.canonicalPlanToPlan.containsKey(node)) continue;
                inputs.add((Object)((TableScanNode)this.canonicalPlanToPlan.get(node)));
            }
            this.inputTables.put(plan, (List<TableScanNode>)inputs.build());
        }
    }

    private static class ColumnReference {
        private final ColumnHandle columnHandle;
        private final VariableReferenceExpression variableReferenceExpression;

        public ColumnReference(ColumnHandle columnHandle, VariableReferenceExpression variableReferenceExpression) {
            this.columnHandle = Objects.requireNonNull(columnHandle, "columnHandle is null");
            this.variableReferenceExpression = Objects.requireNonNull(variableReferenceExpression, "variableReferenceExpression is null");
        }

        public ColumnHandle getColumnHandle() {
            return this.columnHandle;
        }

        public VariableReferenceExpression getVariableReferenceExpression() {
            return this.variableReferenceExpression;
        }
    }

    private static class RowExpressionReference {
        private final RowExpression rowExpression;
        private final VariableReferenceExpression variableReferenceExpression;

        public RowExpressionReference(RowExpression rowExpression, VariableReferenceExpression variableReferenceExpression) {
            this.rowExpression = Objects.requireNonNull(rowExpression, "rowExpression is null");
            this.variableReferenceExpression = Objects.requireNonNull(variableReferenceExpression, "variableReferenceExpression is null");
        }

        public RowExpression getRowExpression() {
            return this.rowExpression;
        }

        public VariableReferenceExpression getVariableReferenceExpression() {
            return this.variableReferenceExpression;
        }
    }

    private static class CanonicalWriterTarget
    extends TableWriterNode.WriterTarget {
        private final ConnectorId connectorId;
        private final String writerTargetType;

        @JsonCreator
        public CanonicalWriterTarget(@JsonProperty(value="connectorId") ConnectorId connectorId, @JsonProperty(value="writerTargetType") String writerTargetType) {
            this.connectorId = connectorId;
            this.writerTargetType = writerTargetType;
        }

        @Override
        @JsonProperty
        public ConnectorId getConnectorId() {
            return this.connectorId;
        }

        @JsonProperty
        public String getWriterTargetType() {
            return this.writerTargetType;
        }

        @Override
        public SchemaTableName getSchemaTableName() {
            return new SchemaTableName("schema", "table");
        }

        @Override
        public String toString() {
            return String.format("WriterTarget{connectorId: %s, type: %s}", this.connectorId, this.writerTargetType);
        }

        private static CanonicalWriterTarget from(TableWriterNode.WriterTarget target) {
            return new CanonicalWriterTarget(target.getConnectorId(), target.getClass().getSimpleName());
        }
    }

    private static class AggregationReference {
        private final AggregationNode.Aggregation aggregation;
        private final VariableReferenceExpression variableReferenceExpression;

        public AggregationReference(AggregationNode.Aggregation aggregation, VariableReferenceExpression variableReferenceExpression) {
            this.aggregation = Objects.requireNonNull(aggregation, "aggregation is null");
            this.variableReferenceExpression = Objects.requireNonNull(variableReferenceExpression, "variableReferenceExpression is null");
        }

        public AggregationNode.Aggregation getAggregation() {
            return this.aggregation;
        }

        public VariableReferenceExpression getVariableReferenceExpression() {
            return this.variableReferenceExpression;
        }
    }
}

