/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.relation.RowExpression;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class SortExpressionContext {
    private final RowExpression sortExpression;
    private final List<RowExpression> searchExpressions;

    public SortExpressionContext(RowExpression sortExpression, List<RowExpression> searchExpressions) {
        this.sortExpression = Objects.requireNonNull(sortExpression, "sortExpression can not be null");
        this.searchExpressions = ImmutableList.copyOf(searchExpressions);
    }

    public RowExpression getSortExpression() {
        return this.sortExpression;
    }

    public List<RowExpression> getSearchExpressions() {
        return this.searchExpressions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortExpressionContext that = (SortExpressionContext)o;
        return Objects.equals(this.sortExpression, that.sortExpression) && Objects.equals(this.searchExpressions, that.searchExpressions);
    }

    public int hashCode() {
        return Objects.hash(this.sortExpression, this.searchExpressions);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sortExpression", (Object)this.sortExpression).add("searchExpressions", this.searchExpressions).toString();
    }
}

