/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.relational.SqlToRowExpressionTranslator;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.Table;
import com.google.common.annotations.VisibleForTesting;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class SqlPlannerContext {
    private int leafNodesInLogicalPlan;
    private final SqlToRowExpressionTranslator.Context translatorContext;
    private final CteInfo cteInfo;

    public SqlPlannerContext(int leafNodesInLogicalPlan) {
        this.leafNodesInLogicalPlan = leafNodesInLogicalPlan;
        this.translatorContext = new SqlToRowExpressionTranslator.Context();
        this.cteInfo = new CteInfo();
    }

    public CteInfo getCteInfo() {
        return this.cteInfo;
    }

    public SqlToRowExpressionTranslator.Context getTranslatorContext() {
        return this.translatorContext;
    }

    public void incrementLeafNodes(Session session) {
        ++this.leafNodesInLogicalPlan;
        if (SystemSessionProperties.isLeafNodeLimitEnabled(session) && this.leafNodesInLogicalPlan > SystemSessionProperties.getMaxLeafNodesInPlan(session)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.EXCEEDED_PLAN_NODE_LIMIT, String.format("Number of leaf nodes in logical plan exceeds threshold %s set in max_leaf_nodes_in_plan", SystemSessionProperties.getMaxLeafNodesInPlan(session)));
        }
    }

    public class CteInfo {
        @VisibleForTesting
        public static final String delimiter = "_*%$_";
        private int currentQueryScopeId;
        Map<TreeSet<Query>, String> queryNodeScopeIdMap = new HashMap<TreeSet<Query>, String>();

        public String normalize(Analysis analysis, Query query, String cteName) {
            QueryReferenceCollectorContext context = new QueryReferenceCollectorContext();
            context.getReferencedQuerySet().add(query);
            query.accept((AstVisitor)new QueryReferenceCollector(analysis), (Object)context);
            TreeSet<Query> normalizedKey = context.getReferencedQuerySet();
            if (!this.queryNodeScopeIdMap.containsKey(normalizedKey)) {
                this.queryNodeScopeIdMap.put(normalizedKey, String.valueOf(this.currentQueryScopeId++));
            }
            return this.queryNodeScopeIdMap.get(normalizedKey) + delimiter + cteName;
        }

        private class QueryReferenceCollectorContext {
            private final TreeSet<Query> referencedQuerySet = new TreeSet<Query>(Comparator.comparingInt(Query::hashCode));

            public void addQuery(Query ref) {
                this.referencedQuerySet.add(ref);
            }

            public TreeSet<Query> getReferencedQuerySet() {
                return this.referencedQuerySet;
            }
        }

        private class QueryReferenceCollector
        extends DefaultTraversalVisitor<Void, QueryReferenceCollectorContext> {
            private final Analysis analysis;

            public QueryReferenceCollector(Analysis analysis) {
                this.analysis = analysis;
            }

            protected Void visitTable(Table node, QueryReferenceCollectorContext context) {
                Analysis.NamedQuery namedQuery = this.analysis.getNamedQuery(node);
                if (namedQuery != null) {
                    context.addQuery(namedQuery.getQuery());
                    this.process((Node)namedQuery.getQuery(), context);
                }
                return null;
            }
        }
    }
}

