/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.SymbolReference;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;

public class Symbol
implements Comparable<Symbol> {
    private final Optional<NodeLocation> nodeLocation;
    private final String name;

    public static Symbol from(Expression expression) {
        Preconditions.checkArgument((boolean)(expression instanceof SymbolReference), (String)"Unexpected expression: %s", (Object)expression);
        return new Symbol(expression.getLocation(), ((SymbolReference)expression).getName());
    }

    public Symbol(String name) {
        this(Optional.empty(), name);
    }

    @JsonCreator
    public Symbol(Optional<NodeLocation> nodeLocation, String name) {
        this.nodeLocation = nodeLocation;
        Objects.requireNonNull(name, "name is null");
        this.name = name;
    }

    @JsonValue
    public String getName() {
        return this.name;
    }

    public SymbolReference toSymbolReference() {
        return new SymbolReference(this.nodeLocation, this.name);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Symbol symbol = (Symbol)o;
        return this.name.equals(symbol.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(Symbol o) {
        return this.name.compareTo(o.name);
    }

    public Optional<NodeLocation> getNodeLocation() {
        return this.nodeLocation;
    }
}

